% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtendedABSurvTDC.R
\name{ExtendedCoxPred}
\alias{ExtendedCoxPred}
\title{ExtendedABCoxPH Prediction}
\usage{
ExtendedCoxPred(Model, NewData)
}
\arguments{
\item{Model}{ExtendedABCoxPH model}

\item{NewData}{New data}
}
\value{
\itemize{
  \item SurvProb - Survival probabilities
}
}
\description{
Prediction for ExtendedABCoxPH model
}
\examples{
library("ExtendedABSurvTDC")
load(system.file("extdata", "data.RData", package = "ExtendedABSurvTDC"))
PropData<-DataPrep(data =as.data.frame(data_test))
model<-ExtendedABSurvTDC(PropData)
Lact_1<-c("Yes","Yes","Yes","No","No","No","No","No","No","No","No")
Lact_2<-c("No","No","No","No","Yes","Yes","No","No","No","No","No")
Lact_3<-c("No","No","No","No","No","No","No","No","Yes","Yes","Yes")
Lact_4<-c("No","No","No","No","No","No","No","No","No","No","No")
Lact_5<-c("No","No","No","No","No","No","No","No","No","No","No")
Lact_6<-c("No","No","No","No","No","No","No","No","No","No","No")
Lact_7<-c("No","No","No","No","No","No","No","No","No","No","No")
Lact_8<-c("No","No","No","No","No","No","No","No","No","No","No")
Lact_9<-c("No","No","No","No","No","No","No","No","No","No","No")
ndata<- data.frame(Lact_1,Lact_2,Lact_3,Lact_4,Lact_5,Lact_6,Lact_7,
                   Lact_8,Lact_9)
NewData<-ndata
HYS<-2033
AFC <- 1400
Y=as.factor(1)
S=as.factor(1)
H=as.factor(1)
NewData_default <- data.frame(AFC, Y, S, NewData) # Data for default argument of "factors"
ExtendedCoxPred(Model=model, NewData=NewData_default)

}
\references{
\itemize{
\item J.D. Kalbfleisch and R.L. Prentice (1980). The statistical analysis of failure time data. John Wiley & Sons, Inc., New York, 1980.  DOI: 10.1002/9781118032985
\item J.P. Klein and  M L. Moeschberger (2003). Survival Analysis: Techniques for Censored and Truncated Data. Springer New York, DOI:10.1007/b97377
}
}
