ui = fluidPage(theme = teachingApps::add_theme(getShinyOption("theme")), 
               teachingApps::add_css(),

sidebarLayout(
  sidebarPanel(width = 3,

  sliderInput("range.egeng", 
              label = "Range",
              min =  0, 
              max = 50, 
              value = c(0,25)),
  sliderInput("mu.egeng", 
              label = h2(HTML("&mu;")),
              min = 0, 
              max = 10, 
              step = 0.5, 
              value = 1, 
              animate = TRUE),
  sliderInput("sig.egeng", 
              label = h2(HTML("&sigma;")),
              min = 0.5, 
              max = 10, 
              step = 0.5, 
              value = 1, 
              animate = TRUE),
  sliderInput("lam.egeng", 
              label = h2(HTML("&lambda;")),
              min = .5, 
              max = 10, 
              step = 0.5, 
              value = 1,
              animate = TRUE)),
  mainPanel(width = 9,
 tabsetPanel(type = 'pills',
  tabPanel('Distribution Function',metricsgraphicsOutput("egengC",height = "600px")),
  tabPanel('Density',              metricsgraphicsOutput("egengP",height = "600px")),
  tabPanel('Survival',             metricsgraphicsOutput("egengR",height = "600px")),
  tabPanel('Hazard',               metricsgraphicsOutput("egengh",height = "600px")),
  tabPanel('Cumulative Hazard',    metricsgraphicsOutput("egengH",height = "600px")),
  tabPanel('Quantile',             metricsgraphicsOutput("egengQ",height = "600px"))
  ))))
