/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import com.github.javacliparser.FileOption;
import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Prediction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.Random;
import moa.classifiers.MultiTargetLearnerSemiSupervised;
import moa.core.Example;
import moa.core.Measurement;
import moa.core.ObjectRepository;
import moa.core.TimingUtils;
import moa.evaluation.EWMAClassificationPerformanceEvaluator;
import moa.evaluation.FadingFactorClassificationPerformanceEvaluator;
import moa.evaluation.LearningEvaluation;
import moa.evaluation.LearningPerformanceEvaluator;
import moa.evaluation.MultiTargetPerformanceEvaluator;
import moa.evaluation.WindowClassificationPerformanceEvaluator;
import moa.evaluation.preview.LearningCurve;
import moa.options.ClassOption;
import moa.streams.ExampleStream;
import moa.streams.MultiTargetInstanceStream;
import moa.tasks.MultiTargetMainTask;
import moa.tasks.TaskMonitor;

public class EvaluatePrequentialMultiTargetSemiSuper
extends MultiTargetMainTask {
    private static final long serialVersionUID = 1L;
    public ClassOption learnerOption = new ClassOption("learner", 'l', "Learner to train.", MultiTargetLearnerSemiSupervised.class, "moa.classifiers.rules.multilabel.AMRulesMultiTargetRegressorSemiSuper");
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to learn from.", MultiTargetInstanceStream.class, "MultiTargetArffFileStream");
    public ClassOption evaluatorOption = new ClassOption("evaluator", 'e', "Classification performance evaluation method.", MultiTargetPerformanceEvaluator.class, "BasicMultiTargetPerformanceEvaluator");
    public IntOption instanceLimitOption = new IntOption("instanceLimit", 'i', "Maximum number of instances to test/train on  (-1 = no limit).", 100000000, -1, Integer.MAX_VALUE);
    public IntOption timeLimitOption = new IntOption("timeLimit", 't', "Maximum number of seconds to test/train for (-1 = no limit).", -1, -1, Integer.MAX_VALUE);
    public IntOption sampleFrequencyOption = new IntOption("sampleFrequency", 'f', "How many instances between samples of the learning performance.", 100000, 0, Integer.MAX_VALUE);
    public IntOption memCheckFrequencyOption = new IntOption("memCheckFrequency", 'q', "How many instances between memory bound checks.", 100000, 0, Integer.MAX_VALUE);
    public FileOption dumpFileOption = new FileOption("dumpFile", 'd', "File to append intermediate csv results to.", null, "csv", true);
    public FileOption outputPredictionFileOption = new FileOption("outputPredictionFile", 'o', "File to append output predictions to.", null, "pred", true);
    public IntOption widthOption = new IntOption("width", 'w', "Size of Window", 1000);
    public FloatOption alphaOption = new FloatOption("alpha", 'a', "Fading factor or exponential smoothing factor", 0.01);
    public FloatOption unlabeledPercentage = new FloatOption("WithoutTarget", 'z', "Without target percentage(%)", 50.0);
    public FloatOption dbInitialModelPercentage = new FloatOption("DBPercent", 'D', "Initial dataset (%)", 30.0);
    public IntOption runSeed = new IntOption("Seed", 'r', "Number of predictions", 1);
    public IntOption slidingWindowSize = new IntOption("slidingWindowSize", 'W', "slidingWindowSize", 1000);
    public IntOption slidingWindowStep = new IntOption("slidingWindowStep", 'j', "slidingWindowStep", 1);

    @Override
    public String getPurposeString() {
        return "Multi-target Prequential semi-supervised evaluation \n Phase1: Creates a initial model with <dbInitialModelPercentage> of the instances in the dataset\n Phase2: When a instance is received: A binary random process with a binomial distribution selects if the instance should be  labeled or unlabeled with probability <unlabeledPercentage>.";
    }

    @Override
    public Class<?> getTaskResultType() {
        return LearningCurve.class;
    }

    @Override
    protected Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        Example trainInst;
        long evaluateStartTime;
        MultiTargetLearnerSemiSupervised learner = (MultiTargetLearnerSemiSupervised)this.getPreparedClassOption(this.learnerOption);
        ExampleStream stream = (ExampleStream)this.getPreparedClassOption(this.streamOption);
        LearningPerformanceEvaluator evaluator = (LearningPerformanceEvaluator)this.getPreparedClassOption(this.evaluatorOption);
        LearningCurve learningCurve = new LearningCurve("learning evaluation instances");
        if (evaluator instanceof WindowClassificationPerformanceEvaluator && this.widthOption.getValue() != 1000) {
            System.out.println("DEPRECATED! Use EvaluatePrequential -e (WindowClassificationPerformanceEvaluator -w " + this.widthOption.getValue() + ")");
            return learningCurve;
        }
        if (evaluator instanceof EWMAClassificationPerformanceEvaluator && this.alphaOption.getValue() != 0.01) {
            System.out.println("DEPRECATED! Use EvaluatePrequential -e (EWMAClassificationPerformanceEvaluator -a " + this.alphaOption.getValue() + ")");
            return learningCurve;
        }
        if (evaluator instanceof FadingFactorClassificationPerformanceEvaluator && this.alphaOption.getValue() != 0.01) {
            System.out.println("DEPRECATED! Use EvaluatePrequential -e (FadingFactorClassificationPerformanceEvaluator -a " + this.alphaOption.getValue() + ")");
            return learningCurve;
        }
        learner.setModelContext(stream.getHeader());
        int maxInstances = this.instanceLimitOption.getValue();
        long instancesProcessed = 0L;
        int maxSeconds = this.timeLimitOption.getValue();
        int secondsElapsed = 0;
        monitor.setCurrentActivity("Evaluating learner...", -1.0);
        File dumpFile = this.dumpFileOption.getFile();
        PrintStream immediateResultStream = null;
        if (dumpFile != null) {
            try {
                immediateResultStream = dumpFile.exists() ? new PrintStream(new FileOutputStream(dumpFile, true), true) : new PrintStream(new FileOutputStream(dumpFile), true);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to open immediate result file: " + dumpFile, ex);
            }
        }
        File outputPredictionFile = this.outputPredictionFileOption.getFile();
        PrintStream outputPredictionResultStream = null;
        if (outputPredictionFile != null) {
            try {
                outputPredictionResultStream = outputPredictionFile.exists() ? new PrintStream(new FileOutputStream(outputPredictionFile, true), true) : new PrintStream(new FileOutputStream(outputPredictionFile), true);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to open prediction result file: " + outputPredictionFile, ex);
            }
        }
        boolean firstDump = true;
        boolean preciseCPUTiming = TimingUtils.enablePreciseTiming();
        long lastEvaluateStartTime = evaluateStartTime = TimingUtils.getNanoCPUTimeOfCurrentThread();
        double RAMHours = 0.0;
        Random randomGenerator1 = new Random(this.runSeed.getValue());
        Random randomGenerator2 = new Random(1L);
        LinkedList<Double> slidingWindow = new LinkedList<Double>();
        int StrmDtSz = 0;
        while (stream.hasMoreInstances()) {
            stream.nextInstance();
            ++StrmDtSz;
        }
        Example[] streamData = new Example[StrmDtSz];
        int[] randIndex = new int[StrmDtSz];
        int i = 0;
        stream.restart();
        while (stream.hasMoreInstances()) {
            streamData[i] = stream.nextInstance();
            ++i;
        }
        for (int ri = 0; ri < StrmDtSz; ++ri) {
            randIndex[ri] = ri;
        }
        if (this.runSeed.getValue() > 0) {
            for (int ri = 0; ri < randIndex.length; ++ri) {
                int randomIndex = randomGenerator1.nextInt(randIndex.length);
                int randomValue = randIndex[randomIndex];
                randIndex[randomIndex] = randIndex[ri];
                randIndex[ri] = randomValue;
            }
        }
        double errorAllSum = 0.0;
        int examplesCounter = 0;
        Example testInst = trainInst = streamData[randIndex[0]];
        Instance inst = (Instance)testInst.getData();
        while ((double)examplesCounter < this.dbInitialModelPercentage.getValue() / 100.0 * (double)StrmDtSz) {
            testInst = trainInst = streamData[randIndex[examplesCounter]];
            inst = (Instance)testInst.getData();
            learner.trainOnInstance(trainInst);
            if (++examplesCounter > 1) {
                Prediction trainPrediction = learner.getTrainingPrediction();
                double sumDenominator = 0.0;
                double sumNumerator = 0.0;
                for (int m = 0; m < inst.numOutputAttributes(); ++m) {
                    sumNumerator += Math.pow(inst.valueOutputAttribute(m) - trainPrediction.getVote(m, 0), 2.0);
                    sumDenominator += Math.pow(inst.valueOutputAttribute(m), 2.0);
                }
                errorAllSum += Math.sqrt(sumNumerator / sumDenominator);
                slidingWindow.add(Math.sqrt(sumNumerator / sumDenominator));
                if (slidingWindow.size() == this.slidingWindowSize.getValue() + 1) {
                    slidingWindow.remove(0);
                }
            }
            if (examplesCounter % this.slidingWindowStep.getValue() != 0) continue;
            double windowMean = 0.0;
            for (int j = 0; j < slidingWindow.size(); ++j) {
                windowMean += ((Double)slidingWindow.get(j)).doubleValue();
            }
        }
        double[] exampleOutputs = new double[inst.numOutputAttributes()];
        while (examplesCounter < StrmDtSz - 1) {
            testInst = trainInst = streamData[randIndex[examplesCounter]];
            inst = (Instance)testInst.getData();
            Prediction prediction = learner.getPredictionForInstance(testInst);
            evaluator.addResult(testInst, prediction);
            if (randomGenerator2.nextDouble() <= this.unlabeledPercentage.getValue() / 100.0) {
                for (int m = 0; m < inst.numOutputAttributes(); ++m) {
                    inst.setClassValue(m, Double.NEGATIVE_INFINITY);
                }
            }
            ++examplesCounter;
            learner.trainOnInstance(trainInst);
            if (++instancesProcessed % (long)this.sampleFrequencyOption.getValue() == 0L) {
                long evaluateTime = TimingUtils.getNanoCPUTimeOfCurrentThread();
                double time = TimingUtils.nanoTimeToSeconds(evaluateTime - evaluateStartTime);
                double timeIncrement = TimingUtils.nanoTimeToSeconds(evaluateTime - lastEvaluateStartTime);
                double RAMHoursIncrement = (double)learner.measureByteSize() / 1.073741824E9;
                lastEvaluateStartTime = evaluateTime;
                learningCurve.insertEntry(new LearningEvaluation(new Measurement[]{new Measurement("learning evaluation instances", instancesProcessed), new Measurement("evaluation time (" + (preciseCPUTiming ? "cpu " : "") + "seconds)", time), new Measurement("model cost (RAM-Hours)", RAMHours += (RAMHoursIncrement *= timeIncrement / 3600.0))}, evaluator, learner));
                if (immediateResultStream != null) {
                    if (firstDump) {
                        immediateResultStream.println(learningCurve.headerToString());
                        firstDump = false;
                    }
                    immediateResultStream.println(learningCurve.entryToString(learningCurve.numEntries() - 1));
                    immediateResultStream.flush();
                }
            }
            if (instancesProcessed % 10L != 0L) continue;
            if (monitor.taskShouldAbort()) {
                return null;
            }
            long estimatedRemainingInstances = stream.estimatedRemainingInstances();
            if (maxInstances > 0) {
                long maxRemaining = (long)maxInstances - instancesProcessed;
                if (estimatedRemainingInstances < 0L || maxRemaining < estimatedRemainingInstances) {
                    estimatedRemainingInstances = maxRemaining;
                }
            }
            monitor.setCurrentActivityFractionComplete(estimatedRemainingInstances < 0L ? -1.0 : (double)instancesProcessed / (double)(instancesProcessed + estimatedRemainingInstances));
            if (monitor.resultPreviewRequested()) {
                monitor.setLatestResultPreview(learningCurve.copy());
            }
            secondsElapsed = (int)TimingUtils.nanoTimeToSeconds(TimingUtils.getNanoCPUTimeOfCurrentThread() - evaluateStartTime);
        }
        long evaluateTime = TimingUtils.getNanoCPUTimeOfCurrentThread();
        double time = TimingUtils.nanoTimeToSeconds(evaluateTime - evaluateStartTime);
        double timeIncrement = TimingUtils.nanoTimeToSeconds(evaluateTime - lastEvaluateStartTime);
        double RAMHoursIncrement = (double)learner.measureByteSize() / 1.073741824E9;
        lastEvaluateStartTime = evaluateTime;
        learningCurve.insertEntry(new LearningEvaluation(new Measurement[]{new Measurement("learning evaluation instances", instancesProcessed), new Measurement("evaluation time (" + (preciseCPUTiming ? "cpu " : "") + "seconds)", time), new Measurement("model cost (RAM-Hours)", RAMHours += (RAMHoursIncrement *= timeIncrement / 3600.0))}, evaluator, learner));
        if (immediateResultStream != null) {
            if (firstDump) {
                immediateResultStream.println(learningCurve.headerToString());
                firstDump = false;
            }
            immediateResultStream.println(learningCurve.entryToString(learningCurve.numEntries() - 1));
            immediateResultStream.flush();
        }
        StringBuilder sb = new StringBuilder();
        learner.getDescription(sb, 0);
        System.out.println(sb.toString());
        if (immediateResultStream != null) {
            immediateResultStream.close();
        }
        if (outputPredictionResultStream != null) {
            outputPredictionResultStream.close();
        }
        return learningCurve;
    }
}

