/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.active;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import moa.evaluation.MeasureCollection;

public class MeasureOverview
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MeasureCollection[] measures;
    private int measureCollectionSelected;
    private String variedParamName;
    private double[] variedParamValues;
    private JPanel contentPanel;
    private JScrollPane scrollPane;
    private ButtonGroup radioGroup;
    private JRadioButton[] radioButtons;
    private JLabel[] currentValues;
    private JLabel[] meanValues;
    private JLabel labelMeasure;
    private JLabel labelCurrent;
    private JLabel labelMean;
    private JComboBox<String> paramBox;

    public MeasureOverview(MeasureCollection[] measures, String variedParamName, double[] variedParamValues) {
        int i;
        this.setBorder(BorderFactory.createTitledBorder("Values"));
        this.setPreferredSize(new Dimension(250, 115));
        this.setLayout(new BoxLayout(this, 3));
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setPreferredSize(new Dimension(270, 180));
        this.contentPanel = new JPanel();
        this.contentPanel.setPreferredSize(new Dimension(100, 105));
        this.contentPanel.setLayout(new GridBagLayout());
        this.scrollPane.setViewportView(this.contentPanel);
        this.paramBox = new JComboBox();
        this.paramBox.setMaximumSize(new Dimension(this.paramBox.getMaximumSize().width, this.paramBox.getPreferredSize().height));
        this.paramBox.setEnabled(false);
        this.paramBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                MeasureOverview.this.measureCollectionSelected = cb.getSelectedIndex();
                if (MeasureOverview.this.measureCollectionSelected == -1) {
                    MeasureOverview.this.measureCollectionSelected = 0;
                }
                MeasureOverview.this.update();
            }
        });
        this.add(this.scrollPane);
        this.add(this.paramBox);
        this.labelMeasure = new JLabel("Measure");
        this.labelCurrent = new JLabel("Current");
        this.labelMean = new JLabel("Mean");
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 0;
        this.contentPanel.add((Component)this.labelMeasure, gb);
        gb.gridx = 1;
        this.contentPanel.add((Component)this.labelCurrent, gb);
        gb.gridx = 2;
        this.contentPanel.add((Component)this.labelMean, gb);
        this.measures = measures;
        this.measureCollectionSelected = 0;
        this.variedParamName = variedParamName;
        this.variedParamValues = variedParamValues;
        if (measures == null || measures.length == 0) {
            return;
        }
        int numMeasures = measures[0].getNumMeasures();
        this.radioGroup = new ButtonGroup();
        this.radioButtons = new JRadioButton[numMeasures];
        gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.anchor = 17;
        for (i = 0; i < numMeasures; ++i) {
            JRadioButton rb = new JRadioButton(measures[0].getName(i));
            rb.setBorder(BorderFactory.createLineBorder(Color.RED));
            rb.setActionCommand(Integer.toString(i));
            this.radioButtons[i] = rb;
            gb.gridy = 1 + i;
            this.contentPanel.add((Component)rb, gb);
            this.radioGroup.add(rb);
        }
        this.radioButtons[0].setSelected(true);
        this.currentValues = new JLabel[numMeasures];
        this.meanValues = new JLabel[numMeasures];
        gb = new GridBagConstraints();
        gb.weightx = 1.0;
        for (i = 0; i < numMeasures; ++i) {
            gb.gridy = 1 + i;
            this.currentValues[i] = new JLabel("-");
            this.currentValues[i].setHorizontalAlignment(0);
            gb.gridx = 1;
            this.contentPanel.add((Component)this.currentValues[i], gb);
            this.meanValues[i] = new JLabel("-");
            this.meanValues[i].setHorizontalAlignment(0);
            gb.gridx = 2;
            this.contentPanel.add((Component)this.meanValues[i], gb);
        }
        this.contentPanel.setPreferredSize(new Dimension(250, this.currentValues.length * 22 + 20));
        this.updateParamBox();
    }

    public void setActionListener(ActionListener listener) {
        for (int i = 0; i < this.radioButtons.length; ++i) {
            this.radioButtons[i].addActionListener(listener);
        }
    }

    public void update(MeasureCollection[] measures, String variedParamName, double[] variedParamValues) {
        this.measures = measures;
        this.variedParamName = variedParamName;
        this.variedParamValues = variedParamValues;
        this.update();
        this.updateParamBox();
    }

    public void update() {
        if (this.measures == null || this.measures.length == 0) {
            for (int i = 0; i < this.currentValues.length; ++i) {
                this.currentValues[i].setText("-");
                this.meanValues[i].setText("-");
            }
            return;
        }
        DecimalFormat d = new DecimalFormat("0.00");
        MeasureCollection mc = this.measures.length > this.measureCollectionSelected ? this.measures[this.measureCollectionSelected] : this.measures[0];
        for (int i = 0; i < this.currentValues.length; ++i) {
            if (Double.isNaN(mc.getLastValue(i))) {
                this.currentValues[i].setText("-");
            } else {
                this.currentValues[i].setText(d.format(mc.getLastValue(i)));
            }
            if (Double.isNaN(mc.getMean(i))) {
                this.meanValues[i].setText("-");
                continue;
            }
            this.meanValues[i].setText(d.format(mc.getMean(i)));
        }
    }

    private void updateParamBox() {
        if (this.variedParamValues == null || this.variedParamValues.length == 0) {
            this.paramBox.removeAllItems();
            this.paramBox.setEnabled(false);
        } else if (this.paramBox.getItemCount() != this.variedParamValues.length) {
            this.paramBox.removeAllItems();
            for (int i = 0; i < this.variedParamValues.length; ++i) {
                this.paramBox.addItem(String.format("%s: %s", this.variedParamName, this.variedParamValues[i]));
            }
            this.paramBox.setEnabled(true);
        }
    }
}

