/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;

public class IntHeap {
    Comp comp;
    TIntArrayList heap = new TIntArrayList();
    TIntArrayList indices = new TIntArrayList();

    public IntHeap(Comp comp) {
        this.comp = comp;
    }

    public int size() {
        return this.heap.size();
    }

    public boolean isEmpty() {
        return this.heap.size() == 0;
    }

    public boolean contains(int n) {
        return n < this.indices.size() && this.indices.get(n) >= 0;
    }

    public int get(int pos) {
        return this.heap.get(pos);
    }

    public void decrease(int n) {
        assert (this.contains(n));
        this.percolateUp(this.indices.get(n));
    }

    public void increase(int n) {
        assert (this.contains(n));
        this.percolateDown(this.indices.get(n));
    }

    public void update(int n) {
        if (!this.contains(n)) {
            this.insert(n);
        } else {
            this.percolateUp(this.indices.get(n));
            this.percolateDown(this.indices.get(n));
        }
    }

    public void insert(int n) {
        int k = this.indices.size();
        if (k <= n) {
            this.indices.fill(k, n + 1, -1);
        }
        assert (!this.contains(n));
        this.indices.set(n, this.heap.size());
        this.heap.add(n);
        this.percolateUp(this.indices.get(n));
    }

    public int removeMin() {
        int x = this.heap.get(0);
        this.heap.set(0, this.heap.get(this.heap.size() - 1));
        this.indices.set(this.heap.get(0), 0);
        this.indices.set(x, -1);
        this.heap.removeAt(this.heap.size() - 1);
        if (this.heap.size() > 1) {
            this.percolateDown(0);
        }
        return x;
    }

    public void build(TIntList elements) {
        int i;
        this.clear();
        for (i = 0; i < elements.size(); ++i) {
            this.indices.set(elements.get(i), i);
            this.heap.add(elements.get(i));
        }
        for (i = this.heap.size() / 2 - 1; i >= 0; --i) {
            this.percolateDown(i);
        }
    }

    public void clear() {
        for (int i = 0; i < this.heap.size(); ++i) {
            this.indices.set(this.heap.get(i), -1);
        }
        this.heap.clear();
    }

    private static int left(int i) {
        return (i << 1) + 1;
    }

    private static int right(int i) {
        return i + 1 << 1;
    }

    private static int parent(int i) {
        return i - 1 >> 1;
    }

    private void percolateUp(int i) {
        int x = this.heap.get(i);
        int p = IntHeap.parent(i);
        while (i != 0 && this.comp.lt(x, this.heap.get(p))) {
            this.heap.set(i, this.heap.get(p));
            this.indices.set(this.heap.get(p), i);
            i = p;
            p = IntHeap.parent(p);
        }
        this.heap.set(i, x);
        this.indices.set(x, i);
    }

    private void percolateDown(int i) {
        int x = this.heap.get(i);
        while (IntHeap.left(i) < this.heap.size()) {
            int child;
            int n = child = IntHeap.right(i) < this.heap.size() && this.comp.lt(this.heap.get(IntHeap.right(i)), this.heap.get(IntHeap.left(i))) ? IntHeap.right(i) : IntHeap.left(i);
            if (!this.comp.lt(this.heap.get(child), x)) break;
            this.heap.set(i, this.heap.get(child));
            this.indices.set(this.heap.get(i), i);
            i = child;
        }
        this.heap.set(i, x);
        this.indices.set(x, i);
    }

    @FunctionalInterface
    public static interface Comp {
        public boolean lt(int var1, int var2);
    }
}

