/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import java.util.function.ToDoubleBiFunction;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.bandit.Policy;
import org.chocosolver.util.tools.ArrayUtils;

public class MultiArmedBanditSequencer<V extends Variable>
extends AbstractStrategy<V>
implements IMonitorRestart {
    private final Policy bandit;
    private final ToDoubleBiFunction<Integer, Integer> reward;
    private final AbstractStrategy<V>[] strategies;
    private int action;
    private int step;

    @SafeVarargs
    private static <V extends Variable> V[] make(AbstractStrategy<V> ... strategies) {
        Variable[] vars = new Variable[]{};
        for (AbstractStrategy<V> strategy : strategies) {
            vars = ArrayUtils.append(vars, strategy.vars);
        }
        return vars;
    }

    public MultiArmedBanditSequencer(AbstractStrategy<V>[] strategies, Policy bandit, ToDoubleBiFunction<Integer, Integer> reward) {
        super(MultiArmedBanditSequencer.make((AbstractStrategy[])strategies));
        this.bandit = bandit;
        this.strategies = strategies;
        this.step = 0;
        this.action = 0;
        this.reward = reward;
    }

    @Override
    public boolean init() {
        this.vars[0].getModel().getSolver().plugMonitor(this);
        boolean ok = true;
        for (AbstractStrategy<V> strategy : this.strategies) {
            ok &= strategy.init();
        }
        this.bandit.init();
        return ok;
    }

    @Override
    public void remove() {
        this.vars[0].getModel().getSolver().unplugMonitor(this);
        for (AbstractStrategy<V> strategy : this.strategies) {
            strategy.remove();
        }
    }

    @Override
    protected Decision<V> computeDecision(V variable) {
        if (variable == null || variable.isInstantiated()) {
            return null;
        }
        return this.strategies[this.action].computeDecision(variable);
    }

    @Override
    public Decision<V> getDecision() {
        return this.strategies[this.action].getDecision();
    }

    @Override
    public void afterRestart() {
        ++this.step;
        this.bandit.update(this.action, this.reward.applyAsDouble(this.action, this.step));
        this.action = this.bandit.nextAction(this.step);
    }
}

