/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.R;

import eu.kliegr.ac1.R.Rinterface;
import eu.kliegr.ac1.rule.CBARuleComparator;
import eu.kliegr.ac1.rule.TestRules;
import eu.kliegr.ac1.rule.TestingType;
import eu.kliegr.ac1.rule.parsers.GenericRuleParser;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RinterfacePredict
extends Rinterface {
    private static final Logger LOGGER = Logger.getLogger(RinterfacePredict.class.getName());
    Comparator ruleComparator = new CBARuleComparator();
    TestRules testRulesObj;
    TestingType ttype;

    public RinterfacePredict(String[] att_types, String targetColName, String IDcolumnName, String loglevel) throws Exception {
        super(att_types, targetColName, IDcolumnName, loglevel);
    }

    public String[] predictWithRulesFromFile(String path, String testingType) throws Exception {
        TestingType ttype = TestingType.valueOf(testingType);
        if (this.data.getDataTable() == null) {
            throw new Exception("Load data first");
        }
        TestRules testRulesObj = new TestRules(GenericRuleParser.parseFileForRules(path, this.data), new CBARuleComparator(), this.data);
        testRulesObj.classifyData(ttype);
        String[] result = testRulesObj.getResult();
        LOGGER.log(Level.INFO, "Result dimensionality:{0}", result.length);
        return result;
    }

    public String[] predict() throws Exception {
        boolean sort = false;
        this.ttype = TestingType.firstMatch;
        LOGGER.log(Level.INFO, "Predict invoked");
        LOGGER.log(Level.INFO, "Transaction count:{0}", this.data.getDataTable().getCurrentTransactionCount());
        if (this.data.getDataTable() == null) {
            throw new Exception("Load data first");
        }
        if (this.rules == null) {
            throw new Exception("Load rules first");
        }
        String[] result = null;
        try {
            this.testRulesObj = new TestRules(this.rules, this.ruleComparator, this.data);
            if (sort) {
                this.testRulesObj.sortRules();
            }
            int lastRuleIndex = this.testRulesObj.getRules().size() - 1;
            for (int i = 0; i <= lastRuleIndex; ++i) {
                int curAntLen;
                if (i == lastRuleIndex & (curAntLen = this.testRulesObj.getRules().get(i).getAntecedentLength()) != 0) {
                    LOGGER.warning("Last rule not default rule");
                    throw new Exception("Last rule not default rule");
                }
                if (!(i != lastRuleIndex & curAntLen == 0)) continue;
                LOGGER.warning("Default rule on other position than last");
                throw new Exception("Default rule on other position than last");
            }
            this.testRulesObj.classifyData(this.ttype);
            result = this.testRulesObj.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOGGER.log(Level.INFO, "Result dimensionality:{0}", result.length);
        return result;
    }

    public String[] getFiringRuleString() throws Exception {
        LOGGER.log(Level.INFO, "getFiringRule invoked");
        LOGGER.log(Level.INFO, "Transaction count:{0}", this.data.getDataTable().getCurrentTransactionCount());
        if (this.data.getDataTable() == null) {
            throw new Exception("Load data first");
        }
        if (this.rules == null) {
            throw new Exception("Load rules first");
        }
        if (this.testRulesObj == null) {
            throw new Exception("Call predict first");
        }
        if (this.ttype != TestingType.firstMatch) {
            throw new Exception("Applicable only to TestingType.firstMatch");
        }
        String[] result = null;
        try {
            result = this.testRulesObj.getFiringRuleString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOGGER.log(Level.INFO, "Result dimensionality:{0}", result.length);
        return result;
    }

    public String[] getFiringRuleID() throws Exception {
        LOGGER.log(Level.INFO, "getFiringRule invoked");
        LOGGER.log(Level.INFO, "Transaction count:{0}", this.data.getDataTable().getCurrentTransactionCount());
        if (this.data.getDataTable() == null) {
            throw new Exception("Load data first");
        }
        if (this.rules == null) {
            throw new Exception("Load rules first");
        }
        if (this.testRulesObj == null) {
            throw new Exception("Call predict first");
        }
        if (this.ttype != TestingType.firstMatch) {
            throw new Exception("Applicable only to TestingType.firstMatch");
        }
        String[] result = null;
        try {
            result = this.testRulesObj.getFiringRuleID();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        LOGGER.log(Level.INFO, "Result dimensionality:{0}", result.length);
        return result;
    }
}

