/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.PSCSA;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Pair;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;

public class PSCSAGenerator
extends PrototypeGenerator {
    private int k;
    private double HyperMutationRate;
    private double ClonalRate;
    private double MUTATION_RATE;
    private String StimulationFunc;
    private double STIMULATION_THRESHOLD;
    private int MaxIter;
    private int ParticleSize;
    private double alpha;
    protected int numberOfClass;
    private double[] AS;
    protected int numberOfPrototypes;
    private String[] paramsOfInitialReducction = null;

    public PSCSAGenerator(PrototypeSet _trainingDataSet, int neigbors, int poblacion, int perc, int iteraciones, double F, double CR, int strg) {
        super(_trainingDataSet);
        this.algorithmName = "PSCSA";
        this.k = neigbors;
        this.numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
    }

    public PSCSAGenerator(PrototypeSet t, Parameters parameters) {
        super(t, parameters);
        this.algorithmName = "PSCSA";
        this.k = parameters.getNextAsInt();
        this.HyperMutationRate = parameters.getNextAsDouble();
        this.ClonalRate = parameters.getNextAsDouble();
        this.MUTATION_RATE = parameters.getNextAsDouble();
        this.STIMULATION_THRESHOLD = parameters.getNextAsDouble();
        this.numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
        this.alpha = parameters.getNextAsDouble();
        this.numberOfPrototypes = this.getSetSizeFromPercentage(this.ParticleSize);
        this.AS = new double[this.numberOfClass];
        PrototypeSet[] clases = new PrototypeSet[this.numberOfClass];
        for (int i = 0; i < this.numberOfClass; ++i) {
            clases[i] = this.trainingDataSet.getFromClass(i);
            String[][] clasesS = clases[i].to8GrayString();
            for (int j = 0; j < clases[i].size(); ++j) {
                for (int k = j + 1; k < clases[i].size(); ++k) {
                    int n = i;
                    this.AS[n] = this.AS[n] + this.stimString2(clasesS[j], clasesS[k]);
                }
            }
            int n = i;
            this.AS[n] = this.AS[n] / (double)clases[i].size();
            this.AS[i] = 1.0 / this.AS[i];
        }
        System.out.print("\nIsaac dice:  " + this.k + "HYrate= " + this.HyperMutationRate + " Stimulation=  " + this.StimulationFunc);
    }

    public double stimString(String[][] binario, int index, String[][] binarioTrain, int pIndex) {
        double hamming = 0.0;
        for (int i = 0; i < binario[index].length; ++i) {
            for (int j = 0; j < binario[index][i].length(); ++j) {
                double valor1 = Character.getNumericValue(binario[index][i].charAt(j));
                double valor2 = Character.getNumericValue(binarioTrain[pIndex][i].charAt(j));
                hamming += Math.abs(valor1 - valor2);
            }
        }
        int maxHaming = ((Prototype)this.trainingDataSet.get(0)).numberOfInputs() * 8;
        hamming = 1.0 - 1.0 * hamming / (double)maxHaming;
        return hamming;
    }

    public double stimString2(String[] binario, String[] binarioTrain) {
        double hamming = 0.0;
        for (int i = 0; i < binario.length; ++i) {
            for (int j = 0; j < binario[i].length(); ++j) {
                int valor1 = Character.getNumericValue(binario[i].charAt(j));
                int valor2 = Character.getNumericValue(binarioTrain[i].charAt(j));
                hamming += (double)Math.abs(valor1 - valor2);
            }
        }
        int maxHaming = ((Prototype)this.trainingDataSet.get(0)).numberOfInputs() * 8;
        hamming = 1.0 - 1.0 * hamming / (double)maxHaming;
        return hamming;
    }

    public double stim(Prototype agi, Prototype mj) {
        double hamming = 0.0;
        if (this.StimulationFunc.equals("Hamming")) {
            for (int i = 0; i < agi.numberOfInputs(); ++i) {
                hamming += Math.abs(agi.getInput(i) - mj.getInput(i));
            }
        } else {
            hamming = Distance.euclideanDistance(agi, mj);
        }
        if (hamming == 0.0) {
            return 1.0;
        }
        return 1.0 / hamming;
    }

    public Pair<String[][], double[]> HyperMutation(String[] mmatch, double classMatch, String[] agk, double classAgk, int proliferation) {
        Pair<Object, Object> salida;
        int numClones = 0;
        double claseGenerada = 0.0;
        numClones = proliferation == 1 ? (int)(this.HyperMutationRate * this.ClonalRate * this.stimString2(agk, mmatch)) : (int)(this.ClonalRate * this.stimString2(agk, mmatch));
        String[][] B = new String[numClones][mmatch.length];
        double[] clasesB = new double[numClones];
        int generados = 0;
        while (generados < numClones) {
            String[] bj = new String[mmatch.length];
            salida = this.mutate(mmatch, agk, claseGenerada);
            Boolean mut = (Boolean)salida.second();
            if (!mut.booleanValue()) continue;
            B[generados] = (String[])salida.first();
            double random = RandomGenerator.Randdouble(0.0, 1.0);
            double clase = RandomGenerator.Randint(0, this.numberOfClass);
            clasesB[generados] = random < this.MUTATION_RATE ? clase : classAgk;
            ++generados;
        }
        salida = new Pair<String[][], double[]>(B, clasesB);
        return salida;
    }

    public Pair<String[], Boolean> mutate(String[] Mmatch, String[] agk, double claseBj) {
        Boolean flag = false;
        String[] bj = new String[Mmatch.length];
        for (int i = 0; i < bj.length; ++i) {
            bj[i] = new String("");
            for (int j = 0; j < Mmatch[i].length(); ++j) {
                double random = RandomGenerator.Randdouble(0.0, 1.0);
                int valor1 = Character.getNumericValue(Mmatch[i].charAt(j));
                if (random < this.MUTATION_RATE) {
                    if (valor1 == 0) {
                        int n = i;
                        bj[n] = bj[n] + "1";
                    } else {
                        int n = i;
                        bj[n] = bj[n] + "0";
                    }
                    flag = true;
                } else {
                    int n = i;
                    bj[n] = bj[n] + Mmatch[i].charAt(j);
                }
                if (!flag.booleanValue()) continue;
                random = RandomGenerator.Randdouble(0.0, 1.0);
                double clase = RandomGenerator.Randint(0, this.numberOfClass - 1);
                if (!(random < this.MUTATION_RATE)) continue;
                claseBj = clase;
            }
        }
        Pair<String[], Boolean> part = new Pair<String[], Boolean>(bj, flag);
        return part;
    }

    public Pair<String[][], double[]> ResourceAllocation(String[][] B, double[] clasesB, String[] agk, double claseAgk) {
        int i;
        double[] stim = new double[B.length];
        double[] resources = new double[B.length];
        double minStim = Double.MAX_VALUE;
        double maxStim = Double.MIN_VALUE;
        for (i = 0; i < B.length; ++i) {
            stim[i] = this.stimString2(agk, B[i]);
            if (stim[i] < minStim) {
                minStim = stim[i];
            }
            if (!(stim[i] > maxStim)) continue;
            maxStim = stim[i];
        }
        for (i = 0; i < B.length; ++i) {
            stim[i] = clasesB[i] == claseAgk ? (stim[i] - minStim) / (maxStim - minStim) : 1.0 - (stim[i] - minStim) / (maxStim - minStim);
            resources[i] = stim[i] * this.ClonalRate * 1.0;
        }
        double clases = 0.0;
        int[] borrar = new int[B.length];
        int utilborrar = -1;
        double totalNumResources = 0.0;
        for (int i2 = 0; i2 < B.length; ++i2) {
            totalNumResources += resources[i2];
        }
        while (clases < (double)this.numberOfClass) {
            double resAllocated = 0.0;
            for (int i3 = 0; i3 < B.length; ++i3) {
                if (clasesB[i3] != clases) continue;
                resAllocated += resources[i3];
            }
            double numResAllowed = clases == claseAgk ? totalNumResources / 2.0 : totalNumResources / (2.0 * (double)(this.numberOfClass - 1));
            double numResRemove = 2.0;
            double recursosRemovidos = -1.0;
            for (int iter = 50; resAllocated > numResAllowed && iter > 0; --iter) {
                numResRemove = resAllocated - numResAllowed;
                double min = Double.MAX_VALUE;
                int remove = -1;
                for (int i4 = 0; i4 < B.length; ++i4) {
                    boolean seguir = true;
                    if (utilborrar != -1) {
                        for (int j = 0; j <= utilborrar && seguir; ++j) {
                            if (i4 != borrar[j]) continue;
                            seguir = false;
                        }
                    }
                    if (!seguir || clasesB[i4] != clases || !(stim[i4] < min)) continue;
                    min = stim[i4];
                    remove = i4;
                }
                if (resources[remove] <= numResRemove + 1.0) {
                    borrar[++utilborrar] = remove;
                    if (recursosRemovidos == -1.0) {
                        resAllocated -= resources[remove];
                        continue;
                    }
                    resAllocated -= recursosRemovidos;
                    continue;
                }
                recursosRemovidos = resources[remove];
                resources[remove] = resources[remove] - numResRemove;
            }
            clases += 1.0;
        }
        String[][] C = new String[B.length - utilborrar][agk.length];
        double[] clasesC = new double[B.length - utilborrar];
        int almacenados = 0;
        if (utilborrar != -1) {
            boolean seguir = true;
            for (int i5 = 0; i5 < B.length; ++i5) {
                seguir = true;
                for (int j = 0; j < utilborrar && seguir; ++j) {
                    if (i5 != borrar[j]) continue;
                    seguir = false;
                }
                if (!seguir) continue;
                C[almacenados] = B[i5];
                clasesC[almacenados] = clasesB[i5];
                ++almacenados;
            }
        } else {
            C = (String[][])B.clone();
            clasesC = (double[])clasesB.clone();
        }
        Pair<String[][], double[]> salida = new Pair<String[][], double[]>(C, clasesC);
        return salida;
    }

    public Pair<String[][], double[]> UpdateMemory(String[][] binario, double[] binarioClass, int matchIndex, String[] Antigen, double claseAntigen, String[] most, double mostC, String[] Match, double claseMatch) {
        String[][] Immune = new String[binario.length][binario[0].length];
        double[] classI = new double[binarioClass.length];
        double CandStim = this.stimString2(Antigen, most);
        double MatchStim = this.stimString2(Antigen, Match);
        double CellAff = this.stimString2(Match, most);
        if (CandStim > MatchStim) {
            if (CellAff > this.alpha * this.AS[(int)claseAntigen]) {
                binario[matchIndex] = most;
                binarioClass[matchIndex] = mostC;
                classI = (double[])binarioClass.clone();
                Immune = (String[][])binario.clone();
            } else {
                Immune = new String[binario.length + 1][binario[0].length];
                classI = new double[binario.length + 1];
                for (int i = 0; i < binario.length; ++i) {
                    Immune[i] = (String[])binario[i].clone();
                    classI[i] = binarioClass[i];
                }
                Immune[binario.length] = most;
                classI[binario.length] = mostC;
            }
        } else {
            classI = (double[])binarioClass.clone();
            Immune = (String[][])binario.clone();
        }
        Pair<String[][], double[]> salida = new Pair<String[][], double[]>(Immune, classI);
        return salida;
    }

    @Override
    public PrototypeSet reduceSet() {
        System.out.print("\nThe algorithm  PSCSA is starting...\n Computing...\n");
        this.trainingDataSet.randomize();
        String[][] binarioTrain = this.trainingDataSet.to8GrayString();
        double[] TrainingClases = new double[this.trainingDataSet.size()];
        for (int i = 0; i < this.trainingDataSet.size(); ++i) {
            TrainingClases[i] = ((Prototype)this.trainingDataSet.get(i)).getOutput(0);
        }
        PrototypeSet IM = new PrototypeSet();
        Prototype agk = new Prototype();
        Prototype Mmatch = new Prototype();
        PrototypeSet B = new PrototypeSet();
        PrototypeSet Best = new PrototypeSet();
        double BestFitness = Double.MIN_VALUE;
        for (int i = 0; i < this.numberOfClass; ++i) {
            PrototypeSet clase = this.trainingDataSet.getFromClass(i);
            if (clase.size() <= 0) continue;
            IM.add(clase.getRandom());
        }
        String[][] binario = IM.to8GrayString();
        double[] binarioClass = new double[IM.size()];
        boolean iter = false;
        binario = IM.to8GrayString();
        for (int i = 0; i < IM.size(); ++i) {
            binarioClass[i] = ((Prototype)IM.get(i)).getOutput(0);
        }
        for (int p = 0; p < this.trainingDataSet.size(); ++p) {
            double Cercano = Double.MIN_VALUE;
            int indexCercano = -1;
            for (int i = 0; i < binario.length; ++i) {
                double stim = this.stimString(binario, i, binarioTrain, p);
                if (!(stim > Cercano) || binarioClass[i] != TrainingClases[p]) continue;
                Cercano = stim;
                indexCercano = i;
            }
            String[] Match = (String[])binario[indexCercano].clone();
            double claseMatch = binarioClass[indexCercano];
            String[] Antigen = (String[])binarioTrain[p].clone();
            double claseAntigen = TrainingClases[p];
            double[] ClasesB = null;
            Pair<String[][], double[]> salida = this.HyperMutation(Match, claseMatch, Antigen, claseAntigen, 1);
            String[][] Bstring = salida.first();
            ClasesB = (double[])salida.second().clone();
            Pair<String[][], double[]> salidaR = this.ResourceAllocation(Bstring, ClasesB, Antigen, claseAntigen);
            Bstring = (String[][])salidaR.first().clone();
            ClasesB = (double[])salidaR.second().clone();
            boolean stoppingCriteria = false;
            int numProlifer = 0;
            while (!stoppingCriteria) {
                int i;
                String[][][] result = new String[Bstring.length][][];
                double[][] clasesResult = new double[Bstring.length][];
                int tamanio = 0;
                for (int i2 = 0; i2 < Bstring.length; ++i2) {
                    Pair<String[][], double[]> salida2 = this.HyperMutation(Bstring[i2], ClasesB[i2], Antigen, claseAntigen, 2);
                    result[i2] = (String[][])salida2.first().clone();
                    clasesResult[i2] = (double[])salida2.second().clone();
                    tamanio += result[i2].length;
                }
                String[][] Hyper = new String[tamanio][];
                double[] ClasesH = new double[tamanio];
                int cont = 0;
                int cont2 = 0;
                for (i = 0; i < Bstring.length; ++i) {
                    int j;
                    for (j = 0; j < result[i].length; ++j) {
                        Hyper[cont] = result[i][j];
                        ++cont;
                    }
                    for (j = 0; j < clasesResult[i].length; ++j) {
                        ClasesH[cont2] = clasesResult[i][j];
                        ++cont2;
                    }
                }
                salidaR = this.ResourceAllocation(Hyper, ClasesH, Antigen, claseAntigen);
                Bstring = (String[][])salidaR.first().clone();
                ClasesB = (double[])salidaR.second().clone();
                cont = 0;
                cont2 = 0;
                for (i = 0; i < Bstring.length; ++i) {
                    if (ClasesB[i] == claseAntigen) {
                        ++cont;
                        continue;
                    }
                    ++cont2;
                }
                double sum1 = 0.0;
                double sum2 = 0.0;
                if (Bstring.length > 0) {
                    int i3;
                    String[][] B1s = new String[cont][Bstring[0].length];
                    String[][] B2s = new String[cont2][Bstring[0].length];
                    cont = 0;
                    cont2 = 0;
                    for (i3 = 0; i3 < Bstring.length; ++i3) {
                        if (ClasesB[i3] == claseAntigen) {
                            B1s[cont] = Bstring[i3];
                            ++cont;
                            continue;
                        }
                        B2s[cont2] = Bstring[i3];
                        ++cont2;
                    }
                    for (i3 = 0; i3 < B1s.length; ++i3) {
                        sum1 += this.stimString2(Antigen, B1s[i3]);
                    }
                    for (i3 = 0; i3 < B2s.length; ++i3) {
                        sum2 += this.stimString2(Antigen, B2s[i3]);
                    }
                }
                stoppingCriteria = sum1 - sum2 > this.STIMULATION_THRESHOLD;
                ++numProlifer;
            }
            int mostStimulated = -1;
            double maximumStimulation = Double.MIN_VALUE;
            for (int i = 0; i < Bstring.length; ++i) {
                double stimB = this.stimString2(Antigen, Bstring[i]);
                if (!(stimB > maximumStimulation) || ClasesB[i] != claseAntigen) continue;
                mostStimulated = i;
                maximumStimulation = stimB;
            }
            Pair<String[][], double[]> update = this.UpdateMemory(binario, binarioClass, indexCercano, Antigen, claseAntigen, Bstring[mostStimulated], ClasesB[mostStimulated], Match, claseMatch);
            binario = new String[update.first().length][update.first()[0].length];
            binario = (String[][])update.first().clone();
            binarioClass = new double[update.second().length];
            binarioClass = (double[])update.second().clone();
            IM = new PrototypeSet();
            IM.toPrototypeSet(binario, binarioClass);
            double fitness = (double)KNN.classficationAccuracy(IM, this.trainingDataSet, 1) * 100.0 / (double)this.trainingDataSet.size();
            if (!(fitness > BestFitness)) continue;
            BestFitness = fitness;
            Best = new PrototypeSet(IM);
        }
        System.err.println("\n% de acierto en training " + (double)KNN.classficationAccuracy(Best, this.trainingDataSet, 1) * 100.0 / (double)this.trainingDataSet.size());
        System.out.println("\nReduction %, result set = " + (this.trainingDataSet.size() - Best.size()) * 100 / this.trainingDataSet.size() + "\n");
        return Best;
    }

    public static void main(String[] args) {
        Parameters.setUse("PSCSA", "<seed> <Number of neighbors>\n<Swarm size>\n<Particle Size>\n<MaxIter>\n<DistanceFunction>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        PSCSAGenerator.setSeed(seed);
        int k = Parameters.assertExtendedArgAsInt(args, 3, "number of neighbors", 1.0, 2.147483647E9);
        int swarm = Parameters.assertExtendedArgAsInt(args, 4, "swarm size", 1.0, 2.147483647E9);
        int particle = Parameters.assertExtendedArgAsInt(args, 5, "particle size", 1.0, 2.147483647E9);
        int iter = Parameters.assertExtendedArgAsInt(args, 6, "max iter", 1.0, 2.147483647E9);
        double c1 = Parameters.assertExtendedArgAsInt(args, 7, "c1", 1.0, Double.MAX_VALUE);
        double c2 = Parameters.assertExtendedArgAsInt(args, 8, "c2", 1.0, Double.MAX_VALUE);
        double vmax = Parameters.assertExtendedArgAsInt(args, 9, "vmax", 1.0, Double.MAX_VALUE);
        double wstart = Parameters.assertExtendedArgAsInt(args, 10, "wstart", 1.0, Double.MAX_VALUE);
        double wend = Parameters.assertExtendedArgAsInt(args, 11, "wend", 1.0, Double.MAX_VALUE);
        PSCSAGenerator generator = new PSCSAGenerator(training, k, swarm, particle, iter, 0.5, 0.5, 1);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

