/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.util.dataset;

import net.sourceforge.jclec.util.dataset.AbstractAttribute;
import net.sourceforge.jclec.util.dataset.AttributeType;
import net.sourceforge.jclec.util.range.Closure;
import net.sourceforge.jclec.util.range.IRange;
import net.sourceforge.jclec.util.range.Interval;

public class NumericalAttribute
extends AbstractAttribute {
    private static final long serialVersionUID = -6328412187422731602L;
    Interval interval;
    protected IRange range;

    public NumericalAttribute() {
        this.interval = null;
    }

    public NumericalAttribute(String name, IRange range) {
        super(name);
        this.setRange(range);
    }

    public void addInterval(Interval interval) {
        this.interval = interval;
    }

    public IRange getRange() {
        return this.range;
    }

    public void setRange(IRange range) {
        this.range = range;
    }

    @Override
    public AttributeType getType() {
        return AttributeType.DoubleNumerical;
    }

    @Override
    public boolean isValid(double internalValue) {
        return this.interval.contains(internalValue);
    }

    @Override
    public boolean isValid(Object externalValue) {
        return this.interval.contains((Double)externalValue);
    }

    @Override
    public double parse(String externalValue) {
        return Double.parseDouble(externalValue);
    }

    @Override
    public String show(double internalValue) {
        return new Double(internalValue).toString();
    }

    public Interval intervalValues() {
        if (this.interval == null) {
            this.interval = new Interval(0.0, Double.MAX_VALUE, Closure.ClosedClosed);
        }
        return this.interval;
    }
}

