/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.Distribution;
import umontreal.iro.lecuyer.probdist.PiecewiseLinearEmpiricalDist;
import umontreal.iro.lecuyer.randvar.RandUnuran;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class UnuranEmpirical
extends RandomVariateGen {
    private RandUnuran unuran = new RandUnuran();

    public UnuranEmpirical(RandomStream randomStream, String string) {
        if (randomStream == null) {
            throw new IllegalArgumentException("s must not be null.");
        }
        this.unuran.mainStream = this.unuran.auxStream = randomStream;
        this.unuran.init(string);
        if (!this.unuran.isEmpirical()) {
            this.unuran.close();
            throw new IllegalArgumentException("not an empirical distribution");
        }
    }

    public UnuranEmpirical(RandomStream randomStream, RandomStream randomStream2, String string) {
        if (randomStream == null) {
            throw new IllegalArgumentException("s must not be null.");
        }
        if (randomStream2 == null) {
            throw new IllegalArgumentException("aux must not be null.");
        }
        this.unuran.mainStream = randomStream;
        this.unuran.auxStream = randomStream2;
        this.unuran.init(string);
        if (!this.unuran.isEmpirical()) {
            this.unuran.close();
            throw new IllegalArgumentException("not an empirical distribution");
        }
    }

    public UnuranEmpirical(RandomStream randomStream, PiecewiseLinearEmpiricalDist piecewiseLinearEmpiricalDist, String string) {
        if (randomStream == null) {
            throw new IllegalArgumentException("s must not be null.");
        }
        this.unuran.mainStream = this.unuran.auxStream = randomStream;
        String string2 = this.readDistr(piecewiseLinearEmpiricalDist) + (string == null || string.equals("") ? "" : "&" + string);
        this.unuran.init(string2);
        if (!this.unuran.isEmpirical()) {
            this.unuran.close();
            throw new IllegalArgumentException("not an empirical distribution");
        }
    }

    public UnuranEmpirical(RandomStream randomStream, RandomStream randomStream2, PiecewiseLinearEmpiricalDist piecewiseLinearEmpiricalDist, String string) {
        if (randomStream == null) {
            throw new IllegalArgumentException("s must not be null.");
        }
        if (randomStream2 == null) {
            throw new IllegalArgumentException("aux must not be null.");
        }
        this.unuran.mainStream = randomStream;
        this.unuran.auxStream = randomStream2;
        String string2 = this.readDistr(piecewiseLinearEmpiricalDist) + (string == null || string.equals("") ? "" : "&" + string);
        this.unuran.init(string2);
        if (!this.unuran.isEmpirical()) {
            this.unuran.close();
            throw new IllegalArgumentException("not an empirical distribution");
        }
    }

    private String readDistr(PiecewiseLinearEmpiricalDist piecewiseLinearEmpiricalDist) {
        StringBuffer stringBuffer = new StringBuffer("distr=cemp; data=(");
        boolean bl = true;
        for (int i = 0; i < piecewiseLinearEmpiricalDist.getN(); ++i) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(piecewiseLinearEmpiricalDist.getObs(i));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public double nextDouble() {
        if (this.unuran.nativeParams == 0) {
            throw new IllegalStateException();
        }
        return this.unuran.getRandCont(this.unuran.mainStream.nextDouble(), this.unuran.nativeParams);
    }

    public void nextArrayOfDouble(double[] dArray, int n, int n2) {
        if (dArray == null || n < 0 || n2 < 0 || n + n2 > dArray.length) {
            throw new IllegalArgumentException();
        }
        if (this.unuran.unifArray == null || this.unuran.unifArray.length < n2) {
            this.unuran.unifArray = new double[n2];
        }
        if (this.unuran.mainStream != this.unuran.auxStream && (this.unuran.unifAuxArray == null || this.unuran.unifAuxArray.length < n2)) {
            this.unuran.unifAuxArray = new double[n2];
        }
        this.unuran.getRandContArray(this.unuran.nativeParams, this.unuran.unifArray, this.unuran.unifAuxArray, dArray, n, n2);
    }

    protected void finalize() {
        this.unuran.close();
    }

    public Distribution getDistribution() {
        return null;
    }

    public RandomStream getStream() {
        return this.unuran.mainStream;
    }

    public RandomStream getAuxStream() {
        return this.unuran.auxStream;
    }
}

