/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import cern.colt.list.DoubleArrayList;
import umontreal.iro.lecuyer.probdist.Distribution;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class RandomVariateGenWithCache
extends RandomVariateGen {
    private RandomVariateGen rvg;
    private DoubleArrayList values;
    private int index = 0;
    private boolean caching = true;

    public RandomVariateGenWithCache(RandomVariateGen randomVariateGen) {
        if (randomVariateGen == null) {
            throw new NullPointerException("The given random variate generator cannot be null");
        }
        this.rvg = randomVariateGen;
        this.values = new DoubleArrayList();
    }

    public RandomVariateGenWithCache(RandomVariateGen randomVariateGen, int n) {
        if (randomVariateGen == null) {
            throw new NullPointerException("The given random variate generator cannot be null");
        }
        this.rvg = randomVariateGen;
        this.values = new DoubleArrayList(n);
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean bl) {
        if (this.caching && !bl) {
            this.clearCache();
        }
        this.caching = bl;
    }

    public RandomVariateGen getCachedGen() {
        return this.rvg;
    }

    public void setCachedGen(RandomVariateGen randomVariateGen) {
        if (randomVariateGen == null) {
            throw new NullPointerException("The given random variate generator cannot be null");
        }
        if (randomVariateGen == this.rvg) {
            return;
        }
        this.rvg = randomVariateGen;
        this.clearCache();
    }

    public void clearCache() {
        this.values = new DoubleArrayList();
        this.index = 0;
    }

    public void initCache() {
        this.index = 0;
    }

    public int getNumCachedValues() {
        return this.values.size();
    }

    public int getCacheIndex() {
        return this.index;
    }

    public void setCacheIndex(int n) {
        if (n < 0 || n > this.values.size()) {
            throw new IllegalArgumentException("newIndex must not be negative or greater than the cache size");
        }
        this.index = n;
    }

    public DoubleArrayList getCachedValues() {
        return this.values;
    }

    public void setCachedValues(DoubleArrayList doubleArrayList) {
        if (doubleArrayList == null) {
            throw new NullPointerException();
        }
        this.values = doubleArrayList;
        this.index = doubleArrayList.size();
    }

    public double nextDouble() {
        if (!this.caching) {
            return this.rvg.nextDouble();
        }
        if (this.index >= this.values.size()) {
            double d = this.rvg.nextDouble();
            this.values.add(d);
            ++this.index;
            return d;
        }
        return this.values.getQuick(this.index++);
    }

    public void nextArrayOfDouble(double[] dArray, int n, int n2) {
        int n3;
        int n4;
        if (!this.caching) {
            this.rvg.nextArrayOfDouble(dArray, n, n2);
            return;
        }
        int n5 = this.values.size() - this.index;
        if (n5 < 0) {
            n5 = 0;
        }
        if ((n4 = Math.min(n2, n5)) > 0) {
            System.arraycopy(this.values.elements(), this.index, dArray, n, n4);
            this.index += n4;
        }
        if ((n3 = n2 - n4) > 0) {
            this.rvg.nextArrayOfDouble(dArray, n + n4, n3);
            for (int i = n4; i < n2; ++i) {
                this.values.add(dArray[n + i]);
                ++this.index;
            }
        }
    }

    public RandomStream getStream() {
        return this.rvg.getStream();
    }

    public Distribution getDistribution() {
        return this.rvg.getDistribution();
    }
}

