## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----eval=F-------------------------------------------------------------------
#  install("ProSGPV")

## ----eval=F-------------------------------------------------------------------
#  devtools::install_github("zuoyi93/ProSGPV")

## -----------------------------------------------------------------------------
library(ProSGPV)

## -----------------------------------------------------------------------------
x <- t.housing[, -ncol(t.housing)]
y <- t.housing$V9

sgpv.2s <- pro.sgpv(x,y)
sgpv.2s

## -----------------------------------------------------------------------------
summary(sgpv.2s)

## -----------------------------------------------------------------------------
coef(sgpv.2s)

## -----------------------------------------------------------------------------
head(predict(sgpv.2s))

## ----eval=F-------------------------------------------------------------------
#  plot(sgpv.2s,lambda.max = 0.005)

## ---- eval=F------------------------------------------------------------------
#  plot(sgpv.2s, lambda.max=0.005, lpv=1)

## -----------------------------------------------------------------------------
sgpv.1s <- pro.sgpv(x,y,stage=1)
sgpv.1s

## ----eval=F-------------------------------------------------------------------
#  plot(sgpv.1s)

## -----------------------------------------------------------------------------
set.seed(30)
data.linear <- gen.sim.data(n=100, p=200, s=4)

# explanatory variables
x <- data.linear[[1]]

# outcome
y <- data.linear[[2]]

# true support
(true.index <- data.linear[[3]])

# true coefficients
true.beta <- data.linear[[4]]

## -----------------------------------------------------------------------------
h.sgpv <- pro.sgpv(x,y)
h.sgpv

## ----eval=F-------------------------------------------------------------------
#  png("vignettes/assets/linear.fig.4.png", units="in", width=7, height=7, res=300)
#  plot(h.sgpv)
#  dev.off()

