/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble.sampling;

import cern.colt.PersistentObject;
import cern.colt.list.tboolean.BooleanArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.jet.random.tdouble.AbstractDoubleDistribution;
import cern.jet.random.tdouble.DoubleUniform;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;

public class WeightedDoubleRandomSampler
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    protected int skip;
    protected int nextTriggerPos;
    protected int nextSkip;
    protected int weight;
    protected DoubleUniform generator;
    static final int UNDEFINED = -1;

    public WeightedDoubleRandomSampler() {
        this(1, null);
    }

    public WeightedDoubleRandomSampler(int n, DoubleRandomEngine doubleRandomEngine) {
        if (doubleRandomEngine == null) {
            doubleRandomEngine = AbstractDoubleDistribution.makeDefaultGenerator();
        }
        this.generator = new DoubleUniform(doubleRandomEngine);
        this.setWeight(n);
    }

    public Object clone() {
        WeightedDoubleRandomSampler weightedDoubleRandomSampler = (WeightedDoubleRandomSampler)super.clone();
        weightedDoubleRandomSampler.generator = (DoubleUniform)this.generator.clone();
        return weightedDoubleRandomSampler;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean sampleNextElement() {
        if (this.skip > 0) {
            --this.skip;
            return false;
        }
        if (this.nextTriggerPos == -1) {
            this.nextTriggerPos = this.weight == 1 ? 0 : this.generator.nextIntFromTo(0, this.weight - 1);
            this.nextSkip = this.weight - 1 - this.nextTriggerPos;
        }
        if (this.nextTriggerPos > 0) {
            --this.nextTriggerPos;
            return false;
        }
        this.nextTriggerPos = -1;
        this.skip = this.nextSkip;
        return true;
    }

    public void setWeight(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("bad weight");
        }
        this.weight = n;
        this.skip = 0;
        this.nextTriggerPos = -1;
        this.nextSkip = 0;
    }

    public static void test(int n, int n2) {
        WeightedDoubleRandomSampler weightedDoubleRandomSampler = new WeightedDoubleRandomSampler();
        weightedDoubleRandomSampler.setWeight(n);
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < n2; ++i) {
            if (!weightedDoubleRandomSampler.sampleNextElement()) continue;
            intArrayList.add(i);
        }
        System.out.println("Sample = " + intArrayList);
    }

    private void xsampleNextElements(BooleanArrayList booleanArrayList) {
        int n = booleanArrayList.size();
        boolean[] blArray = booleanArrayList.elements();
        for (int i = 0; i < n; ++i) {
            if (this.skip > 0) {
                --this.skip;
                blArray[i] = false;
                continue;
            }
            if (this.nextTriggerPos == -1) {
                this.nextTriggerPos = this.weight == 1 ? 0 : this.generator.nextIntFromTo(0, this.weight - 1);
                this.nextSkip = this.weight - 1 - this.nextTriggerPos;
            }
            if (this.nextTriggerPos > 0) {
                --this.nextTriggerPos;
                blArray[i] = false;
                continue;
            }
            this.nextTriggerPos = -1;
            this.skip = this.nextSkip;
            blArray[i] = true;
        }
    }
}

