/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.dstream;

import com.yahoo.labs.samoa.instances.Instance;
import java.util.ArrayList;
import moa.cluster.CFCluster;

public class DensityGrid
extends CFCluster {
    private static final long serialVersionUID = 7527683701564950206L;
    private int[] coordinates;
    private int dimensions;
    private boolean isVisited;

    public DensityGrid(int[] c) {
        super(c.length);
        this.dimensions = c.length;
        this.coordinates = new int[this.dimensions];
        this.N = 1.0;
        this.LS = new double[this.dimensions];
        this.SS = new double[this.dimensions];
        int i = 0;
        while (i < this.dimensions) {
            int cI;
            this.coordinates[i] = cI = c[i];
            int n = i;
            this.LS[n] = this.LS[n] + (double)cI;
            int n2 = i++;
            this.SS[n2] = this.SS[n2] + Math.pow(cI, 2.0);
        }
        this.isVisited = false;
    }

    public DensityGrid(DensityGrid dg) {
        super(dg.getDimensions());
        int[] dgCoord = dg.getCoordinates();
        this.dimensions = dg.getDimensions();
        this.coordinates = new int[this.dimensions];
        this.N = 1.0;
        this.LS = new double[this.dimensions];
        this.SS = new double[this.dimensions];
        int i = 0;
        while (i < this.dimensions) {
            int cI;
            this.coordinates[i] = cI = dgCoord[i];
            int n = i;
            this.LS[n] = this.LS[n] + (double)cI;
            int n2 = i++;
            this.SS[n2] = this.SS[n2] + Math.pow(cI, 2.0);
        }
        this.isVisited = false;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != DensityGrid.class) {
            return false;
        }
        DensityGrid dg = (DensityGrid)o;
        if (dg.getDimensions() != this.dimensions) {
            return false;
        }
        int[] dgCoord = dg.getCoordinates();
        for (int i = 0; i < this.dimensions; ++i) {
            if (dgCoord[i] == this.coordinates[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hc = 1;
        for (int i = 0; i < this.dimensions; ++i) {
            hc = hc * 31 + this.coordinates[i];
        }
        return hc;
    }

    public ArrayList<DensityGrid> getNeighbours() {
        ArrayList<DensityGrid> neighbours = new ArrayList<DensityGrid>();
        int[] hCoord = this.getCoordinates();
        for (int i = 0; i < this.dimensions; ++i) {
            hCoord[i] = hCoord[i] - 1;
            DensityGrid h = new DensityGrid(hCoord);
            neighbours.add(h);
            hCoord[i] = hCoord[i] + 2;
            h = new DensityGrid(hCoord);
            neighbours.add(h);
            hCoord[i] = hCoord[i] - 1;
        }
        return neighbours;
    }

    public int[] getCoordinates() {
        return this.coordinates;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(15 + 2 * this.dimensions);
        sb.append("DG:");
        for (int i = 0; i < this.dimensions; ++i) {
            sb.append(" " + this.coordinates[i]);
        }
        sb.append(" HC:" + this.hashCode());
        return sb.toString();
    }

    @Override
    public CFCluster getCF() {
        return this;
    }

    @Override
    public double getInclusionProbability(Instance instance) {
        for (int i = 0; i < this.dimensions; ++i) {
            if ((int)instance.value(i) == this.coordinates[i]) continue;
            return 0.0;
        }
        return 1.0;
    }

    @Override
    public double getRadius() {
        return 1.0;
    }

    public boolean isVisited() {
        return this.isVisited;
    }

    public void setVisited(boolean isVisited) {
        this.isVisited = isVisited;
    }
}

