/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.tools.ArrayUtils;

public class PropKLoops
extends Propagator<IntVar> {
    private final int n;
    private final int offSet;
    private final ISet possibleLoops;
    private final IStateInt nbMinLoops;

    public PropKLoops(IntVar[] succs, int offSet, IntVar nbLoops) {
        super((Variable[])ArrayUtils.concat(succs, nbLoops), (Priority)PropagatorPriority.UNARY, true);
        this.n = succs.length;
        this.offSet = offSet;
        IEnvironment environment = this.model.getEnvironment();
        this.possibleLoops = SetFactory.makeStoredSet(SetType.BIPARTITESET, 0, this.model);
        this.nbMinLoops = environment.makeInt();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.possibleLoops.clear();
        this.nbMinLoops.set(0);
        for (int i = 0; i < this.n; ++i) {
            if (!((IntVar[])this.vars)[i].contains(i + this.offSet)) continue;
            if (((IntVar[])this.vars)[i].isInstantiated()) {
                this.nbMinLoops.add(1);
                continue;
            }
            this.possibleLoops.add(i);
        }
        this.filter();
    }

    private void filter() throws ContradictionException {
        int nbMin = this.nbMinLoops.get();
        int nbMax = nbMin + this.possibleLoops.size();
        ((IntVar[])this.vars)[this.n].updateBounds(nbMin, nbMax, this);
        if (((IntVar[])this.vars)[this.n].isInstantiated() && nbMin != nbMax) {
            if (((IntVar[])this.vars)[this.n].getValue() == nbMax) {
                ISetIterator iter = this.possibleLoops.iterator();
                while (iter.hasNext()) {
                    int i = iter.nextInt();
                    ((IntVar[])this.vars)[i].instantiateTo(i + this.offSet, (ICause)this);
                    assert (((IntVar[])this.vars)[i].isInstantiatedTo(i + this.offSet));
                    this.nbMinLoops.add(1);
                }
                this.possibleLoops.clear();
                this.setPassive();
            } else if (((IntVar[])this.vars)[this.n].getValue() == nbMin) {
                ISetIterator iter = this.possibleLoops.iterator();
                while (iter.hasNext()) {
                    int i = iter.nextInt();
                    if (!((IntVar[])this.vars)[i].removeValue(i + this.offSet, (ICause)this)) continue;
                    this.possibleLoops.remove(i);
                }
                if (this.possibleLoops.isEmpty()) {
                    this.setPassive();
                }
            }
        }
    }

    @Override
    public void propagate(int idV, int mask) throws ContradictionException {
        if (idV < this.n && this.possibleLoops.contains(idV)) {
            if (((IntVar[])this.vars)[idV].contains(idV + this.offSet)) {
                if (((IntVar[])this.vars)[idV].isInstantiated()) {
                    this.nbMinLoops.add(1);
                    this.possibleLoops.remove(idV);
                }
            } else {
                this.possibleLoops.remove(idV);
            }
        }
        this.filter();
    }

    @Override
    public ESat isEntailed() {
        int nbMax = 0;
        int nbMin = 0;
        for (int i = 0; i < this.n; ++i) {
            if (!((IntVar[])this.vars)[i].contains(i + this.offSet)) continue;
            ++nbMax;
            if (!((IntVar[])this.vars)[i].isInstantiated()) continue;
            ++nbMin;
        }
        if (((IntVar[])this.vars)[this.n].getLB() > nbMax || ((IntVar[])this.vars)[this.n].getUB() < nbMin) {
            return ESat.FALSE;
        }
        if (nbMin == nbMax && ((IntVar[])this.vars)[this.n].isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

