/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.choco;

import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.restopt.choco.ConnectivityFinderSpatialGraph;
import org.restopt.grid.neighborhood.INeighborhood;
import org.restopt.grid.neighborhood.Neighborhoods;
import org.restopt.grid.regular.square.PartialRegularGroupedGrid;

public class PropIIC
extends Propagator<Variable> {
    protected UndirectedGraphVar g;
    protected IntVar iic;
    protected int landscapeArea;
    protected int precision;
    protected PartialRegularGroupedGrid grid;
    protected int distanceThreshold;
    protected INeighborhood threshold;
    public int[][] threshNeigh;
    public int[][] thresh;
    private final boolean maximize;
    private final ConnectivityFinderSpatialGraph ccLB;
    private final ConnectivityFinderSpatialGraph ccUB;
    private IStateInt iicUB;

    public PropIIC(UndirectedGraphVar g, IntVar iic, PartialRegularGroupedGrid grid, int landscapeArea, int distanceThreshold, int precison, boolean maximize) {
        super(new Variable[]{g, iic}, (Priority)PropagatorPriority.QUADRATIC, true);
        this.g = g;
        this.grid = grid;
        this.iic = iic;
        this.landscapeArea = landscapeArea;
        this.precision = precison;
        this.thresh = new int[grid.getNbCells()][grid.getNbCells()];
        this.threshNeigh = new int[grid.getNbCells()][];
        this.threshold = Neighborhoods.PARTIAL_GROUPED_K_WIDE_FOUR_CONNECTED(distanceThreshold);
        this.distanceThreshold = distanceThreshold;
        this.maximize = maximize;
        this.ccLB = new ConnectivityFinderSpatialGraph((UndirectedGraph)g.getLB(), (UndirectedGraph)g.getUB(), grid.getSizeCells());
        this.ccUB = new ConnectivityFinderSpatialGraph((UndirectedGraph)g.getUB(), grid.getSizeCells());
        this.iicUB = this.getModel().getEnvironment().makeInt(landscapeArea);
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        block6: {
            block5: {
                if (idxVarInProp == 0 && this.maximize && !this.g.isInstantiated() && (mask & GraphEventType.REMOVE_NODE.getMask()) == 0) {
                    return;
                }
                if (idxVarInProp != 0) break block5;
                if (!this.maximize || this.g.isInstantiated()) {
                    int iic_LB = (int)Math.round((double)this.getIICLB() * Math.pow(10.0, this.precision));
                    this.iic.updateLowerBound(iic_LB, this);
                }
                int iic_UB = (int)Math.round((double)this.getIICUB() * Math.pow(10.0, this.precision));
                this.iic.updateUpperBound(iic_UB, this);
                this.iicUB.set(iic_UB);
                if (this.iic.getLB() != this.iicUB.get()) break block6;
                ISetIterator iSetIterator = this.g.getPotentialNodes().iterator();
                while (iSetIterator.hasNext()) {
                    int i = (Integer)iSetIterator.next();
                    this.g.enforceNode(i, this);
                }
                break block6;
            }
            if (this.iic.getLB() == this.iicUB.get()) {
                ISetIterator iSetIterator = this.g.getPotentialNodes().iterator();
                while (iSetIterator.hasNext()) {
                    int i = (Integer)iSetIterator.next();
                    this.g.enforceNode(i, this);
                }
            }
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (!this.maximize || this.g.isInstantiated()) {
            int iic_LB = (int)Math.round((double)this.getIICLB() * Math.pow(10.0, this.precision));
            this.iic.updateLowerBound(iic_LB, this);
        }
        int iic_UB = (int)Math.round((double)this.getIICUB() * Math.pow(10.0, this.precision));
        this.iic.updateUpperBound(iic_UB, this);
        this.iicUB.set(iic_UB);
        if (this.iic.getLB() == iic_UB) {
            ISetIterator iSetIterator = this.g.getPotentialNodes().iterator();
            while (iSetIterator.hasNext()) {
                int i = (Integer)iSetIterator.next();
                this.g.enforceNode(i, this);
            }
        }
    }

    public float getIICLB() {
        return this.getIIC(this.ccLB, this.g.getMandatoryNodes());
    }

    public float getIICUB() {
        return this.getIIC(this.ccUB, this.g.getPotentialNodes());
    }

    public float getIIC(ConnectivityFinderSpatialGraph connectivityFinder, ISet nodes) {
        connectivityFinder.findAllCC();
        int nbCC = connectivityFinder.getNBCC();
        int[][] ccs = new int[nbCC][];
        for (int i = 0; i < nbCC; ++i) {
            ccs[i] = new int[connectivityFinder.getSizeCC()[i]];
            int k = 0;
            int j = connectivityFinder.getCCFirstNode()[i];
            while (j >= 0) {
                ccs[i][k++] = j;
                j = connectivityFinder.getCCNextNode()[j];
            }
        }
        int[] nodeCC = connectivityFinder.getNodeCC();
        int[][] adj = this.getLandscapeGraph(nbCC, ccs, nodeCC, nodes);
        float iic = 0.0f;
        for (int i = 0; i < adj.length; ++i) {
            int[] dists = this.bfs(i, adj);
            for (int j = 0; j < adj.length; ++j) {
                if (dists[j] < 0) continue;
                iic += (float)(connectivityFinder.getAttributeCC()[i] * connectivityFinder.getAttributeCC()[j] / (1 + dists[j]));
            }
        }
        return iic / (float)(this.landscapeArea * this.landscapeArea);
    }

    public int[][] getLandscapeGraph(int nbCC, int[][] ccs, int[] nodeCC, ISet nodes) {
        int[][] neigh = new int[nbCC][];
        for (int i = 0; i < nbCC; ++i) {
            int[] cc;
            boolean[] conn = new boolean[nbCC];
            int nAdj = 0;
            for (int node : cc = ccs[i]) {
                if (this.threshNeigh[node] == null) {
                    this.threshNeigh[node] = this.threshold.getNeighbors(this.grid, node);
                }
                for (int j : this.threshNeigh[node]) {
                    if (nodeCC[j] == i || !nodes.contains(j) || conn[nodeCC[j]]) continue;
                    conn[nodeCC[j]] = true;
                    ++nAdj;
                }
            }
            int[] adj = new int[nAdj];
            int k = 0;
            for (int j = 0; j < nbCC; ++j) {
                if (!conn[j]) continue;
                adj[k++] = j;
            }
            neigh[i] = adj;
        }
        return neigh;
    }

    public int[] bfs(int source, int[][] adj) {
        int n = adj.length;
        boolean[] visited = new boolean[n];
        int[] queue = new int[n];
        int front = 0;
        int rear = 0;
        int[] dist = new int[n];
        for (int i = 0; i < n; ++i) {
            dist[i] = -1;
        }
        visited[source] = true;
        queue[front] = source;
        ++rear;
        dist[source] = 0;
        while (front != rear) {
            int current = queue[front++];
            for (int i : adj[current]) {
                if (visited[i]) continue;
                dist[i] = dist[current] + 1;
                queue[rear++] = i;
                visited[i] = true;
            }
        }
        return dist;
    }

    @Override
    public ESat isEntailed() {
        int iic_LB = (int)Math.round((double)this.getIICLB() * Math.pow(10.0, this.precision));
        int iic_UB = (int)Math.round((double)this.getIICUB() * Math.pow(10.0, this.precision));
        if (iic_LB > this.iic.getUB() || iic_UB < this.iic.getLB()) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

