/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.automata.structure.regular;

import gnu.trove.set.hash.TIntHashSet;
import gnu.trove.stack.TIntStack;
import gnu.trove.stack.array.TIntArrayStack;
import java.util.Set;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.automata.structure.Node;
import org.chocosolver.solver.constraints.nary.automata.structure.regular.Arc;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.iterators.DisposableIntIterator;
import org.chocosolver.util.objects.StoredIndexedBipartiteSet;
import org.chocosolver.util.objects.StoredIndexedBipartiteSetWithOffset;
import org.jgrapht.graph.DirectedMultigraph;

public class StoredDirectedMultiGraph {
    private final int[] starts;
    private final int[] offsets;
    private final TIntStack stack = new TIntArrayStack();
    private final StoredIndexedBipartiteSetWithOffset[] supports;
    private final Nodes GNodes;
    private final Arcs GArcs;

    public StoredDirectedMultiGraph(IEnvironment environment, DirectedMultigraph<Node, Arc> graph, int[] starts, int[] offsets, int supportLength) {
        this.starts = starts;
        this.offsets = offsets;
        this.GNodes = new Nodes();
        this.GArcs = new Arcs();
        TIntHashSet[] sups = new TIntHashSet[supportLength];
        this.supports = new StoredIndexedBipartiteSetWithOffset[supportLength];
        Set arcs = graph.edgeSet();
        Arcs.access$202(this.GArcs, new int[arcs.size()]);
        Arcs.access$302(this.GArcs, new int[arcs.size()]);
        Arcs.access$402(this.GArcs, new int[arcs.size()]);
        for (Arc a2 : arcs) {
            ((Arcs)this.GArcs).values[a2.id] = a2.value;
            ((Arcs)this.GArcs).dests[a2.id] = a2.dest.id;
            ((Arcs)this.GArcs).origs[a2.id] = a2.orig.id;
            int idx = starts[a2.orig.layer] + a2.value - offsets[a2.orig.layer];
            if (sups[idx] == null) {
                sups[idx] = new TIntHashSet();
            }
            sups[idx].add(a2.id);
        }
        for (int i = 0; i < sups.length; ++i) {
            if (sups[i] == null) continue;
            this.supports[i] = new StoredIndexedBipartiteSetWithOffset(environment, sups[i].toArray());
        }
        Set nodes = graph.vertexSet();
        Nodes.access$502(this.GNodes, new StoredIndexedBipartiteSetWithOffset[nodes.size()]);
        Nodes.access$602(this.GNodes, new StoredIndexedBipartiteSetWithOffset[nodes.size()]);
        Nodes.access$702(this.GNodes, new int[nodes.size()]);
        Nodes.access$802(this.GNodes, new int[nodes.size()]);
        for (Node n : nodes) {
            Set inarc;
            int i;
            ((Nodes)this.GNodes).layers[n.id] = n.layer;
            ((Nodes)this.GNodes).states[n.id] = n.state;
            Set outarc = graph.outgoingEdgesOf(n);
            if (!outarc.isEmpty()) {
                int[] out = new int[outarc.size()];
                i = 0;
                for (Arc a3 : outarc) {
                    out[i++] = a3.id;
                }
                ((Nodes)this.GNodes).outArcs[n.id] = new StoredIndexedBipartiteSetWithOffset(environment, out);
            }
            if ((inarc = graph.incomingEdgesOf(n)).isEmpty()) continue;
            int[] in = new int[inarc.size()];
            i = 0;
            for (Arc a4 : inarc) {
                in[i++] = a4.id;
            }
            ((Nodes)this.GNodes).inArcs[n.id] = new StoredIndexedBipartiteSetWithOffset(environment, in);
        }
    }

    public boolean hasSupport(int i, int j) {
        StoredIndexedBipartiteSetWithOffset sup = this.getSupport(i, j);
        return sup != null && !sup.isEmpty();
    }

    public void clearSupports(int idxVar, int val, Propagator<IntVar> p) throws ContradictionException {
        this.clearSupports(this.getSupport(idxVar, val), p);
    }

    private int getIdx(int i, int j) {
        return this.starts[i] + j - this.offsets[i];
    }

    protected final StoredIndexedBipartiteSetWithOffset getSupport(int i, int j) {
        return this.supports[this.getIdx(i, j)];
    }

    private void removeArc(Propagator<IntVar> propagator) throws ContradictionException {
        while (this.stack.size() > 0) {
            int id;
            DisposableIntIterator it;
            StoredIndexedBipartiteSetWithOffset in;
            int arcId = this.stack.pop();
            int orig = this.GArcs.origs[arcId];
            int dest = this.GArcs.dests[arcId];
            int layer = this.GNodes.layers[orig];
            int value = this.GArcs.values[arcId];
            StoredIndexedBipartiteSetWithOffset support = this.getSupport(layer, value);
            support.remove(arcId);
            if (support.isEmpty()) {
                IntVar var = propagator.getVar(layer);
                try {
                    var.removeValue(value, propagator);
                }
                catch (ContradictionException ex) {
                    this.stack.clear();
                    throw ex;
                }
            }
            StoredIndexedBipartiteSetWithOffset out = this.GNodes.outArcs[orig];
            out.remove(arcId);
            if (this.GNodes.layers[orig] > 0 && out.isEmpty() && (in = this.GNodes.inArcs[orig]) != null) {
                it = in.getIterator();
                while (it.hasNext()) {
                    id = it.next();
                    this.stack.push(id);
                }
                it.dispose();
            }
            in = this.GNodes.inArcs[dest];
            in.remove(arcId);
            if (this.GNodes.layers[dest] >= propagator.getNbVars() || !in.isEmpty() || (out = this.GNodes.outArcs[dest]) == null) continue;
            it = out.getIterator();
            while (it.hasNext()) {
                id = it.next();
                this.stack.push(id);
            }
            it.dispose();
        }
    }

    private void clearSupports(StoredIndexedBipartiteSet supports, Propagator<IntVar> p) throws ContradictionException {
        if (supports != null) {
            DisposableIntIterator it = supports.getIterator();
            while (it.hasNext()) {
                int arcId = it.next();
                this.stack.push(arcId);
            }
            it.dispose();
            this.removeArc(p);
        }
    }

    public String toString() {
        int i;
        StringBuilder st = new StringBuilder();
        int nb = 0;
        for (i = 0; i < this.supports.length; ++i) {
            if (this.supports[i] == null || this.supports[i].isEmpty()) continue;
            ++nb;
        }
        st.append("nb: ").append(nb).append("\n");
        for (i = 0; i < this.supports.length; ++i) {
            if (this.supports[i] == null || this.supports[i].isEmpty()) continue;
            DisposableIntIterator it = this.supports[i].getIterator();
            while (it.hasNext()) {
                int arcId = it.next();
                st.append(arcId).append(",");
            }
            it.dispose();
            st.append("\n");
        }
        return st.toString();
    }

    private class Arcs {
        private int[] values;
        private int[] dests;
        private int[] origs;

        private Arcs() {
        }

        static /* synthetic */ int[] access$202(Arcs x0, int[] x1) {
            x0.values = x1;
            return x1;
        }

        static /* synthetic */ int[] access$302(Arcs x0, int[] x1) {
            x0.dests = x1;
            return x1;
        }

        static /* synthetic */ int[] access$402(Arcs x0, int[] x1) {
            x0.origs = x1;
            return x1;
        }
    }

    private class Nodes {
        private int[] states;
        private int[] layers;
        private StoredIndexedBipartiteSetWithOffset[] outArcs;
        private StoredIndexedBipartiteSetWithOffset[] inArcs;

        private Nodes() {
        }

        static /* synthetic */ StoredIndexedBipartiteSetWithOffset[] access$502(Nodes x0, StoredIndexedBipartiteSetWithOffset[] x1) {
            x0.outArcs = x1;
            return x1;
        }

        static /* synthetic */ StoredIndexedBipartiteSetWithOffset[] access$602(Nodes x0, StoredIndexedBipartiteSetWithOffset[] x1) {
            x0.inArcs = x1;
            return x1;
        }

        static /* synthetic */ int[] access$702(Nodes x0, int[] x1) {
            x0.layers = x1;
            return x1;
        }

        static /* synthetic */ int[] access$802(Nodes x0, int[] x1) {
            x0.states = x1;
            return x1;
        }
    }
}

