/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.awt.Color;
import java.awt.Font;
import java.util.HashSet;
import java.util.Set;
import javax.vecmath.Point2d;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.color.IAtomColorer;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.GeneralPath;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.standard.StandardGenerator;
import org.openscience.cdk.renderer.generators.standard.TextOutline;

final class StandardDonutGenerator {
    private final Set<IBond> bonds = new HashSet<IBond>();
    private final Set<IAtom> atoms = new HashSet<IAtom>();
    IRingSet smallest;
    private final boolean forceDelocalised;
    private final boolean delocalisedDonuts;
    private final double dbSpacing;
    private final double scale;
    private final double stroke;
    private final Color fgColor;
    private final Font font;
    private final IAtomContainer mol;

    StandardDonutGenerator(IAtomContainer mol, Font font, RendererModel model, double stroke) {
        this.mol = mol;
        this.font = font;
        this.forceDelocalised = (Boolean)model.get(StandardGenerator.ForceDelocalisedBondDisplay.class);
        this.delocalisedDonuts = (Boolean)model.get(StandardGenerator.DelocalisedDonutsBondDisplay.class);
        this.dbSpacing = (Double)model.get(StandardGenerator.BondSeparation.class);
        this.scale = (Double)model.get(BasicSceneGenerator.Scale.class);
        this.stroke = stroke;
        this.fgColor = ((IAtomColorer)model.get(StandardGenerator.AtomColor.class)).getAtomColor((IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"C"}));
    }

    private boolean canDelocalise(IAtomContainer ring) {
        boolean okay;
        boolean bl = okay = ring.getBondCount() < 8;
        if (!okay) {
            return false;
        }
        for (IBond bond : ring.bonds()) {
            if (!bond.isAromatic()) {
                okay = false;
            }
            if (bond.getOrder() == null || bond.getOrder() == IBond.Order.UNSET || this.forceDelocalised) continue;
            okay = false;
        }
        return okay;
    }

    IRenderingElement generate() {
        if (!this.delocalisedDonuts) {
            return null;
        }
        ElementGroup group = new ElementGroup();
        this.smallest = Cycles.edgeShort((IAtomContainer)this.mol).toRingSet();
        for (IAtomContainer ring : this.smallest.atomContainers()) {
            if (!this.canDelocalise(ring)) continue;
            for (IBond bond : ring.bonds()) {
                this.bonds.add(bond);
            }
            int charge = 0;
            boolean unpaired = false;
            for (IAtom atom : ring.atoms()) {
                Integer q = atom.getFormalCharge();
                if (q == null || q == 0) continue;
                int nCyclic = 0;
                for (IBond bond : this.mol.getConnectedBondsList(atom)) {
                    if (!bond.isInRing()) continue;
                    ++nCyclic;
                }
                if (nCyclic > 2) continue;
                this.atoms.add(atom);
                charge += atom.getFormalCharge().intValue();
            }
            Point2d p2 = GeometryUtil.get2DCenter((IAtomContainer)ring);
            if (charge != 0) {
                String qText;
                String string = qText = charge < 0 ? "\u2013" : "+";
                if (charge < -1) {
                    qText = Math.abs(charge) + qText;
                } else if (charge > 1) {
                    qText = Math.abs(charge) + qText;
                }
                TextOutline qSym = new TextOutline(qText, this.font);
                qSym = qSym.resize(1.0 / this.scale, -1.0 / this.scale);
                qSym = qSym.translate(p2.x - qSym.getCenter().getX(), p2.y - qSym.getCenter().getY());
                group.add(GeneralPath.shapeOf(qSym.getOutline(), this.fgColor));
            }
            double s = GeometryUtil.getBondLengthMedian((IAtomContainer)ring);
            double n = ring.getBondCount();
            double r = s / (2.0 * Math.tan(Math.PI / n));
            group.add(new OvalElement(p2.x, p2.y, r - 1.5 * this.dbSpacing, this.stroke, false, this.fgColor));
        }
        return group;
    }

    boolean isDelocalised(IBond bond) {
        return this.bonds.contains(bond);
    }

    boolean isChargeDelocalised(IAtom atom) {
        return this.atoms.contains(atom);
    }
}

