## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = identical(Sys.getenv("gm_vignette"), "true")
)

## ----message = FALSE----------------------------------------------------------
# 加载 gm
library(gm)

# 创建 Music 对象
m <- 
  # 初始化 Music 对象
  Music() +
  # 加上 4/4 拍号
  Meter(4, 4) +
  # 加上一条包含四个音的声部
  Line(list("C5", "D5", "E5", "F5"), list(1, 1, 1, 1))

# 转化成乐谱和音频
show(m, c("score", "audio"))

## -----------------------------------------------------------------------------
m <- Music()

## -----------------------------------------------------------------------------
m <- m + Meter(4, 4)

## -----------------------------------------------------------------------------
m <- m + Line(pitches = list("C5"), durations = list("whole"))

## -----------------------------------------------------------------------------
m

## -----------------------------------------------------------------------------
show(m)

## -----------------------------------------------------------------------------
m <- m + Tempo(120)
show(m)

## -----------------------------------------------------------------------------
m <- m + Line(
  pitches = list("C3", "G3"),
  durations = list("half", "half")
)

show(m)

## -----------------------------------------------------------------------------
pitches <- as.list(c(64, 65, 69, 71, 72, 76))
durations <- rep(list(1), length(pitches))

m <- Music() + Meter(4, 4) + Tempo(120)

for (i in 0:8) {
  m <- m + Line(pitches, durations, offset = 0.5 * i)
}

show(m, to = c("score", "audio"))

