## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, message = FALSE---------------------------------------------------
library(collatz)
# Optionally
library(gmp)

## -----------------------------------------------------------------------------
collatz_function(5)
collatz_function(16)

## -----------------------------------------------------------------------------
collatz_function(4, 5, 2, 3)

## -----------------------------------------------------------------------------
collatz_function(3, a=-2)

## -----------------------------------------------------------------------------
collatz_function(99999999999999999999)
collatz_function(as.bigz("99999999999999999999"))

## -----------------------------------------------------------------------------
reverse_function(1)
reverse_function(2)
reverse_function(4)

## -----------------------------------------------------------------------------
reverse_function(3, -3, -2, -5)

## -----------------------------------------------------------------------------
reverse_function(16, a=5)

## -----------------------------------------------------------------------------
reverse_function(99999999999999999999)
reverse_function(as.bigz("99999999999999999999"))

## -----------------------------------------------------------------------------
stopping_time(27)
stopping_time(27, total_stopping_time=TRUE)

## -----------------------------------------------------------------------------
stopping_time(3, 5, 2, 1)

## -----------------------------------------------------------------------------
stopping_time(17, a=5)

## -----------------------------------------------------------------------------
stopping_time(99999999999999999999)
stopping_time(as.bigz("99999999999999999999"))

## -----------------------------------------------------------------------------
stopping_time(27)
stopping_time(27+as.bigz("576460752303423488"))
stopping_time(27+(2*as.bigz("576460752303423488")))
stopping_time(27+(3*as.bigz("576460752303423488")))
stopping_time(27+(4*as.bigz("576460752303423488")))

