/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Missing_Values.AllPossibleValues;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import keel.Algorithms.Preprocess.Missing_Values.AllPossibleValues.FreqList;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class AllPossibleValues {
    double[] mean = null;
    double[] std_dev = null;
    double tempData = 0.0;
    Vector[] X = null;
    int ndatos = 0;
    int nentradas = 0;
    int tipo = 0;
    int direccion = 0;
    int nvariables = 0;
    int nsalidas = 0;
    InstanceSet IS;
    String input_train_name = new String();
    String input_test_name = new String();
    String output_train_name = new String();
    String output_test_name = new String();
    String temp = new String();
    String data_out = new String("");

    public AllPossibleValues(String fileParam) {
        this.config_read(fileParam);
        this.IS = new InstanceSet();
    }

    private void write_results() {
        try {
            FileWriter file_write = new FileWriter(this.output_train_name);
            file_write.write(this.IS.getHeader());
            file_write.write("@data\n");
            for (int i = 0; i < this.ndatos; ++i) {
                for (int inst = 0; inst < this.X[i].size(); ++inst) {
                    file_write.write(((String[])this.X[i].elementAt(inst))[0]);
                    for (int j = 1; j < this.nvariables; ++j) {
                        file_write.write("," + ((String[])this.X[i].elementAt(inst))[j]);
                    }
                    file_write.write("\n");
                }
            }
            file_write.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            System.exit(-1);
        }
    }

    private void config_read(String fileParam) {
        File inputFile = new File(fileParam);
        if (inputFile == null || !inputFile.exists()) {
            System.out.println("parameter " + fileParam + " file doesn't exists!");
            System.exit(-1);
        }
        try {
            String line;
            FileReader file_reader = new FileReader(inputFile);
            BufferedReader buf_reader = new BufferedReader(file_reader);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            String[] out = line.split("algorithm = ");
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("inputData = ");
            out = out[1].split("\\s\"");
            this.input_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.input_test_name = new String(out[1].substring(0, out[1].length() - 1));
            if (this.input_test_name.charAt(this.input_test_name.length() - 1) == '\"') {
                this.input_test_name = this.input_test_name.substring(0, this.input_test_name.length() - 1);
            }
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("outputData = ");
            out = out[1].split("\\s\"");
            this.output_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.output_test_name = new String(out[1].substring(0, out[1].length() - 1));
            if (this.output_test_name.charAt(this.output_test_name.length() - 1) == '\"') {
                this.output_test_name = this.output_test_name.substring(0, this.output_test_name.length() - 1);
            }
            file_reader.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            System.exit(-1);
        }
    }

    public void process() {
        Attribute b;
        int attr;
        int y;
        Attribute a;
        int j;
        Instance inst;
        int j2;
        int i;
        FreqList[] timesSeen;
        boolean valuesRemaining;
        String[] row;
        boolean stepNext;
        boolean fin;
        int lastMissing;
        int out2;
        int in2;
        int out;
        int in;
        FileWriter file_write;
        try {
            file_write = new FileWriter(this.output_train_name);
            try {
                this.IS.readSet(this.input_train_name, true);
                in = 0;
                out = 0;
                in2 = 0;
                out2 = 0;
                lastMissing = -1;
                fin = false;
                stepNext = false;
                row = null;
                valuesRemaining = false;
                timesSeen = null;
                this.ndatos = this.IS.getNumInstances();
                this.nvariables = Attributes.getNumAttributes();
                this.nentradas = Attributes.getInputNumAttributes();
                this.nsalidas = Attributes.getOutputNumAttributes();
                this.X = new Vector[this.ndatos];
                for (i = 0; i < this.ndatos; ++i) {
                    this.X[i] = new Vector();
                }
                timesSeen = new FreqList[this.nvariables];
                for (j2 = 0; j2 < this.nvariables; ++j2) {
                    timesSeen[j2] = new FreqList();
                }
                file_write.write(this.IS.getHeader());
                file_write.write("@data\n");
                for (i = 0; i < this.ndatos; ++i) {
                    inst = this.IS.getInstance(i);
                    in = 0;
                    out = 0;
                    for (j = 0; j < this.nvariables; ++j) {
                        a = Attributes.getAttribute(j);
                        this.direccion = a.getDirectionAttribute();
                        this.tipo = a.getType();
                        if (this.direccion == 1) {
                            if (this.tipo != 0 && !inst.getInputMissingValues(in)) {
                                timesSeen[j].AddElement(new String(String.valueOf(inst.getInputRealValues(in))));
                            } else if (!inst.getInputMissingValues(in)) {
                                timesSeen[j].AddElement(inst.getInputNominalValues(in));
                            }
                            ++in;
                            continue;
                        }
                        if (this.direccion != 2) continue;
                        if (this.tipo != 0 && !inst.getOutputMissingValues(out)) {
                            timesSeen[j].AddElement(new String(String.valueOf(inst.getOutputRealValues(out))));
                        } else if (!inst.getOutputMissingValues(out)) {
                            timesSeen[j].AddElement(inst.getOutputNominalValues(out));
                        }
                        ++out;
                    }
                }
                valuesRemaining = false;
                for (i = 0; i < this.ndatos; ++i) {
                    inst = this.IS.getInstance(i);
                    in = 0;
                    out = 0;
                    row = new String[this.nvariables];
                    if (!inst.existsAnyMissingValue()) {
                        for (j = 0; j < this.nvariables; ++j) {
                            a = Attributes.getAttribute(j);
                            this.direccion = a.getDirectionAttribute();
                            this.tipo = a.getType();
                            if (this.direccion == 1) {
                                row[j] = this.tipo != 0 ? new String(String.valueOf(inst.getInputRealValues(in))) : inst.getInputNominalValues(in);
                                ++in;
                                continue;
                            }
                            if (this.direccion != 2) continue;
                            row[j] = this.tipo != 0 ? new String(String.valueOf(inst.getOutputRealValues(out))) : inst.getOutputNominalValues(out);
                            ++out;
                        }
                        file_write.write(row[0]);
                        for (y = 1; y < this.nvariables; ++y) {
                            file_write.write("," + row[y]);
                        }
                        file_write.write("\n");
                        continue;
                    }
                    in2 = 0;
                    out2 = 0;
                    for (attr = 0; attr < this.nvariables; ++attr) {
                        b = Attributes.getAttribute(attr);
                        this.direccion = b.getDirectionAttribute();
                        this.tipo = b.getType();
                        if (this.direccion == 1) {
                            if (this.tipo != 0 && !inst.getInputMissingValues(in2)) {
                                row[attr] = new String(String.valueOf(inst.getInputRealValues(in2)));
                            } else if (!inst.getInputMissingValues(in2)) {
                                row[attr] = inst.getInputNominalValues(in2);
                            } else {
                                lastMissing = attr;
                            }
                            ++in2;
                            continue;
                        }
                        if (this.direccion != 2) continue;
                        if (this.tipo != 0 && !inst.getOutputMissingValues(out2)) {
                            row[attr] = new String(String.valueOf(inst.getOutputRealValues(out2)));
                        } else if (!inst.getOutputMissingValues(out2)) {
                            row[attr] = inst.getOutputNominalValues(out2);
                        } else {
                            lastMissing = attr;
                        }
                        ++out2;
                    }
                    for (attr = 0; attr < this.nvariables; ++attr) {
                        timesSeen[attr].reset();
                    }
                    fin = false;
                    stepNext = false;
                    while (!fin) {
                        in2 = 0;
                        out2 = 0;
                        for (attr = 0; attr < this.nvariables && !fin; ++attr) {
                            b = Attributes.getAttribute(attr);
                            this.direccion = b.getDirectionAttribute();
                            this.tipo = b.getType();
                            if (this.direccion == 1) {
                                if (inst.getInputMissingValues(in2)) {
                                    if (stepNext) {
                                        timesSeen[attr].iterate();
                                        stepNext = false;
                                    }
                                    if (timesSeen[attr].outOfBounds()) {
                                        stepNext = true;
                                        if (attr == lastMissing) {
                                            fin = true;
                                        }
                                        timesSeen[attr].reset();
                                    }
                                    if (!fin) {
                                        row[attr] = timesSeen[attr].getCurrent().getValue();
                                    }
                                }
                                ++in2;
                                continue;
                            }
                            if (this.direccion != 2) continue;
                            if (inst.getOutputMissingValues(out2)) {
                                if (stepNext) {
                                    timesSeen[attr].iterate();
                                    stepNext = false;
                                }
                                if (timesSeen[attr].outOfBounds()) {
                                    stepNext = true;
                                    if (attr == lastMissing) {
                                        fin = true;
                                    }
                                    timesSeen[attr].reset();
                                }
                                if (!fin) {
                                    row[attr] = timesSeen[attr].getCurrent().getValue();
                                }
                            }
                            ++out2;
                        }
                        if (fin) continue;
                        stepNext = true;
                        file_write.write(row[0]);
                        for (y = 1; y < this.nvariables; ++y) {
                            file_write.write("," + row[y]);
                        }
                        file_write.write("\n");
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Dataset exception = " + e);
                e.printStackTrace();
                System.exit(-1);
            }
            file_write.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            e.printStackTrace();
            System.exit(-1);
        }
        if (this.input_train_name.compareTo(this.input_test_name) != 0) {
            try {
                file_write = new FileWriter(this.output_test_name);
                try {
                    this.IS.readSet(this.input_test_name, false);
                    in = 0;
                    out = 0;
                    in2 = 0;
                    out2 = 0;
                    lastMissing = -1;
                    fin = false;
                    stepNext = false;
                    row = null;
                    valuesRemaining = false;
                    timesSeen = null;
                    this.ndatos = this.IS.getNumInstances();
                    this.nvariables = Attributes.getNumAttributes();
                    this.nentradas = Attributes.getInputNumAttributes();
                    this.nsalidas = Attributes.getOutputNumAttributes();
                    this.X = new Vector[this.ndatos];
                    for (i = 0; i < this.ndatos; ++i) {
                        this.X[i] = new Vector();
                    }
                    timesSeen = new FreqList[this.nvariables];
                    for (j2 = 0; j2 < this.nvariables; ++j2) {
                        timesSeen[j2] = new FreqList();
                    }
                    file_write.write(this.IS.getHeader());
                    file_write.write("@data\n");
                    for (i = 0; i < this.ndatos; ++i) {
                        inst = this.IS.getInstance(i);
                        in = 0;
                        out = 0;
                        for (j = 0; j < this.nvariables; ++j) {
                            a = Attributes.getAttribute(j);
                            this.direccion = a.getDirectionAttribute();
                            this.tipo = a.getType();
                            if (this.direccion == 1) {
                                if (this.tipo != 0 && !inst.getInputMissingValues(in)) {
                                    timesSeen[j].AddElement(new String(String.valueOf(inst.getInputRealValues(in))));
                                } else if (!inst.getInputMissingValues(in)) {
                                    timesSeen[j].AddElement(inst.getInputNominalValues(in));
                                }
                                ++in;
                                continue;
                            }
                            if (this.direccion != 2) continue;
                            if (this.tipo != 0 && !inst.getOutputMissingValues(out)) {
                                timesSeen[j].AddElement(new String(String.valueOf(inst.getOutputRealValues(out))));
                            } else if (!inst.getOutputMissingValues(out)) {
                                timesSeen[j].AddElement(inst.getOutputNominalValues(out));
                            }
                            ++out;
                        }
                    }
                    valuesRemaining = false;
                    for (i = 0; i < this.ndatos; ++i) {
                        inst = this.IS.getInstance(i);
                        in = 0;
                        out = 0;
                        row = new String[this.nvariables];
                        if (!inst.existsAnyMissingValue()) {
                            for (j = 0; j < this.nvariables; ++j) {
                                a = Attributes.getAttribute(j);
                                this.direccion = a.getDirectionAttribute();
                                this.tipo = a.getType();
                                if (this.direccion == 1) {
                                    row[j] = this.tipo != 0 ? new String(String.valueOf(inst.getInputRealValues(in))) : inst.getInputNominalValues(in);
                                    ++in;
                                    continue;
                                }
                                if (this.direccion != 2) continue;
                                row[j] = this.tipo != 0 ? new String(String.valueOf(inst.getOutputRealValues(out))) : inst.getOutputNominalValues(out);
                                ++out;
                            }
                            file_write.write(row[0]);
                            for (y = 1; y < this.nvariables; ++y) {
                                file_write.write("," + row[y]);
                            }
                            file_write.write("\n");
                            continue;
                        }
                        in2 = 0;
                        out2 = 0;
                        for (attr = 0; attr < this.nvariables; ++attr) {
                            b = Attributes.getAttribute(attr);
                            this.direccion = b.getDirectionAttribute();
                            this.tipo = b.getType();
                            if (this.direccion == 1) {
                                if (this.tipo != 0 && !inst.getInputMissingValues(in2)) {
                                    row[attr] = new String(String.valueOf(inst.getInputRealValues(in2)));
                                } else if (!inst.getInputMissingValues(in2)) {
                                    row[attr] = inst.getInputNominalValues(in2);
                                } else {
                                    lastMissing = attr;
                                }
                                ++in2;
                                continue;
                            }
                            if (this.direccion != 2) continue;
                            if (this.tipo != 0 && !inst.getOutputMissingValues(out2)) {
                                row[attr] = new String(String.valueOf(inst.getOutputRealValues(out2)));
                            } else if (!inst.getOutputMissingValues(out2)) {
                                row[attr] = inst.getOutputNominalValues(out2);
                            } else {
                                lastMissing = attr;
                            }
                            ++out2;
                        }
                        for (attr = 0; attr < this.nvariables; ++attr) {
                            timesSeen[attr].reset();
                        }
                        fin = false;
                        stepNext = false;
                        while (!fin) {
                            in2 = 0;
                            out2 = 0;
                            for (attr = 0; attr < this.nvariables && !fin; ++attr) {
                                b = Attributes.getAttribute(attr);
                                this.direccion = b.getDirectionAttribute();
                                this.tipo = b.getType();
                                if (this.direccion == 1) {
                                    if (inst.getInputMissingValues(in2)) {
                                        if (stepNext) {
                                            timesSeen[attr].iterate();
                                            stepNext = false;
                                        }
                                        if (timesSeen[attr].outOfBounds()) {
                                            stepNext = true;
                                            if (attr == lastMissing) {
                                                fin = true;
                                            }
                                            timesSeen[attr].reset();
                                        }
                                        if (!fin) {
                                            row[attr] = timesSeen[attr].getCurrent().getValue();
                                        }
                                    }
                                    ++in2;
                                    continue;
                                }
                                if (this.direccion != 2) continue;
                                if (inst.getOutputMissingValues(out2)) {
                                    if (stepNext) {
                                        timesSeen[attr].iterate();
                                        stepNext = false;
                                    }
                                    if (timesSeen[attr].outOfBounds()) {
                                        stepNext = true;
                                        if (attr == lastMissing) {
                                            fin = true;
                                        }
                                        timesSeen[attr].reset();
                                    }
                                    if (!fin) {
                                        row[attr] = timesSeen[attr].getCurrent().getValue();
                                    }
                                }
                                ++out2;
                            }
                            if (fin) continue;
                            stepNext = true;
                            file_write.write(row[0]);
                            for (y = 1; y < this.nvariables; ++y) {
                                file_write.write("," + row[y]);
                            }
                            file_write.write("\n");
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("Dataset exception = " + e);
                    System.exit(-1);
                }
                file_write.close();
            }
            catch (IOException e) {
                System.out.println("IO exception = " + e);
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }
}

