/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.mutators.parametric;

import keel.Algorithms.Neural_Networks.NNEP_Common.NeuralNetIndividual;
import keel.Algorithms.Neural_Networks.NNEP_Common.mutators.parametric.ParametricMutator;

public class ParametricSRMutator<I extends NeuralNetIndividual>
extends ParametricMutator<I> {
    private static final long serialVersionUID = -4723976893815126429L;
    private int successfulMutations = 0;
    private int totalMutations = 0;
    private int nOfGenerations = 0;
    protected double successRatio;

    public double getSuccessRatio() {
        return this.successRatio;
    }

    @Override
    public void alphaInit() {
        this.alphaInput = this.initialAlphaInput;
        this.alphaOutput = this.initialAlphaOutput;
        this.successfulMutations = 0;
        this.totalMutations = 0;
        this.nOfGenerations = 0;
    }

    @Override
    protected void alphaUpdate(double bestFitness) {
        if (this.nOfGenerations == 5) {
            this.successRatio = (double)this.successfulMutations / (double)this.totalMutations;
            if (this.successRatio < 0.2) {
                this.alphaInput *= 0.9;
                this.alphaOutput *= 0.9;
            } else if (this.successRatio > 0.2) {
                this.alphaInput *= 1.1;
                this.alphaOutput *= 1.1;
            }
            this.successfulMutations = 0;
            this.totalMutations = 0;
            this.nOfGenerations = 0;
        }
        ++this.nOfGenerations;
    }

    @Override
    protected void alphaControlParametersUpdate(double newFitness, double fitness) {
        if (newFitness > fitness) {
            ++this.successfulMutations;
        }
        ++this.totalMutations;
    }
}

