/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOEA_Ghosh;

import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOEA_Ghosh.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOEA_Ghosh.myDataset;
import org.core.Randomize;

public class Chromosome
implements Comparable {
    public Gene[] genes;
    public double[] objectives;
    public int numObjectives;
    public double antsSupport;
    public double consSupport;
    public double support;
    public double confidence;
    public double lift;
    public double conv;
    public double CF;
    public double netConf;
    public double yulesQ;
    public int nAnts;
    public int nCons;
    boolean n_e;
    int rank;
    double fitness_rank;

    public Chromosome(Gene[] genes, int numObjectives) {
        this.genes = new Gene[genes.length];
        this.nAnts = 0;
        this.nCons = 0;
        for (int i = 0; i < genes.length; ++i) {
            this.genes[i] = genes[i].copy();
            if (this.genes[i].getActAs() == 1) {
                ++this.nAnts;
            }
            if (this.genes[i].getActAs() != 1) continue;
            ++this.nCons;
        }
        this.numObjectives = numObjectives;
        this.objectives = new double[3];
        this.support = 0.0;
        this.antsSupport = 0.0;
        this.consSupport = 0.0;
        this.confidence = 0.0;
        this.rank = -1;
        this.n_e = true;
        this.fitness_rank = 0.0;
        this.lift = 0.0;
        this.conv = 0.0;
        this.CF = 0.0;
        this.netConf = 0.0;
        this.yulesQ = 0.0;
    }

    public Chromosome copy() {
        Chromosome chromo = new Chromosome(this.genes, this.numObjectives);
        for (int i = 0; i < this.numObjectives; ++i) {
            chromo.objectives[i] = this.objectives[i];
        }
        chromo.support = this.support;
        chromo.antsSupport = this.antsSupport;
        chromo.consSupport = this.consSupport;
        chromo.confidence = this.confidence;
        chromo.nAnts = this.nAnts;
        chromo.nCons = this.nCons;
        chromo.rank = this.rank;
        chromo.fitness_rank = this.fitness_rank;
        chromo.n_e = this.n_e;
        chromo.lift = this.lift;
        chromo.conv = this.conv;
        chromo.CF = this.CF;
        chromo.netConf = this.netConf;
        chromo.yulesQ = this.yulesQ;
        return chromo;
    }

    public void setObjetives(double[] objectives) {
        this.objectives = objectives;
    }

    public double[] getObjectives() {
        return this.objectives;
    }

    public void setSupport(double support) {
        this.support = support;
    }

    public double getSupport() {
        return this.support;
    }

    public double getAntsSupport() {
        return this.antsSupport;
    }

    public void setConfidence(double confidence) {
        this.confidence = confidence;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public Gene[] getGenes() {
        return this.genes;
    }

    public Gene getGene(int i) {
        return this.genes[i];
    }

    public void forceConsistency() {
        int count;
        int pos;
        int i;
        int n_cons = 0;
        int n_ant = 0;
        for (i = 0; i < this.genes.length; ++i) {
            if (this.genes[i].getActAs() == 1) {
                ++n_ant;
            }
            if (this.genes[i].getActAs() != 2) continue;
            ++n_cons;
        }
        if (n_cons < 1) {
            if (n_ant > 1) {
                pos = Randomize.RandintClosed(1, n_ant);
                count = 1;
                for (i = 0; i < this.genes.length && count <= pos; ++i) {
                    if (this.genes[i].getActAs() != 1) continue;
                    if (count == pos) {
                        this.genes[i].setActAs(2);
                        --n_ant;
                    }
                    ++count;
                }
            } else {
                pos = Randomize.Randint(0, this.genes.length);
                while (this.genes[pos].getActAs() != 0) {
                    pos = Randomize.Randint(0, this.genes.length);
                }
                this.genes[pos].setActAs(2);
            }
            ++n_cons;
        }
        if (n_ant < 1) {
            if (n_cons > 1) {
                pos = Randomize.RandintClosed(1, n_cons);
                count = 1;
                for (i = 0; i < this.genes.length && count <= pos; ++i) {
                    if (this.genes[i].getActAs() != 2) continue;
                    if (count == pos) {
                        this.genes[i].setActAs(1);
                        --n_cons;
                    }
                    ++count;
                }
            } else {
                pos = Randomize.Randint(0, this.genes.length);
                while (this.genes[pos].getActAs() != 0) {
                    pos = Randomize.Randint(0, this.genes.length);
                }
                this.genes[pos].setActAs(1);
            }
        }
    }

    public boolean equals(Chromosome chr) {
        for (int i = 0; i < this.genes.length; ++i) {
            if (this.genes[i].getActAs() != 0 && chr.genes[i].getActAs() == 0) {
                return false;
            }
            if (this.genes[i].getActAs() == 0 && chr.genes[i].getActAs() != 0) {
                return false;
            }
            if (this.genes[i].getActAs() == 0 || chr.genes[i].getActAs() == 0 || chr.genes[i].equals(this.genes[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String str = "Rank:  " + this.rank + "Lift:  " + this.objectives[0] + "; Rule Support: " + this.support + "; Rule Confidence: " + this.confidence + "\n";
        for (int j = 0; j < this.numObjectives; ++j) {
            str = str + "Objetives:[" + j + "]" + this.objectives[j] + "\n";
        }
        for (int i = 0; i < this.genes.length; ++i) {
            str = str + this.genes[i] + "\n";
        }
        return str;
    }

    public double getObjective(int num) {
        if (num < 0 || num > this.numObjectives) {
            return -1.0;
        }
        return this.objectives[num];
    }

    public int isBetter(Chromosome chromo) {
        if (this.rank < chromo.rank) {
            return 1;
        }
        if (this.rank > chromo.rank) {
            return -1;
        }
        return 0;
    }

    public int compareTo(Object chr) {
        if (((Chromosome)chr).rank > this.rank) {
            return -1;
        }
        if (((Chromosome)chr).rank < this.rank) {
            return 1;
        }
        return 0;
    }

    public int getnCons() {
        return this.nCons;
    }

    public boolean isCovered(double[] example) {
        boolean covered = true;
        for (int i = 0; i < this.genes.length && covered; ++i) {
            if (this.genes[i].getActAs() == 0) continue;
            covered = this.genes[i].isCover(i, example[i]);
        }
        return covered;
    }

    public void setNew(boolean value) {
        this.n_e = value;
    }

    public boolean isNew() {
        return this.n_e;
    }

    public void computeObjetives(myDataset dataset) {
        int i;
        int nTrans = dataset.getnTrans();
        int nVars = dataset.getnVars();
        this.antsSupport = 0.0;
        this.consSupport = 0.0;
        this.support = 0.0;
        this.confidence = 0.0;
        this.nAnts = 0;
        this.nCons = 0;
        int[] covered = new int[nTrans];
        for (i = 0; i < nTrans; ++i) {
            covered[i] = 0;
        }
        for (i = 0; i < this.numObjectives; ++i) {
            this.objectives[i] = 0.0;
        }
        for (i = 0; i < nTrans; ++i) {
            double[] example = dataset.getExample(i);
            boolean consCover = true;
            boolean antsCover = true;
            for (int j = 0; j < nVars && (antsCover || consCover); ++j) {
                if (this.genes[j].getActAs() == 1 && antsCover) {
                    if (this.genes[j].isCover(j, example[j])) continue;
                    antsCover = false;
                    continue;
                }
                if (this.genes[j].getActAs() != 2 || !consCover || this.genes[j].isCover(j, example[j])) continue;
                consCover = false;
            }
            if (antsCover) {
                this.antsSupport += 1.0;
            }
            if (consCover) {
                this.consSupport += 1.0;
            }
            if (!antsCover || !consCover) continue;
            this.support += 1.0;
            covered[i] = 1;
        }
        this.antsSupport /= (double)nTrans;
        this.consSupport /= (double)nTrans;
        this.support /= (double)nTrans;
        if (this.antsSupport > 0.0) {
            this.confidence = this.support / this.antsSupport;
        }
        for (i = 0; i < nVars; ++i) {
            if (this.genes[i].getActAs() == 1) {
                ++this.nAnts;
            }
            if (this.genes[i].getActAs() != 2) continue;
            ++this.nCons;
        }
        this.lift = this.antsSupport == 0.0 || this.consSupport == 0.0 ? 1.0 : this.support / (this.antsSupport * this.consSupport);
        this.conv = this.consSupport == 1.0 || this.antsSupport == 0.0 ? 1.0 : this.antsSupport * (1.0 - this.consSupport) / (this.antsSupport - this.support);
        this.netConf = this.antsSupport == 0.0 || this.antsSupport == 1.0 || Math.abs(this.antsSupport * (1.0 - this.antsSupport)) <= 0.001 ? 0.0 : (this.support - this.antsSupport * this.consSupport) / (this.antsSupport * (1.0 - this.antsSupport));
        double numeratorYules = this.support * (1.0 - this.consSupport - this.antsSupport + this.support) - (this.antsSupport - this.support) * (this.consSupport - this.support);
        double denominatorYules = this.support * (1.0 - this.consSupport - this.antsSupport + this.support) + (this.antsSupport - this.support) * (this.consSupport - this.support);
        this.yulesQ = this.antsSupport == 0.0 || this.antsSupport == 1.0 || this.consSupport == 0.0 || this.consSupport == 1.0 || Math.abs(denominatorYules) <= 0.001 ? 0.0 : numeratorYules / denominatorYules;
        this.CF = 0.0;
        if (this.confidence > this.consSupport) {
            this.CF = (this.confidence - this.consSupport) / (1.0 - this.consSupport);
        } else if (this.confidence < this.consSupport) {
            this.CF = (this.confidence - this.consSupport) / this.consSupport;
        }
        if (this.numObjectives > 0) {
            this.objectives[0] = this.support / this.antsSupport * (this.support / this.consSupport) * (1.0 - this.support / (double)dataset.getnTrans());
        }
        if (this.numObjectives > 1) {
            this.objectives[1] = this.confidence;
        }
        if (this.numObjectives > 2) {
            this.objectives[2] = Math.log(1 + this.nCons) / Math.log(1 + this.nCons + this.nAnts);
        }
    }

    public void computeFitness(int max_rank) {
        this.fitness_rank = max_rank + 1 - this.rank;
    }

    public int getnAnts() {
        return this.nAnts;
    }

    public void setnAnts(int value) {
        this.nAnts = value;
    }

    public int getRank() {
        return this.rank;
    }

    public ArrayList<Integer> getCoveredTIDs(myDataset dataset) {
        ArrayList<Integer> TIDs = new ArrayList<Integer>();
        for (int i = 0; i < dataset.getnTrans(); ++i) {
            double[] example = dataset.getExample(i);
            if (!this.isCovered(example)) continue;
            TIDs.add(i);
        }
        return TIDs;
    }

    public double getFitness_rank() {
        return this.fitness_rank;
    }

    public void setFitness_rank(double fitness_rank) {
        this.fitness_rank = fitness_rank;
    }

    public double getLift() {
        return this.lift;
    }

    public void setLift(double lift) {
        this.lift = lift;
    }

    public double getCF() {
        return this.CF;
    }

    public void setCF(double cf) {
        this.CF = cf;
    }

    public double getConv() {
        return this.conv;
    }

    public void setConv(double conv) {
        this.conv = conv;
    }

    public double getNetConf() {
        return this.netConf;
    }

    public void setNetConf(double netConf) {
        this.netConf = netConf;
    }

    public double getConsSupport() {
        return this.consSupport;
    }

    public void setConsSupport(double consSupport) {
        this.consSupport = consSupport;
    }

    public double getYulesQ() {
        return this.yulesQ;
    }
}

