/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.metaAnalysis;

import dr.inference.distribution.EmpiricalDistributionData;
import dr.inference.distribution.EmpiricalDistributionLikelihood;
import dr.math.distributions.NormalDistribution;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.ohdsi.metaAnalysis.DataModel;

public class SkewNormalDataModel
extends DataModel.Base
implements DataModel {
    public SkewNormalDataModel(String string) {
        this();
        File file = new File(string);
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        try {
            Scanner scanner = new Scanner(file);
            while (scanner.hasNext()) {
                String string2 = scanner.next();
                string2 = string2.replaceAll("\"", "");
                String[] stringArray = string2.split(",");
                arrayList.add(Arrays.asList(stringArray));
            }
            scanner.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        int n = ((List)arrayList.get(0)).indexOf("mu");
        int n2 = ((List)arrayList.get(0)).indexOf("sigma");
        int n3 = ((List)arrayList.get(0)).indexOf("gamma");
        for (int i = 1; i < arrayList.size(); ++i) {
            double[] dArray = new double[]{Double.parseDouble((String)((List)arrayList.get(i)).get(n)), Double.parseDouble((String)((List)arrayList.get(i)).get(n2)), Double.parseDouble((String)((List)arrayList.get(i)).get(n3))};
            this.addLikelihoodParameters(dArray, null);
        }
        this.finish();
    }

    public SkewNormalDataModel() {
    }

    @Override
    EmpiricalDistributionLikelihood makeFunctionalForm(List<EmpiricalDistributionData> list) {
        return new EmpiricalDistributionLikelihood(list, false){
            private static final long serialVersionUID = 6515855145410583409L;

            private final double skewNormal(double d, double d2, double d3, double d4) {
                return Math.log(2.0) + NormalDistribution.logPdf((double)d, (double)d2, (double)d3) + NormalDistribution.cdf((double)(d4 * (d - d2)), (double)0.0, (double)d3, (boolean)true);
            }

            protected double logPDF(double d, EmpiricalDistributionData empiricalDistributionData) {
                double d2 = empiricalDistributionData.values[0];
                double d3 = empiricalDistributionData.values[1];
                double d4 = empiricalDistributionData.values[2];
                return this.skewNormal(d, d2, d3, d4);
            }

            protected double gradientLogPdf(double d, EmpiricalDistributionData empiricalDistributionData) {
                double d2 = empiricalDistributionData.values[0];
                double d3 = empiricalDistributionData.values[1];
                double d4 = empiricalDistributionData.values[2];
                double d5 = d4 * (d - d2);
                return NormalDistribution.gradLogPdf((double)d, (double)d2, (double)d3) + d4 * NormalDistribution.pdf((double)d5, (double)0.0, (double)d3) / NormalDistribution.cdf((double)d5, (double)0.0, (double)d3, (boolean)false);
            }
        };
    }
}

