/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.icon;

import ch.randelshofer.quaqua.util.Images;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class MultiIcon
implements Icon {
    protected Icon[] icons;
    private Image tiledImage;
    private int tileCount;
    private boolean isTiledHorizontaly;

    public MultiIcon(Icon[] icons) {
        if (icons == null) {
            throw new IllegalArgumentException("'icons' must not be null");
        }
        if (icons.length == 0) {
            throw new IllegalArgumentException("'icons' array must have length > 0");
        }
        this.icons = icons;
        this.generateMissingIcons();
    }

    public MultiIcon(Image[] images) {
        this.icons = new Icon[images.length];
        int n = this.icons.length;
        for (int i = 0; i < n; ++i) {
            if (images[i] == null) continue;
            this.icons[i] = new ImageIcon(images[i]);
        }
        this.generateMissingIcons();
    }

    public MultiIcon(Image tiledImage, int tileCount, boolean isTiledHorizontaly) {
        this.tiledImage = tiledImage;
        this.tileCount = tileCount;
        this.isTiledHorizontaly = isTiledHorizontaly;
    }

    public int getIconHeight() {
        this.generateIconsFromTiledImage();
        return this.icons[0] == null ? 0 : this.icons[0].getIconHeight();
    }

    public int getIconWidth() {
        this.generateIconsFromTiledImage();
        return this.icons[0] == null ? 0 : this.icons[0].getIconWidth();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.generateIconsFromTiledImage();
        Icon icon = this.getIcon(c);
        if (icon != null) {
            icon.paintIcon(c, g, x, y);
        }
    }

    private void generateIconsFromTiledImage() {
        if (this.icons == null) {
            this.icons = new Icon[this.tileCount];
            BufferedImage[] images = Images.split(this.tiledImage, this.tileCount, this.isTiledHorizontaly);
            int n = Math.min(images.length, this.icons.length);
            for (int i = 0; i < n; ++i) {
                if (images[i] == null) continue;
                this.icons[i] = new ImageIcon(images[i]);
            }
            this.generateMissingIcons();
            this.tiledImage = null;
        }
    }

    protected abstract Icon getIcon(Component var1);

    protected abstract void generateMissingIcons();
}

