/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import CADStat.java.plots.SubsetFormatter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class TreeRegression
extends DataPlotDialog {
    private JPanel analysisOptionsPane;
    private JSpinner cp;
    private JLabel cpLabel;
    private JComboBox dependentComboBox;
    private JLabel dependentLabel;
    private JLabel independentLabel;
    private JList independentList;
    private JScrollPane independentScrollPane;
    private JSpinner minBucket;
    private JLabel minBucketLabel;
    private JSpinner minSplit;
    private JLabel minSplitLabel;
    private JPanel modelEqPane;
    private JScrollPane modelEqScrollPane;
    private JTextArea modelEqTextArea;
    private JPanel plotPane;
    private JPanel rightPane;
    private JPanel varPane;

    @Override
    protected void initCustom() {
        this.initComponents();
        this.getPlotPane().add((Component)this.plotPane, "Center");
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeRegression.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.refreshVariableList();
        this.refreshValidity();
        this.updateModelEquation();
    }

    private void datasetComboBoxActionPerformed(ActionEvent e) {
        this.refreshVariableList();
        this.refreshValidity();
        this.updateModelEquation();
    }

    public void updateModelEquation() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            String modelEq = this.dependentComboBox.getSelectedItem() + " ~ " + RUtils.toString(this.independentList.getSelectedValues(), " + ", "");
            this.modelEqTextArea.setText(modelEq);
        } else {
            this.modelEqTextArea.setText(null);
        }
    }

    public void refreshVariableListValidity() {
        this.dependentLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.dependentComboBox.getItemCount() > 0);
        this.dependentComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.dependentComboBox.getItemCount() > 0);
        this.independentLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.independentList.getModel().getSize() > 0);
        this.independentList.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.independentList.getModel().getSize() > 0);
    }

    public void refreshVariableList() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            Vector nonFactors = null;
            try {
                nonFactors = RUtils.colnamesVector(this.getDatasetPane().getSelectedDataset());
            }
            catch (REngineException ex) {
                Logger.getLogger(TreeRegression.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (REXPMismatchException ex) {
                Logger.getLogger(TreeRegression.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.dependentComboBox.setModel(new DefaultComboBoxModel(nonFactors));
            if (nonFactors != null) {
                this.independentList.setListData(nonFactors);
            } else {
                this.independentList.removeAll();
            }
            if (this.dependentComboBox.getItemCount() > 0) {
                this.dependentComboBox.setSelectedIndex(0);
            }
        } else {
            this.dependentComboBox.removeAllItems();
            this.independentList.setModel(new DefaultListModel());
        }
        this.refreshValidity();
    }

    public void refreshSubmitButtonValidity() {
        this.getSubmitButton().setEnabled(!this.independentList.isSelectionEmpty());
    }

    public void refreshValidity() {
        this.refreshVariableListValidity();
        this.refreshSubmitButtonValidity();
    }

    private void initComponents() {
        this.plotPane = new JPanel();
        this.modelEqPane = new JPanel();
        this.modelEqScrollPane = new JScrollPane();
        this.modelEqTextArea = new JTextArea();
        this.varPane = new JPanel();
        this.dependentLabel = new JLabel();
        this.dependentComboBox = new JComboBox();
        this.independentLabel = new JLabel();
        this.independentScrollPane = new JScrollPane();
        this.independentList = new JList();
        this.rightPane = new JPanel();
        this.analysisOptionsPane = new JPanel();
        this.minSplitLabel = new JLabel();
        this.minSplit = new JSpinner();
        this.minBucketLabel = new JLabel();
        this.minBucket = new JSpinner();
        this.cpLabel = new JLabel();
        this.cp = new JSpinner();
        this.modelEqPane.setBorder(BorderFactory.createTitledBorder("Model Equation"));
        this.modelEqTextArea.setColumns(20);
        this.modelEqTextArea.setEditable(false);
        this.modelEqTextArea.setLineWrap(true);
        this.modelEqTextArea.setRows(2);
        this.modelEqTextArea.setWrapStyleWord(true);
        this.modelEqScrollPane.setViewportView(this.modelEqTextArea);
        GroupLayout modelEqPaneLayout = new GroupLayout(this.modelEqPane);
        this.modelEqPane.setLayout(modelEqPaneLayout);
        modelEqPaneLayout.setHorizontalGroup(modelEqPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, modelEqPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.modelEqScrollPane, -1, 475, Short.MAX_VALUE).addContainerGap()));
        modelEqPaneLayout.setVerticalGroup(modelEqPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modelEqPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.modelEqScrollPane, -2, -1, -2).addContainerGap(15, Short.MAX_VALUE)));
        this.varPane.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.dependentLabel.setText("Dependent:");
        this.dependentComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeRegression.this.dependentComboBoxActionPerformed(evt);
            }
        });
        this.independentLabel.setText("Independent:");
        this.independentList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                TreeRegression.this.independentListValueChanged(evt);
            }
        });
        this.independentScrollPane.setViewportView(this.independentList);
        GroupLayout varPaneLayout = new GroupLayout(this.varPane);
        this.varPane.setLayout(varPaneLayout);
        varPaneLayout.setHorizontalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.independentLabel).addComponent(this.dependentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.independentScrollPane, -1, 173, Short.MAX_VALUE).addComponent(this.dependentComboBox, GroupLayout.Alignment.TRAILING, 0, 173, Short.MAX_VALUE)).addContainerGap()));
        varPaneLayout.setVerticalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dependentComboBox, -2, -1, -2).addComponent(this.dependentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.independentLabel).addComponent(this.independentScrollPane, -1, 156, Short.MAX_VALUE)).addContainerGap()));
        this.analysisOptionsPane.setBorder(BorderFactory.createTitledBorder("Analysis Options"));
        this.minSplitLabel.setText("Min Split:");
        this.minSplit.setModel(new SpinnerNumberModel(20.0, 1.0, 99.0, 1.0));
        this.minBucketLabel.setText("Min Bucket:");
        this.minBucket.setModel(new SpinnerNumberModel(7.0, 1.0, 99.0, 1.0));
        this.cpLabel.setText("CP:");
        this.cp.setModel(new SpinnerNumberModel(0.01, 0.01, 0.99, 0.01));
        GroupLayout analysisOptionsPaneLayout = new GroupLayout(this.analysisOptionsPane);
        this.analysisOptionsPane.setLayout(analysisOptionsPaneLayout);
        analysisOptionsPaneLayout.setHorizontalGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().addGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.minSplitLabel).addComponent(this.minBucketLabel).addComponent(this.cpLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.minBucket).addComponent(this.minSplit)).addComponent(this.cp, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        analysisOptionsPaneLayout.setVerticalGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().addGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minSplit, -2, -1, -2).addComponent(this.minSplitLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minBucketLabel).addComponent(this.minBucket, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cpLabel).addComponent(this.cp, -2, -1, -2)).addContainerGap(105, Short.MAX_VALUE)));
        GroupLayout rightPaneLayout = new GroupLayout(this.rightPane);
        this.rightPane.setLayout(rightPaneLayout);
        rightPaneLayout.setHorizontalGroup(rightPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.analysisOptionsPane, -2, -1, -2));
        rightPaneLayout.setVerticalGroup(rightPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.analysisOptionsPane, -1, -1, Short.MAX_VALUE));
        GroupLayout plotPaneLayout = new GroupLayout(this.plotPane);
        this.plotPane.setLayout(plotPaneLayout);
        plotPaneLayout.setHorizontalGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPaneLayout.createSequentialGroup().addContainerGap().addGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.modelEqPane, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, plotPaneLayout.createSequentialGroup().addComponent(this.varPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rightPane, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        plotPaneLayout.setVerticalGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.modelEqPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.rightPane, -1, -1, Short.MAX_VALUE).addComponent(this.varPane, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.setTitle("Tree Regression");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 554) / 2, (screenSize.height - 539) / 2, 554, 539);
    }

    private void dependentComboBoxActionPerformed(ActionEvent evt) {
        this.updateModelEquation();
    }

    private void independentListValueChanged(ListSelectionEvent evt) {
        this.updateModelEquation();
        this.refreshSubmitButtonValidity();
    }

    @Override
    protected void submitButtonAction() {
        String cmd = "rpart.JGR(my.data=" + this.getDatasetPane().getSelectedDataset() + ", subset1.name=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'") + ", subset1.val=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : SubsetFormatter.formatSubset(this.getFactorSelectionPane1().getSelectedFactorValues())) + ", subset2.name=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'") + ", subset2.val=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : SubsetFormatter.formatSubset(this.getFactorSelectionPane2().getSelectedFactorValues())) + ", formula='" + this.modelEqTextArea.getText() + "', minsplit=" + (Double)this.minSplit.getValue() + ", minbucket=" + (Double)this.minBucket.getValue() + ", cp=" + (Double)this.cp.getValue() + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    @Override
    protected void helpButtonAction() {
        String cmd = "CADStat.help('rpart.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        Object dep = this.dependentComboBox.getSelectedItem();
        int[] indepIndices = this.independentList.getSelectedIndices();
        this.getDatasetPane().refreshDatasetComboBox();
        this.refreshFactorSelectionPanes();
        this.dependentComboBox.setSelectedItem(dep);
        this.independentList.setSelectedIndices(indepIndices);
        this.updateModelEquation();
        this.refreshValidity();
    }
}

