/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.Const;
import blbutil.FileIt;
import blbutil.Filter;
import blbutil.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import vcf.VcfMetaInfo;

public final class VcfHeader {
    private static final String SHORT_HEADER_PREFIX = "#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO";
    public static final String HEADER_PREFIX = "#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT";
    private static final int sampleOffset = 9;
    private final File file;
    private final VcfMetaInfo[] metaInfoLines;
    private final String headerLine;
    private final int nHeaderFields;
    private final int[] includedIndices;
    private final Samples samples;

    public VcfHeader(FileIt<String> fileIt) {
        this(fileIt, Filter.acceptAllFilter());
    }

    public VcfHeader(FileIt<String> fileIt, Filter<String> filter) {
        String[] stringArray;
        if (filter == null) {
            filter = Filter.acceptAllFilter();
        }
        ArrayList<VcfMetaInfo> arrayList = new ArrayList<VcfMetaInfo>(20);
        String[] stringArray2 = null;
        while (fileIt.hasNext() && stringArray2 == null) {
            stringArray = ((String)fileIt.next()).trim();
            if (stringArray.startsWith("##")) {
                arrayList.add(new VcfMetaInfo((String)stringArray));
                continue;
            }
            stringArray2 = stringArray;
        }
        VcfHeader.checkHeaderLine(stringArray2, fileIt.file());
        stringArray = StringUtil.getFields(stringArray2, '\t');
        this.file = fileIt.file();
        this.metaInfoLines = arrayList.toArray(new VcfMetaInfo[0]);
        this.headerLine = stringArray2;
        this.nHeaderFields = stringArray.length;
        this.includedIndices = VcfHeader.includedIndices(stringArray, filter);
        this.samples = this.samples(stringArray, this.includedIndices);
    }

    private static void checkHeaderLine(String string, File file) {
        if (string == null || !string.startsWith("#")) {
            String string2 = "Missing line (#CHROM ...) after meta-information lines" + Const.nl + "File source: " + (file == null ? "stdin" : file) + Const.nl + string;
            throw new IllegalArgumentException(string2);
        }
        if (!string.startsWith(HEADER_PREFIX) && !string.equals(SHORT_HEADER_PREFIX)) {
            String string3 = "Missing header line (file source: " + (file == null ? "stdin" : file) + ")" + Const.nl + "The first line after the initial meta-information lines" + Const.nl + "does not begin with: " + Const.nl + HEADER_PREFIX + Const.nl + string + Const.nl + "The data fields in the header line must be tab-separated.";
            throw new IllegalArgumentException(string3);
        }
    }

    private static int[] includedIndices(String[] stringArray, Filter<String> filter) {
        int n = Math.max(stringArray.length - 9, 0);
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!filter.accept(stringArray[9 + i])) continue;
            nArray[n2++] = i;
        }
        if (n2 < nArray.length) {
            nArray = Arrays.copyOf(nArray, n2);
        }
        return nArray;
    }

    private Samples samples(String[] stringArray, int[] nArray) {
        String[] stringArray2 = new String[nArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[9 + nArray[i]];
        }
        return Samples.fromIds(stringArray2);
    }

    public File file() {
        return this.file;
    }

    public int nMetaInfoLines() {
        return this.metaInfoLines.length;
    }

    public VcfMetaInfo metaInfoLine(int n) {
        return this.metaInfoLines[n];
    }

    public String headerLine() {
        return this.headerLine;
    }

    public int nHeaderFields() {
        return this.nHeaderFields;
    }

    public int nUnfilteredSamples() {
        return Math.max(0, this.nHeaderFields - 9);
    }

    public int unfilteredSampleIndex(int n) {
        return this.includedIndices[n];
    }

    public int nSamples() {
        return this.samples.nSamples();
    }

    public Samples samples() {
        return this.samples;
    }

    public String[] sampleIds() {
        return this.samples.ids();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(400);
        for (int i = 0; i < this.metaInfoLines.length; ++i) {
            stringBuilder.append(this.metaInfoLines[i]);
            stringBuilder.append(Const.nl);
        }
        stringBuilder.append(this.headerLine);
        stringBuilder.append(Const.nl);
        return stringBuilder.toString();
    }
}

