/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.persistence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DerivedAttribute;
import org.vikamine.kernel.data.DerivedNominalAttribute;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.formula.FormulaNumberElement;
import org.vikamine.kernel.persistence.SelectorPersistenceManager;
import org.vikamine.kernel.persistence.ValuesMarshaller;
import org.vikamine.kernel.subgroup.Options;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;
import org.vikamine.kernel.subgroup.target.BooleanFormulaTarget;
import org.vikamine.kernel.subgroup.target.NumericTarget;
import org.vikamine.kernel.subgroup.target.SGTarget;
import org.vikamine.kernel.subgroup.target.SelectorTarget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XMLPersistenceWriter {
    public Document writeXML(File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            Document document = this.writeXML(out);
            return document;
        }
    }

    public Document writeXML(OutputStream out) throws IOException {
        try {
            Document document = this.buildDomTree();
            this.write(out, document);
            return document;
        }
        catch (ParserConfigurationException e) {
            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "writeXML", e);
            IOException ex = new IOException(e.getMessage());
            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "writeXML", ex);
            throw ex;
        }
        catch (TransformerFactoryConfigurationError e) {
            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "writeXML", e);
            IOException ex = new IOException(e.getMessage());
            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "writeXML", ex);
            throw ex;
        }
        catch (TransformerException e) {
            IOException ex = new IOException(e.getMessage());
            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "writeXML", e);
            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "writeXML", ex);
            throw ex;
        }
    }

    protected abstract Document buildDomTree() throws ParserConfigurationException;

    protected abstract void write(OutputStream var1, Document var2) throws TransformerFactoryConfigurationError, TransformerException;

    public Node createInterestingSGSetNode(Document document, List sgList) {
        Element groupsNode = document.createElement("interestingSGs");
        for (SG sg : sgList) {
            groupsNode.appendChild(this.createSGNode(document, sg));
        }
        return groupsNode;
    }

    public Node createBackgroundKnowledgeSGNode(Document document, List sgList) {
        Element groupsNode = document.createElement("backgroundKnowledgeSGs");
        for (SG sg : sgList) {
            groupsNode.appendChild(this.createSGNode(document, sg));
        }
        return groupsNode;
    }

    public Node createSGNode(Document doc, SG sg) {
        Element targetElem;
        Element sgElem = doc.createElement("sg");
        SGTarget target = sg.getTarget();
        if (target == null) {
            targetElem = doc.createElement("target");
            targetElem.setAttribute("type", "emptyTarget");
            sgElem.appendChild(targetElem);
        } else if (target instanceof SelectorTarget) {
            targetElem = doc.createElement("target");
            targetElem.setAttribute("type", "selector");
            targetElem.appendChild(new SelectorPersistenceManager().marshall(((SelectorTarget)target).getSelector(), doc));
            sgElem.appendChild(targetElem);
        } else if (target instanceof BooleanFormulaTarget) {
            targetElem = doc.createElement("target");
            targetElem.setAttribute("type", "booleanFormula");
            targetElem.appendChild(((BooleanFormulaTarget)target).getFormula().createDOMNode(doc));
            sgElem.appendChild(targetElem);
        } else if (target instanceof NumericTarget) {
            targetElem = doc.createElement("target");
            targetElem.setAttribute("type", "numeric");
            targetElem.setAttribute("variable", ((NumericTarget)target).getNumericTargetAttribute().getId());
            sgElem.appendChild(targetElem);
        } else {
            throw new IllegalArgumentException("unknown target: " + target);
        }
        Element descElem = doc.createElement("description");
        for (SGNominalSelector sel : sg.getSGDescription()) {
            descElem.appendChild(new SelectorPersistenceManager().marshall(sel, doc));
        }
        sgElem.appendChild(descElem);
        Element popElem = doc.createElement("population");
        for (SGNominalSelector sGNominalSelector : sg.getPopulation().populationRangesSelectors()) {
            popElem.appendChild(new SelectorPersistenceManager().marshall(sGNominalSelector, doc));
        }
        sgElem.appendChild(popElem);
        return sgElem;
    }

    public Node createCustomFeatureNode(Document document, DerivedAttribute att) {
        Element elem = document.createElement("attribute");
        elem.setAttribute("type", "customFeature");
        elem.setAttribute("id", att.getId());
        elem.setAttribute("description", att.getDescription());
        FormulaNumberElement formula = att.getFormula();
        if (formula != null) {
            elem.appendChild(formula.createDOMNode(document));
        } else if (att instanceof DerivedNominalAttribute) {
            DerivedNominalAttribute dna = (DerivedNominalAttribute)att;
            Iterator<Value> iter = dna.allValuesIterator();
            while (iter.hasNext()) {
                Value alt = iter.next();
                new ValuesMarshaller().createValueNode(document, elem, alt);
            }
        } else {
            throw new IllegalStateException("Unsupported kind of attribute");
        }
        return elem;
    }

    public Element createZoomAttributeNode(Document document, String attributeId, String parentAttributeId) {
        Element child = document.createElement("attribute");
        child.appendChild(document.createTextNode(attributeId));
        if (parentAttributeId != null) {
            child.setAttribute("treeParent", parentAttributeId);
        }
        return child;
    }

    public Node createConstraintNodes(Document document, Options options, Set<Attribute> dmAttributes) {
        Element constraintRoot = document.createElement("options");
        for (Attribute attribute : dmAttributes) {
            Map<Options.Option, Object> optionsMap = options.getAttributeOptions(attribute);
            if (optionsMap == null || optionsMap.isEmpty()) continue;
            for (Map.Entry<Options.Option, Object> entry : optionsMap.entrySet()) {
                Options.Option option = entry.getKey();
                if (!option.equals(Options.TREAT_MISSING_NOT_AS_DEFINED_VALUE)) continue;
                this.createBooleanOptionNode(option, (Boolean)entry.getValue(), attribute, constraintRoot, document);
            }
        }
        return constraintRoot;
    }

    private void createBooleanOptionNode(Options.Option currentOption, Boolean bValue, Attribute attribute, Element constraintRoot, Document document) {
        if (bValue.booleanValue()) {
            Element constraintNode = document.createElement("option");
            constraintNode.setAttribute("id", currentOption.getId());
            constraintNode.setAttribute("attribute", attribute.getId());
            constraintNode.setAttribute("value", bValue.toString());
            constraintRoot.appendChild(constraintNode);
        }
    }
}

