/*
 * Decompiled with CFR 0.152.
 */
package dmLab.gui.dataEditor;

import dmLab.array.Array;
import dmLab.array.SArray;
import dmLab.array.domain.SDomain;
import dmLab.array.functions.DiscFunctions;
import dmLab.array.loader.DB2Array;
import dmLab.array.loader.File2Array;
import dmLab.array.meta.Attribute;
import dmLab.array.saver.Array2File;
import java.sql.ResultSet;
import javax.swing.JProgressBar;
import javax.swing.table.DefaultTableModel;

public final class ContainerOperations {
    public Array container;
    private Array2File cont2file;
    private File2Array file2Cont;
    private DB2Array db2Container;
    private boolean isFileOpen = false;
    private String filePath;
    private JProgressBar progressBar;

    public ContainerOperations() {
        this.initContainer();
        this.cont2file = new Array2File();
        this.file2Cont = new File2Array();
        this.db2Container = new DB2Array();
    }

    public final String getFileName() {
        return this.filePath;
    }

    public final boolean isFileOpen() {
        return this.isFileOpen;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDefaultAttributeNameCSV(String defaultAttributeNameCSV) {
        void var1_1;
        this.file2Cont.defaultAttributeNameCSV = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSeparatorCSV(char separator) {
        void var1_1;
        this.file2Cont.separatorCSV = separator;
        this.cont2file.separatorCSV = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFirstLineContainsAttributesCSV(boolean firstLineContainsAttributesCSV) {
        void var1_1;
        this.file2Cont.firstLineContainsAttributesCSV = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTrimCommentsCSV(boolean trimCommentsCSV) {
        void var1_1;
        this.file2Cont.trimCommentsCSV = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setConsequentSeparatorsTreatAsOneCSV(boolean consequentSeparatorsTreatAsOne) {
        void var1_1;
        this.file2Cont.consequentSeparatorsTreatAsOneCSV = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final DefaultTableModel getTableModel() {
        void var1_1;
        void var2_2;
        Object[][] rows;
        String[] headers;
        if (!this.isFileOpen) {
            headers = new String[]{""};
            rows = new Object[][]{{""}};
        } else {
            int attributesNumber = this.container.colsNumber();
            int eventsNumber = this.container.rowsNumber();
            headers = new String[attributesNumber];
            if (this.progressBar != null) {
                this.progressBar.setMinimum(0);
            }
            if (this.progressBar != null) {
                this.progressBar.setMaximum(attributesNumber);
            }
            int i = 0;
            while (i < attributesNumber) {
                headers[i] = this.container.attributes[i].name;
                ++i;
            }
            rows = new Object[eventsNumber][attributesNumber];
            i = 0;
            while (i < attributesNumber) {
                int j = 0;
                while (j < eventsNumber) {
                    if (this.container.attributes[i].type == 2) {
                        try {
                            Float f = Float.valueOf(Float.parseFloat(this.container.readValueStr(i, j)));
                            rows[j][i] = (float)f.intValue() == f.floatValue() ? (Number)f.intValue() : (Number)f;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    rows[j][i] = this.container.readValueStr(i, j);
                    ++j;
                }
                if (this.progressBar != null) {
                    this.progressBar.setValue(i + 1);
                }
                ++i;
            }
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel((Object[][])var2_2, (Object[])var1_1);
        return defaultTableModel;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean loadFromFile(String path) {
        this.initContainer();
        if (this.file2Cont.load(this.container, path)) {
            void var1_1;
            this.isFileOpen = true;
            this.filePath = var1_1;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean loadFromDB(ResultSet resultSet) {
        void var1_1;
        this.initContainer();
        if (this.db2Container.load(this.container, (ResultSet)var1_1)) {
            this.isFileOpen = true;
            this.filePath = "dbTable";
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean saveToFile(String path) {
        void var1_1;
        return this.cont2file.saveFile(this.container, (String)var1_1);
    }

    public final boolean initContainer() {
        this.container = new SArray();
        this.filePath = "";
        this.isFileOpen = false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final String[][] getAttributesList() {
        void var1_1;
        String[][] list = new String[2][this.container.attributes.length];
        int i = 0;
        while (i < this.container.attributes.length) {
            list[0][i] = this.container.attributes[i].name;
            list[1][i] = Attribute.type2String(this.container.attributes[i].type);
            ++i;
        }
        return var1_1;
    }

    public final SDomain[] getDomains() {
        return ((SArray)this.container).domains;
    }

    /*
     * WARNING - void declaration
     */
    public final void fixAttrTypes() {
        int attributesNumber = this.container.colsNumber();
        if (this.progressBar != null) {
            this.progressBar.setMinimum(0);
        }
        if (this.progressBar != null) {
            this.progressBar.setMaximum(attributesNumber);
        }
        int i = 0;
        while (i < attributesNumber) {
            short newType = ((SArray)this.container).domains[i].fixAttrTypes();
            if (newType != -1) {
                void var3_3;
                this.container.attributes[i].type = var3_3;
            }
            if (this.progressBar != null) {
                this.progressBar.setValue(i + 1);
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void fixAttrValues() {
        void var2_2;
        int attributesNumber = this.container.colsNumber();
        boolean[] mask = new boolean[attributesNumber];
        int i = 0;
        while (i < attributesNumber) {
            mask[i] = this.container.attributes[i].type == 1;
            ++i;
        }
        this.replaceValue(" ", "_", (boolean[])var2_2, false);
    }

    public final int replaceValue(String source, String destination, boolean[] mask, boolean wholeWord) {
        int replacedValues = 0;
        int attributesNumber = this.container.colsNumber();
        int eventsNumber = this.container.rowsNumber();
        if (this.progressBar != null) {
            this.progressBar.setMinimum(0);
        }
        if (this.progressBar != null) {
            this.progressBar.setMaximum(attributesNumber);
        }
        int i = 0;
        while (i < attributesNumber) {
            if (mask[i]) {
                int j = 0;
                while (j < eventsNumber) {
                    String value = this.container.readValueStr(i, j);
                    if (!wholeWord) {
                        String replacedValue = DiscFunctions.replaceAll(value, source, destination);
                        if (!replacedValue.equalsIgnoreCase(value)) {
                            this.container.writeValueStr(i, j, replacedValue);
                            ++replacedValues;
                        }
                    } else if (value.equalsIgnoreCase(source)) {
                        this.container.writeValueStr(i, j, destination);
                        ++replacedValues;
                    }
                    ++j;
                }
            }
            if (this.progressBar != null) {
                this.progressBar.setValue(i + 1);
            }
            ++i;
        }
        return replacedValues;
    }

    public final void findDomains() {
        this.container.findDomains();
    }

    /*
     * WARNING - void declaration
     */
    public final void setProgressBar(JProgressBar progressBar) {
        void var1_1;
        this.progressBar = var1_1;
    }
}

