/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.format.SimpleQuantityFormat;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.function.MixedRadix;
import tech.units.indriya.internal.function.calc.Calculator;
import tech.units.indriya.quantity.Quantities;
import tech.units.indriya.spi.NumberSystem;
import tech.uom.lib.common.function.QuantityConverter;

public class CompoundQuantity<Q extends Quantity<Q>>
implements QuantityConverter<Q>,
Serializable {
    private static final long serialVersionUID = 5863961588282485676L;
    private final List<Quantity<Q>> quantityList;
    private final Object[] quantityArray;
    private final List<Unit<Q>> unitList;
    private Unit<Q> leastSignificantUnit;
    private Quantity.Scale commonScale;
    private MixedRadix<Q> mixedRadixIfPossible;

    protected CompoundQuantity(List<Quantity<Q>> quantities) {
        ArrayList<Unit<Q>> unitList = new ArrayList<Unit<Q>>();
        for (Quantity<Q> q : quantities) {
            Double leastSignificantToCurrentFactor;
            Unit<Q> unit = q.getUnit();
            unitList.add(unit);
            this.commonScale = q.getScale();
            if (this.leastSignificantUnit == null) {
                this.leastSignificantUnit = unit;
                continue;
            }
            NumberSystem ns = Calculus.currentNumberSystem();
            boolean isLessSignificant = ns.isLessThanOne(ns.abs(leastSignificantToCurrentFactor = Double.valueOf(this.leastSignificantUnit.getConverterTo(unit).convert(1.0))));
            if (!isLessSignificant) continue;
            this.leastSignificantUnit = unit;
        }
        this.quantityList = Collections.unmodifiableList(new ArrayList<Quantity<Q>>(quantities));
        this.quantityArray = quantities.toArray();
        this.unitList = Collections.unmodifiableList(unitList);
        try {
            this.mixedRadixIfPossible = MixedRadix.of(this.getUnits());
        }
        catch (Exception e2) {
            this.mixedRadixIfPossible = null;
        }
    }

    @SafeVarargs
    public static <Q extends Quantity<Q>> CompoundQuantity<Q> of(Quantity<Q> ... quantities) {
        CompoundQuantity.guardAgainstIllegalQuantitiesArgument(quantities);
        return new CompoundQuantity<Q>(Arrays.asList(quantities));
    }

    public static <Q extends Quantity<Q>> CompoundQuantity<Q> of(List<Quantity<Q>> quantities) {
        CompoundQuantity.guardAgainstIllegalQuantitiesArgument(quantities);
        return new CompoundQuantity<Q>(quantities);
    }

    public List<Unit<Q>> getUnits() {
        return this.unitList;
    }

    public List<Quantity<Q>> getQuantities() {
        return this.quantityList;
    }

    public String toString() {
        return SimpleQuantityFormat.getInstance().format(this);
    }

    @Override
    public Quantity<Q> to(Unit<Q> unit) {
        if (this.mixedRadixIfPossible != null) {
            Number[] values = this.getQuantities().stream().map(Quantity::getValue).collect(Collectors.toList()).toArray(new Number[0]);
            return this.mixedRadixIfPossible.createQuantity(values).to(unit);
        }
        Calculator calc = Calculator.of(0);
        for (Quantity<Q> q : this.quantityList) {
            Number termInLeastSignificantUnits = q.getUnit().getConverterTo(this.leastSignificantUnit).convert(q.getValue());
            calc.add(termInLeastSignificantUnits);
        }
        Number sumInLeastSignificantUnits = calc.peek();
        return Quantities.getQuantity(sumInLeastSignificantUnits, this.leastSignificantUnit, this.commonScale).to((Unit)unit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CompoundQuantity) {
            CompoundQuantity c2 = (CompoundQuantity)obj;
            return Arrays.equals(this.quantityArray, c2.quantityArray);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.quantityArray);
    }

    private static void guardAgainstIllegalQuantitiesArgument(Quantity<?>[] quantities) {
        if (quantities == null || quantities.length < 1) {
            throw new IllegalArgumentException("At least one quantity is required.");
        }
        Quantity.Scale firstScale = null;
        for (Quantity<?> q : quantities) {
            if (q == null) {
                throw new IllegalArgumentException("Quantities must not contain null.");
            }
            if (firstScale == null && (firstScale = q.getScale()) == null) {
                throw new IllegalArgumentException("Quantities must have a scale.");
            }
            if (firstScale.equals((Object)q.getScale())) continue;
            throw new IllegalArgumentException("Quantities do not have the same scale.");
        }
    }

    private static <Q extends Quantity<Q>> void guardAgainstIllegalQuantitiesArgument(List<Quantity<Q>> quantities) {
        if (quantities == null || quantities.size() < 1) {
            throw new IllegalArgumentException("At least one quantity is required.");
        }
        Quantity.Scale firstScale = null;
        for (Quantity<Q> q : quantities) {
            if (q == null) {
                throw new IllegalArgumentException("Quantities must not contain null.");
            }
            if (firstScale == null && (firstScale = q.getScale()) == null) {
                throw new IllegalArgumentException("Quantities must have a scale.");
            }
            if (firstScale.equals((Object)q.getScale())) continue;
            throw new IllegalArgumentException("Quantities do not have the same scale.");
        }
    }
}

