/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.function.simplify;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.function.ConverterCompositionHandler;
import tech.units.indriya.function.PowerOfIntConverter;
import tech.units.indriya.internal.function.simplify.CompositionTask;

public class UnitCompositionHandlerYieldingNormalForm
implements ConverterCompositionHandler {
    private final Map<Class<? extends AbstractConverter>, Integer> normalFormOrder = Calculus.getNormalFormOrder();

    @Override
    public AbstractConverter compose(AbstractConverter a2, AbstractConverter b2, BiPredicate<AbstractConverter, AbstractConverter> canReduce, BinaryOperator<AbstractConverter> doReduce) {
        if (a2.isIdentity()) {
            if (b2.isIdentity()) {
                return this.isNormalFormOrderWhenIdentity(a2, b2) ? a2 : b2;
            }
            return b2;
        }
        if (b2.isIdentity()) {
            return a2;
        }
        if (canReduce.test(a2, b2)) {
            return (AbstractConverter)doReduce.apply(a2, b2);
        }
        boolean commutative = a2.isLinear() && b2.isLinear();
        boolean swap = commutative && !this.isNormalFormOrderWhenCommutative(a2, b2);
        AbstractConverter.Pair nonSimplifiedForm = swap ? new AbstractConverter.Pair(b2, a2) : new AbstractConverter.Pair(a2, b2);
        return new CompositionTask(this::isNormalFormOrderWhenIdentity, this::isNormalFormOrderWhenCommutative, canReduce, doReduce).reduceToNormalForm(nonSimplifiedForm.getConversionSteps());
    }

    private boolean isNormalFormOrderWhenIdentity(AbstractConverter a2, AbstractConverter b2) {
        if (a2.getClass().equals(b2.getClass())) {
            return true;
        }
        return this.normalFormOrder.get(a2.getClass()) <= this.normalFormOrder.get(b2.getClass());
    }

    private boolean isNormalFormOrderWhenCommutative(AbstractConverter a2, AbstractConverter b2) {
        if (a2.getClass().equals(b2.getClass())) {
            if (a2 instanceof PowerOfIntConverter) {
                return ((PowerOfIntConverter)a2).getBase() <= ((PowerOfIntConverter)b2).getBase();
            }
            return true;
        }
        Integer orderA = Objects.requireNonNull(this.normalFormOrder.get(a2.getClass()), () -> String.format("no normal-form order defined for class '%s'", a2.getClass().getName()));
        Integer orderB = Objects.requireNonNull(this.normalFormOrder.get(b2.getClass()), () -> String.format("no normal-form order defined for class '%s'", b2.getClass().getName()));
        return orderA <= orderB;
    }
}

