/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.function.simplify;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import javax.measure.UnitConverter;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.internal.function.simplify.CompositionTaskArrayAdapter;
import tech.units.indriya.internal.function.simplify.CompositionTaskBitScanner;

final class CompositionTask {
    private final BiPredicate<AbstractConverter, AbstractConverter> isNormalFormOrderWhenIdentity;
    private final BiPredicate<AbstractConverter, AbstractConverter> isNormalFormOrderWhenCommutative;
    private final BiPredicate<AbstractConverter, AbstractConverter> canReduce;
    private final BinaryOperator<AbstractConverter> doReduce;
    private AbstractConverter[] arrayOfConverters;

    CompositionTask(BiPredicate<AbstractConverter, AbstractConverter> isNormalFormOrderWhenIdentity, BiPredicate<AbstractConverter, AbstractConverter> isNormalFormOrderWhenCommutative, BiPredicate<AbstractConverter, AbstractConverter> canReduce, BinaryOperator<AbstractConverter> doReduce) {
        this.isNormalFormOrderWhenIdentity = isNormalFormOrderWhenIdentity;
        this.isNormalFormOrderWhenCommutative = isNormalFormOrderWhenCommutative;
        this.canReduce = canReduce;
        this.doReduce = doReduce;
    }

    public AbstractConverter reduceToNormalForm(List<? extends UnitConverter> conversionSteps) {
        this.arrayOfConverters = conversionSteps.toArray(new AbstractConverter[0]);
        this.sortToNormalFormOrder(this.arrayOfConverters);
        while (this.trySimplify() > 0) {
            this.sortToNormalFormOrder(this.arrayOfConverters);
        }
        return CompositionTask.sequenceToConverter(this.arrayOfConverters);
    }

    private int trySimplify() {
        CompositionTaskArrayAdapter<AbstractConverter> adapter = CompositionTaskArrayAdapter.of(this.arrayOfConverters);
        int simplificationCount = adapter.visitSequentialPairsAndSimplify((a2, b2) -> {
            if (a2.isIdentity()) {
                return b2;
            }
            if (b2.isIdentity()) {
                return a2;
            }
            return this.canReduce.test((AbstractConverter)a2, (AbstractConverter)b2) ? (AbstractConverter)this.doReduce.apply((AbstractConverter)a2, b2) : null;
        });
        if (simplificationCount > 0) {
            this.arrayOfConverters = adapter.removeNulls(simplificationCount);
        }
        return simplificationCount;
    }

    private void sortToNormalFormOrder(AbstractConverter[] arrayOfConverters) {
        CompositionTaskBitScanner bitScanner = CompositionTaskBitScanner.of(arrayOfConverters, UnitConverter::isLinear);
        bitScanner.visitBitSequences((fromIndex, toIndex) -> Arrays.sort(arrayOfConverters, fromIndex, toIndex, (a2, b2) -> {
            if (a2.isIdentity()) {
                if (b2.isIdentity()) {
                    return this.isNormalFormOrderWhenIdentity.test((AbstractConverter)a2, (AbstractConverter)b2) ? -1 : 1;
                }
                return -1;
            }
            if (b2.isIdentity()) {
                return 1;
            }
            return this.isNormalFormOrderWhenCommutative.test((AbstractConverter)a2, (AbstractConverter)b2) ? -1 : 1;
        }));
    }

    private static AbstractConverter sequenceToConverter(AbstractConverter[] sequence) {
        if (sequence == null || sequence.length == 0) {
            return AbstractConverter.IDENTITY;
        }
        if (sequence.length == 1) {
            AbstractConverter singleton = sequence[0];
            return singleton;
        }
        AbstractConverter.Pair start = new AbstractConverter.Pair(sequence[0], sequence[1]);
        return Arrays.stream(sequence).skip(2L).reduce(start, (tree, next) -> new AbstractConverter.Pair((UnitConverter)tree, (UnitConverter)next));
    }
}

