/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.offheapstore.util;

public final class DebuggingUtils {
    private static final String[] BASE_10_SUFFIXES = new String[]{"", "k", "M", "G", "T", "P", "E"};
    private static final String[] BASE_2_SUFFIXES = new String[]{"", "K", "M", "G", "T", "P", "E"};
    private static final long[] BASE_10_DIVISORS = new long[BASE_10_SUFFIXES.length];

    public static String toBase2SuffixedString(long n) {
        if (n > 0L && Long.bitCount(n) == 1) {
            int i = Long.numberOfTrailingZeros(Math.abs(n)) / 10;
            return (n >> i * 10) + BASE_2_SUFFIXES[i];
        }
        int i = (63 - Long.numberOfLeadingZeros(n)) / 10;
        long factor = 1L << i * 10;
        long leading = n / factor;
        long decimalFactor = factor / 10L;
        if (decimalFactor == 0L) {
            return leading + BASE_2_SUFFIXES[i];
        }
        long decimal = (n - leading * factor) / (factor / 10L);
        return leading + "." + decimal + BASE_2_SUFFIXES[i];
    }

    public static String toBase10SuffixedString(long n) {
        for (int i = 0; i < BASE_10_SUFFIXES.length; ++i) {
            long d2 = n / 1000L / BASE_10_DIVISORS[i];
            if (d2 != 0L) continue;
            return n / BASE_10_DIVISORS[i] + BASE_10_SUFFIXES[i];
        }
        throw new AssertionError();
    }

    private DebuggingUtils() {
    }

    static {
        for (int i = 0; i < BASE_10_DIVISORS.length; ++i) {
            long n = 1L;
            for (int j = 0; j < i; ++j) {
                n *= 1000L;
            }
            DebuggingUtils.BASE_10_DIVISORS[i] = n;
        }
    }
}

