/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.knowm.xchart.internal.chartpart.Axis;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.ChartPart;
import org.knowm.xchart.internal.series.AxesChartSeries;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.Styler;

public class AxisTickMarks<ST extends AxesChartStyler, S extends AxesChartSeries>
implements ChartPart {
    private final Chart<ST, S> chart;
    private final Axis.Direction direction;
    private final Axis yAxis;
    private Rectangle2D bounds;

    AxisTickMarks(Chart<ST, S> chart, Axis.Direction direction, Axis yAxis) {
        this.chart = chart;
        this.direction = direction;
        this.yAxis = yAxis;
    }

    @Override
    public void paint(Graphics2D g2) {
        AxesChartStyler styler = (AxesChartStyler)this.chart.getStyler();
        g2.setStroke(styler.getAxisTickMarksStroke());
        if (this.direction == Axis.Direction.Y && styler.isYAxisTicksVisible()) {
            double lineXOffset;
            double xOffset;
            g2.setColor(styler.getYAxisGroupTickMarksColorMap(this.yAxis.getYIndex()));
            int axisTickMarkLength = styler.getAxisTickMarkLength();
            boolean onRight = styler.getYAxisGroupPosistion(this.yAxis.getYIndex()) == Styler.YAxisPosition.Right;
            Rectangle2D yAxisBounds = this.yAxis.getBounds();
            Rectangle2D axisTickLabelBounds = this.yAxis.getAxisTick().getAxisTickLabels().getBounds();
            if (onRight) {
                lineXOffset = xOffset = axisTickLabelBounds.getX() - (double)styler.getAxisTickPadding() - (double)axisTickMarkLength;
            } else {
                xOffset = axisTickLabelBounds.getX() + axisTickLabelBounds.getWidth() + (double)styler.getAxisTickPadding();
                lineXOffset = xOffset + (double)axisTickMarkLength;
            }
            double yOffset = yAxisBounds.getY();
            this.bounds = new Rectangle2D.Double(xOffset, yOffset, ((AxesChartStyler)this.chart.getStyler()).getAxisTickMarkLength(), this.yAxis.getBounds().getHeight());
            if (styler.isAxisTicksMarksVisible()) {
                for (int i = 0; i < this.yAxis.getAxisTickCalculator().getTickLabels().size(); ++i) {
                    double tickLocation = this.yAxis.getAxisTickCalculator().getTickLocations().get(i);
                    double flippedTickLocation = yOffset + yAxisBounds.getHeight() - tickLocation;
                    if (!(flippedTickLocation > this.bounds.getY()) || !(flippedTickLocation < this.bounds.getY() + this.bounds.getHeight())) continue;
                    Line2D.Double line = new Line2D.Double(xOffset, flippedTickLocation, xOffset + (double)axisTickMarkLength, flippedTickLocation);
                    g2.draw(line);
                }
            }
            if (styler.isAxisTicksLineVisible()) {
                Line2D.Double line = new Line2D.Double(lineXOffset, yOffset, lineXOffset, yOffset + yAxisBounds.getHeight());
                g2.draw(line);
            }
        } else if (this.direction == Axis.Direction.X && styler.isXAxisTicksVisible()) {
            g2.setColor(styler.getXAxisTickMarksColor());
            int axisTickMarkLength = styler.getAxisTickMarkLength();
            double xOffset = this.chart.getXAxis().getBounds().getX();
            double yOffset = this.chart.getXAxis().getAxisTick().getAxisTickLabels().getBounds().getY() - (double)styler.getAxisTickPadding();
            this.bounds = new Rectangle2D.Double(xOffset, yOffset - (double)axisTickMarkLength, this.chart.getXAxis().getBounds().getWidth(), axisTickMarkLength);
            if (styler.isAxisTicksMarksVisible()) {
                for (int i = 0; i < this.chart.getXAxis().getAxisTickCalculator().getTickLabels().size(); ++i) {
                    double tickLocation = this.chart.getXAxis().getAxisTickCalculator().getTickLocations().get(i);
                    double shiftedTickLocation = xOffset + tickLocation;
                    if (!(shiftedTickLocation > this.bounds.getX()) || !(shiftedTickLocation < this.bounds.getX() + this.bounds.getWidth())) continue;
                    Line2D.Double line = new Line2D.Double(shiftedTickLocation, yOffset, xOffset + tickLocation, yOffset - (double)axisTickMarkLength);
                    g2.draw(line);
                }
            }
            if (styler.isAxisTicksLineVisible()) {
                g2.setStroke(styler.getAxisTickMarksStroke());
                g2.drawLine((int)xOffset, (int)(yOffset - (double)axisTickMarkLength), (int)(xOffset + this.chart.getXAxis().getBounds().getWidth()), (int)(yOffset - (double)axisTickMarkLength));
            }
        } else {
            this.bounds = new Rectangle2D.Double();
        }
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }
}

