/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.knowm.xchart.internal.chartpart.Annotation;
import org.knowm.xchart.internal.chartpart.Chart;

public class AnnotationTextPanel
extends Annotation {
    private static final int MULTI_LINE_SPACE = 3;
    private List<String> lines;
    protected double x;
    protected double y;

    public AnnotationTextPanel(String lines, double x, double y, boolean isValueInScreenSpace) {
        super(isValueInScreenSpace);
        this.lines = Arrays.asList(lines.split("\\n"));
        this.x = x;
        this.y = y;
    }

    @Override
    public void init(Chart chart) {
        super.init(chart);
    }

    @Override
    public void paint(Graphics2D g2) {
        double yOffset;
        double xOffset;
        if (!this.isVisible) {
            return;
        }
        double contentMaxWidth = 0.0;
        double contentHeight = 0.0;
        Map<String, Rectangle2D> textBounds = this.getTextBounds(this.lines);
        double entryHeight = 0.0;
        for (Map.Entry<String, Rectangle2D> entry : textBounds.entrySet()) {
            entryHeight += entry.getValue().getHeight() + 3.0;
            contentMaxWidth = Math.max(contentMaxWidth, entry.getValue().getWidth());
        }
        double contentWidth = (double)this.styler.getAnnotationTextPanelPadding() + contentMaxWidth;
        double width = contentWidth + (double)(2 * this.styler.getAnnotationTextPanelPadding());
        double height = (contentHeight += (entryHeight -= 3.0)) + (double)(2 * this.styler.getAnnotationTextPanelPadding());
        if (this.isValueInScreenSpace) {
            xOffset = this.x;
            yOffset = (double)this.chart.getHeight() - height - this.y - 1.0;
        } else {
            xOffset = this.getXAxisScreenValue(this.x);
            yOffset = (double)this.getYAxisScreenValue(this.y) - height - 1.0;
        }
        xOffset = Math.min(xOffset, (double)this.chart.getWidth() - width - 1.0);
        yOffset = Math.max(yOffset, 1.0);
        this.bounds = new Rectangle2D.Double(xOffset, yOffset, width, height);
        Rectangle2D.Double rect = new Rectangle2D.Double(xOffset, yOffset, width, height);
        g2.setColor(this.styler.getAnnotationTextPanelBackgroundColor());
        g2.fill(rect);
        g2.setStroke(SOLID_STROKE);
        g2.setColor(this.styler.getAnnotationTextPanelBorderColor());
        g2.draw(rect);
        Object oldHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.styler.getAnnotationTextPanelFontColor());
        g2.setFont(this.styler.getAnnotationTextPanelFont());
        xOffset += (double)this.styler.getAnnotationTextPanelPadding();
        yOffset += (double)this.styler.getAnnotationTextPanelPadding();
        double multiLineOffset = 0.0;
        for (Map.Entry<String, Rectangle2D> entry : textBounds.entrySet()) {
            double lineHeight = entry.getValue().getHeight();
            FontRenderContext frc = g2.getFontRenderContext();
            TextLayout tl = new TextLayout(entry.getKey(), this.styler.getAnnotationTextPanelFont(), frc);
            Shape shape = tl.getOutline(null);
            AffineTransform orig = g2.getTransform();
            AffineTransform at = new AffineTransform();
            at.translate(xOffset, yOffset + lineHeight + multiLineOffset);
            g2.transform(at);
            g2.fill(shape);
            g2.setTransform(orig);
            multiLineOffset += lineHeight + 3.0;
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    private Map<String, Rectangle2D> getTextBounds(List<String> lines) {
        Font infoPanelFont = this.styler.getAnnotationTextPanelFont();
        LinkedHashMap<String, Rectangle2D> textBounds = new LinkedHashMap<String, Rectangle2D>(lines.size());
        for (String line : lines) {
            TextLayout textLayout = new TextLayout(line, infoPanelFont, new FontRenderContext(null, true, false));
            Shape shape = textLayout.getOutline(null);
            Rectangle2D bounds = shape.getBounds2D();
            textBounds.put(line, bounds);
        }
        return textBounds;
    }

    public void setLines(List<String> lines) {
        this.lines = lines;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }
}

