/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.knowm.xchart.internal.chartpart.Annotation;

public class AnnotationText
extends Annotation {
    private String text;
    protected double x;
    protected double y;

    public AnnotationText(String text, double x, double y, boolean isValueInScreenSpace) {
        super(isValueInScreenSpace);
        this.text = text;
        this.x = x;
        this.y = y;
    }

    @Override
    public void paint(Graphics2D g2) {
        double yOffset;
        double xOffset;
        if (!this.isVisible) {
            return;
        }
        Object oldHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.styler.getAnnotationTextFontColor());
        g2.setFont(this.styler.getAnnotationTextFont());
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout tl = new TextLayout(this.text, this.styler.getAnnotationTextFont(), frc);
        Shape shape = tl.getOutline(null);
        Rectangle2D textBounds = shape.getBounds2D();
        if (this.isValueInScreenSpace) {
            xOffset = this.x - textBounds.getWidth() / 2.0;
            yOffset = (double)this.chart.getHeight() - this.y + textBounds.getHeight() / 2.0;
        } else {
            xOffset = (double)this.getXAxisScreenValue(this.x) - textBounds.getWidth() / 2.0;
            yOffset = (double)this.getYAxisScreenValue(this.y) + textBounds.getHeight() / 2.0;
        }
        AffineTransform orig = g2.getTransform();
        AffineTransform at = new AffineTransform();
        at.translate(xOffset, yOffset);
        g2.transform(at);
        g2.fill(shape);
        g2.setTransform(orig);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
        this.bounds = new Rectangle2D.Double(xOffset, yOffset, textBounds.getWidth(), textBounds.getHeight());
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }
}

