/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.spanning;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.SpanningTreeAlgorithm;
import org.jgrapht.alg.util.ToleranceDoubleComparator;
import org.jgrapht.alg.util.UnionFind;

public class BoruvkaMinimumSpanningTree<V, E>
implements SpanningTreeAlgorithm<E> {
    private final Graph<V, E> graph;
    private final Comparator<Double> comparator;

    public BoruvkaMinimumSpanningTree(Graph<V, E> graph) {
        this.graph = Objects.requireNonNull(graph, "Graph cannot be null");
        this.comparator = new ToleranceDoubleComparator();
    }

    @Override
    public SpanningTreeAlgorithm.SpanningTree<E> getSpanningTree() {
        LinkedHashSet mstEdges = new LinkedHashSet();
        double mstWeight = 0.0;
        HashMap<E, Integer> edgeOrder = new HashMap<E, Integer>();
        int i = 0;
        for (E e2 : this.graph.edgeSet()) {
            edgeOrder.put(e2, i++);
        }
        UnionFind<V> forest = new UnionFind<V>(this.graph.vertexSet());
        LinkedHashMap<V, E> bestEdge = new LinkedHashMap<V, E>();
        do {
            bestEdge.clear();
            for (E e3 : this.graph.edgeSet()) {
                V tTree;
                V sTree = forest.find(this.graph.getEdgeSource(e3));
                if (sTree.equals(tTree = forest.find(this.graph.getEdgeTarget(e3)))) continue;
                double eWeight = this.graph.getEdgeWeight(e3);
                Object sTreeEdge = bestEdge.get(sTree);
                if (sTreeEdge == null) {
                    bestEdge.put(sTree, e3);
                } else {
                    double sTreeEdgeWeight = this.graph.getEdgeWeight(sTreeEdge);
                    int c2 = this.comparator.compare(eWeight, sTreeEdgeWeight);
                    if (c2 < 0 || c2 == 0 && (Integer)edgeOrder.get(e3) < (Integer)edgeOrder.get(sTreeEdge)) {
                        bestEdge.put(sTree, e3);
                    }
                }
                Object tTreeEdge = bestEdge.get(tTree);
                if (tTreeEdge == null) {
                    bestEdge.put(tTree, e3);
                    continue;
                }
                double tTreeEdgeWeight = this.graph.getEdgeWeight(tTreeEdge);
                int c3 = this.comparator.compare(eWeight, tTreeEdgeWeight);
                if (c3 >= 0 && (c3 != 0 || (Integer)edgeOrder.get(e3) >= (Integer)edgeOrder.get(tTreeEdge))) continue;
                bestEdge.put(tTree, e3);
            }
            for (Object v : bestEdge.keySet()) {
                V tTree;
                Object e4 = bestEdge.get(v);
                V sTree = forest.find(this.graph.getEdgeSource(e4));
                if (sTree.equals(tTree = forest.find(this.graph.getEdgeTarget(e4)))) continue;
                mstEdges.add(e4);
                mstWeight += this.graph.getEdgeWeight(e4);
                forest.union(sTree, tTree);
            }
        } while (!bestEdge.isEmpty());
        return new SpanningTreeAlgorithm.SpanningTreeImpl(mstEdges, mstWeight);
    }
}

