/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.numeric;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaitools.CollectionFactory;
import org.jaitools.numeric.Processor;
import org.jaitools.numeric.ProcessorFactory;
import org.jaitools.numeric.Range;
import org.jaitools.numeric.Statistic;

public class StreamingSampleStats {
    private static final Logger LOGGER = Logger.getLogger("org.jaitools.numeric");
    private ProcessorFactory factory = new ProcessorFactory();
    private List<Processor> processors = CollectionFactory.list();
    private List<Range<Double>> ranges = CollectionFactory.list();
    private List<Range<Double>> noDataRanges = CollectionFactory.list();
    private final Range.Type rangesType;

    public StreamingSampleStats() {
        this(Range.Type.EXCLUDE);
    }

    public StreamingSampleStats(Range.Type rangesType) {
        this.rangesType = rangesType;
    }

    public void setStatistic(Statistic stat) {
        Processor p = this.findProcessor(stat);
        if (p == null) {
            p = this.factory.getForStatistic(stat);
            if (p == null) {
                LOGGER.log(Level.SEVERE, "Unsupported Statistic: {0}", (Object)stat);
            } else {
                this.processors.add(p);
                for (Range<Double> range : this.ranges) {
                    p.addRange(range, this.rangesType);
                }
                for (Range<Double> nRange : this.noDataRanges) {
                    p.addNoDataRange(nRange);
                }
            }
        }
    }

    public void setStatistics(Statistic[] stats) {
        for (Statistic stat : stats) {
            this.setStatistic(stat);
        }
    }

    public boolean isSet(Statistic stat) {
        return this.findProcessor(stat) != null;
    }

    public void addNoDataRange(Range<Double> noData) {
        this.noDataRanges.add(new Range<Double>(noData));
        for (Processor p : this.processors) {
            p.addNoDataRange(noData);
        }
    }

    public void addNoDataValue(Double noData) {
        if (noData != null && !noData.isNaN()) {
            this.addNoDataRange(new Range<Double>(noData, new int[0]));
        }
    }

    public void addRange(Range<Double> range) {
        this.ranges.add(new Range<Double>(range));
        for (Processor p : this.processors) {
            p.addRange(range);
        }
    }

    public void addRange(Range<Double> range, Range.Type rangesType) {
        for (Processor p : this.processors) {
            p.addRange(range, rangesType);
        }
        this.ranges.add(new Range<Double>(range));
    }

    public Set<Statistic> getStatistics() {
        Set<Statistic> stats = CollectionFactory.orderedSet();
        for (Processor p : this.processors) {
            for (Statistic s2 : p.getSupported()) {
                stats.add(s2);
            }
        }
        return stats;
    }

    public Double getStatisticValue(Statistic stat) {
        Processor p = this.findProcessor(stat);
        if (p == null) {
            throw new IllegalStateException("requesting a result for a statistic that hasn't been set: " + (Object)((Object)stat));
        }
        return p.get(stat);
    }

    public long getNumAccepted(Statistic stat) {
        Processor p = this.findProcessor(stat);
        if (p == null) {
            throw new IllegalArgumentException("requesting sample size for a statistic that is not set: " + (Object)((Object)stat));
        }
        return p.getNumAccepted();
    }

    public long getNumOffered(Statistic stat) {
        Processor p = this.findProcessor(stat);
        if (p == null) {
            throw new IllegalArgumentException("requesting sample size for a statistic that is not set: " + (Object)((Object)stat));
        }
        return p.getNumOffered();
    }

    public long getNumNaN(Statistic stat) {
        Processor p = this.findProcessor(stat);
        if (p == null) {
            throw new IllegalArgumentException("requesting sample size for a statistic that is not set: " + (Object)((Object)stat));
        }
        return p.getNumNaN();
    }

    public long getNumNoData(Statistic stat) {
        Processor p = this.findProcessor(stat);
        if (p == null) {
            throw new IllegalArgumentException("requesting sample size for a statistic that is not set: " + (Object)((Object)stat));
        }
        return p.getNumNoData();
    }

    public void offer(Double sample) {
        for (Processor p : this.processors) {
            p.offer(sample);
        }
    }

    public void offer(Double[] samples) {
        for (int i = 0; i < samples.length; ++i) {
            this.offer(samples[i]);
        }
    }

    private Processor findProcessor(Statistic stat) {
        for (Processor p : this.processors) {
            if (!p.getSupported().contains((Object)stat)) continue;
            return p;
        }
        return null;
    }

    public Map<Statistic, Double> getStatisticValues() {
        Map<Statistic, Double> results = CollectionFactory.orderedMap();
        for (Statistic s2 : this.getStatistics()) {
            results.put(s2, this.getStatisticValue(s2));
        }
        return results;
    }
}

