/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.numeric;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jaitools.numeric.AbstractProcessor;
import org.jaitools.numeric.Statistic;

public class MeanVarianceProcessor
extends AbstractProcessor {
    private static final Set<Statistic> SUPPORTED = new HashSet<Statistic>();
    private double mOld;
    private double mNew;
    private double s;

    @Override
    public Collection<Statistic> getSupported() {
        return Collections.unmodifiableCollection(SUPPORTED);
    }

    @Override
    protected boolean update(Double sample) {
        if (this.isAccepted(sample)) {
            if (this.getNumAccepted() == 0L) {
                this.mOld = this.mNew = sample.doubleValue();
                this.s = 0.0;
            } else {
                this.mNew = this.mOld + (sample - this.mOld) / (double)(this.getNumAccepted() + 1L);
                this.s += (sample - this.mOld) * (sample - this.mNew);
                this.mOld = this.mNew;
            }
            return true;
        }
        return false;
    }

    @Override
    public Double get(Statistic stat) {
        if (this.getNumAccepted() == 0L) {
            return Double.NaN;
        }
        long n = this.getNumAccepted();
        switch (stat) {
            case MEAN: {
                if (n <= 0L) break;
                return this.mNew;
            }
            case SDEV: {
                if (n <= 1L) break;
                return Math.sqrt(this.s / (double)(n - 1L));
            }
            case VARIANCE: {
                if (n <= 1L) break;
                return this.s / (double)(n - 1L);
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)stat) + " not supported by " + this.getClass().getName());
            }
        }
        return Double.NaN;
    }

    static {
        SUPPORTED.add(Statistic.MEAN);
        SUPPORTED.add(Statistic.SDEV);
        SUPPORTED.add(Statistic.VARIANCE);
    }
}

