/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.imageutils.iterator;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import org.jaitools.imageutils.iterator.AbstractSimpleIterator;
import org.jaitools.imageutils.iterator.SimpleIterator;

public class WindowIterator {
    private static final Number DEFAULT_OUTSIDE_VALUE = 0;
    private final Dimension windowDim;
    private final int leftPadding;
    private final int rightPadding;
    private final int topPadding;
    private final int bottomPadding;
    private final Number[][][] buffers;
    private final Number[][] destBuffer;
    private final int bufferWidth;
    private final Rectangle iterBounds;
    private final int numImageBands;
    private final int xstep;
    private final int ystep;
    private final Point mainPos;
    private final Point lowerRightPos;
    private final SimpleIterator delegate;
    private Number outsideValue;

    public WindowIterator(RenderedImage image, Rectangle bounds, Dimension windowDim, Point keyElement) {
        this(image, bounds, windowDim, keyElement, DEFAULT_OUTSIDE_VALUE);
    }

    public WindowIterator(RenderedImage image, Rectangle bounds, Dimension windowDim, Point keyElement, Number outsideValue) {
        this(image, bounds, windowDim, keyElement, 1, 1, outsideValue);
    }

    public WindowIterator(RenderedImage image, Rectangle bounds, Dimension windowDim, Point keyElement, int xstep, int ystep, Number outsideValue) {
        int b2;
        if (image == null) {
            throw new IllegalArgumentException("image must not be null");
        }
        if (windowDim == null) {
            throw new IllegalArgumentException("windowDim must not be null");
        }
        if (keyElement == null) {
            throw new IllegalArgumentException("keyElement must not be null");
        }
        if (keyElement.x < 0 || keyElement.x >= windowDim.width || keyElement.y < 0 || keyElement.y >= windowDim.height) {
            throw new IllegalArgumentException(String.format("The supplied key element position (%d, %d) is invalid fordata window dimensions: width=%d height=%d", keyElement.x, keyElement.y, windowDim.width, windowDim.height));
        }
        if (xstep < 1 || ystep < 1) {
            throw new IllegalArgumentException("The value of both xstep and ystep must be 1 or greater");
        }
        if (outsideValue == null) {
            throw new IllegalArgumentException("outsideValue must not be null");
        }
        this.iterBounds = bounds == null ? new Rectangle(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight()) : new Rectangle(bounds);
        this.leftPadding = keyElement.x;
        this.rightPadding = windowDim.width - keyElement.x - 1;
        this.topPadding = keyElement.y;
        this.bottomPadding = windowDim.height - keyElement.y - 1;
        Rectangle delegateBounds = new Rectangle(this.iterBounds.x - this.leftPadding, this.iterBounds.y - this.topPadding, this.iterBounds.width + this.leftPadding + this.rightPadding, this.iterBounds.height + this.topPadding + this.bottomPadding);
        this.delegate = new SimpleIterator(image, delegateBounds, outsideValue, AbstractSimpleIterator.Order.IMAGE_X_Y);
        this.windowDim = new Dimension(windowDim);
        this.outsideValue = outsideValue;
        this.numImageBands = image.getSampleModel().getNumBands();
        this.bufferWidth = this.iterBounds.width + this.leftPadding + this.rightPadding;
        this.buffers = new Number[this.numImageBands][][];
        for (b2 = 0; b2 < this.numImageBands; ++b2) {
            Number[][] bandBuffer = new Number[windowDim.height][];
            for (int i = 0; i < windowDim.height; ++i) {
                Object[] ar = new Number[this.bufferWidth];
                Arrays.fill(ar, this.outsideValue);
                bandBuffer[i] = ar;
            }
            this.buffers[b2] = bandBuffer;
        }
        this.destBuffer = new Number[this.numImageBands][];
        for (b2 = 0; b2 < this.numImageBands; ++b2) {
            this.destBuffer[b2] = new Number[windowDim.width * windowDim.height];
        }
        this.xstep = xstep;
        this.ystep = ystep;
        this.readData(0);
        this.mainPos = new Point(this.iterBounds.x, this.iterBounds.y);
        this.lowerRightPos = new Point(this.iterBounds.x + this.iterBounds.width - 1, this.iterBounds.y + this.iterBounds.height - 1);
    }

    public Point getPos() {
        return new Point(this.mainPos);
    }

    public boolean hasNext() {
        return this.mainPos.x + this.xstep <= this.lowerRightPos.x || this.mainPos.y + this.ystep <= this.lowerRightPos.y;
    }

    public boolean next() {
        if (this.hasNext()) {
            this.mainPos.x += this.xstep;
            if (this.mainPos.x > this.lowerRightPos.x) {
                this.mainPos.x = this.iterBounds.x;
                this.mainPos.y += this.ystep;
                this.readNextData();
            }
            return true;
        }
        return false;
    }

    public Number[][] getWindow(Number[][] dest) {
        return this.getWindow(dest, 0);
    }

    public Number[][] getWindow(Number[][] dest, int band) {
        this.checkBandArg(band);
        if (dest == null || dest.length != this.windowDim.height || dest[0].length != this.windowDim.width) {
            dest = new Number[this.windowDim.height][this.windowDim.width];
        }
        this.loadDestBuffer(band);
        int k = 0;
        for (int y = 0; y < this.windowDim.height; ++y) {
            for (int x = 0; x < this.windowDim.width; ++x) {
                dest[y][x] = this.destBuffer[band][k++];
            }
        }
        return dest;
    }

    public int[][] getWindowInt(int[][] dest) {
        return this.getWindowInt(dest, 0);
    }

    public int[][] getWindowInt(int[][] dest, int band) {
        this.checkBandArg(band);
        if (dest == null || dest.length != this.windowDim.height || dest[0].length != this.windowDim.width) {
            dest = new int[this.windowDim.height][this.windowDim.width];
        }
        this.loadDestBuffer(band);
        int k = 0;
        for (int y = 0; y < this.windowDim.height; ++y) {
            for (int x = 0; x < this.windowDim.width; ++x) {
                dest[y][x] = this.destBuffer[band][k++].intValue();
            }
        }
        return dest;
    }

    public float[][] getWindowFloat(float[][] dest) {
        return this.getWindowFloat(dest, 0);
    }

    public float[][] getWindowFloat(float[][] dest, int band) {
        this.checkBandArg(band);
        if (dest == null || dest.length != this.windowDim.height || dest[0].length != this.windowDim.width) {
            dest = new float[this.windowDim.height][this.windowDim.width];
        }
        this.loadDestBuffer(band);
        int k = 0;
        for (int y = 0; y < this.windowDim.height; ++y) {
            for (int x = 0; x < this.windowDim.width; ++x) {
                dest[y][x] = this.destBuffer[band][k++].floatValue();
            }
        }
        return dest;
    }

    public double[][] getWindowDouble(double[][] dest) {
        return this.getWindowDouble(dest, 0);
    }

    public double[][] getWindowDouble(double[][] dest, int band) {
        this.checkBandArg(band);
        if (dest == null || dest.length != this.windowDim.height || dest[0].length != this.windowDim.width) {
            dest = new double[this.windowDim.height][this.windowDim.width];
        }
        this.loadDestBuffer(band);
        int k = 0;
        for (int y = 0; y < this.windowDim.height; ++y) {
            for (int x = 0; x < this.windowDim.width; ++x) {
                dest[y][x] = this.destBuffer[band][k++].doubleValue();
            }
        }
        return dest;
    }

    private void loadDestBuffer(int band) {
        int minx = this.mainPos.x - this.iterBounds.x;
        int bufx = minx + this.leftPadding;
        int maxx = bufx + this.rightPadding;
        int k = 0;
        for (int y = 0; y < this.windowDim.height; ++y) {
            int x = minx;
            int winX = 0;
            while (x <= maxx) {
                this.destBuffer[band][k++] = this.buffers[band][y][x];
                ++x;
                ++winX;
            }
        }
    }

    private void readNextData() {
        this.moveLinesUp();
        this.skipImageLines();
        int topBufferLine = Math.max(this.windowDim.height - this.ystep, 0);
        this.readData(topBufferLine);
    }

    private void readData(int topBufferLine) {
        for (int line = topBufferLine; line < this.windowDim.height; ++line) {
            for (int x = 0; x < this.bufferWidth; ++x) {
                for (int b2 = 0; b2 < this.numImageBands; ++b2) {
                    this.buffers[b2][line][x] = this.delegate.getSample(b2);
                }
                this.delegate.next();
            }
        }
    }

    private void skipImageLines() {
        int nlines = this.ystep - this.windowDim.height;
        if (nlines > 0) {
            Point pos = this.delegate.getPos();
            this.delegate.setPos(pos.x, pos.y + nlines);
        }
    }

    private void moveLinesUp() {
        for (int b2 = 0; b2 < this.numImageBands; ++b2) {
            int y;
            if (this.ystep >= this.windowDim.height) {
                for (y = 0; y < this.windowDim.height; ++y) {
                    Arrays.fill(this.buffers[b2][y], this.outsideValue);
                }
                continue;
            }
            y = this.ystep;
            int ynew = 0;
            while (y < this.windowDim.height) {
                Object[] temp = this.buffers[b2][ynew];
                this.buffers[b2][ynew] = this.buffers[b2][y];
                Arrays.fill(temp, this.outsideValue);
                this.buffers[b2][y] = temp;
                ++y;
                ++ynew;
            }
        }
    }

    private void checkBandArg(int band) {
        if (band < 0 || band >= this.numImageBands) {
            throw new IllegalArgumentException(String.format("band argument (%d) is out of range: number of image bands is %d", band, this.numImageBands));
        }
    }
}

