/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import org.geotools.referencing.operation.transform.AffineTransform2D;

public class AffineToGeometric {
    private double tx;
    private double ty;
    private double sx;
    private double sy;
    private double phix;
    private double phiy;
    private double sxy;

    public AffineToGeometric(AffineTransform2D trans) {
        this.sx = Math.pow(Math.pow(trans.getShearY(), 2.0) + Math.pow(trans.getScaleX(), 2.0), 0.5);
        this.sy = Math.pow(Math.pow(trans.getScaleY(), 2.0) + Math.pow(trans.getShearX(), 2.0), 0.5);
        this.phix = Math.acos(Math.signum(trans.getShearY()) * trans.getScaleX() / this.sx);
        this.phiy = Math.acos(Math.signum(-trans.getShearX()) * trans.getScaleY() / this.sy);
        this.sxy = this.phix - this.phiy;
        this.tx = trans.getTranslateX();
        this.ty = trans.getTranslateY();
    }

    public double getXScale() {
        return this.sx;
    }

    public double getYScale() {
        return this.sy;
    }

    public double getSkew() {
        return this.sxy;
    }

    public double getXTranslate() {
        return this.tx;
    }

    public double getYTranslate() {
        return this.ty;
    }

    public double getXRotation() {
        return this.phix;
    }

    public double getYRotation() {
        return this.phiy;
    }
}

