/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurve;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.MultiCurve;
import org.geotools.geometry.jts.MultiCurvedGeometry;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeometryTypeConverterFactory
implements ConverterFactory {
    private static final Logger LOGGER = Logging.getLogger(GeometryTypeConverterFactory.class);
    static GeometryFactory gFac = new GeometryFactory();

    @Override
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (Geometry.class.isAssignableFrom(source) && CurvedGeometry.class.isAssignableFrom(target)) {
            return new Converter(){

                @Override
                public <T> T convert(Object source, Class<T> target) throws Exception {
                    Geometry result = null;
                    Geometry sourceGeometry = (Geometry)source;
                    if (MultiCurvedGeometry.class.isAssignableFrom(target)) {
                        MultiLineString multiLineString = Converters.convert(source, MultiLineString.class);
                        if (multiLineString == null) {
                            return null;
                        }
                        ArrayList<LineString> components = new ArrayList<LineString>();
                        double tolerance = Double.MAX_VALUE;
                        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
                            LineString geom = (LineString)multiLineString.getGeometryN(0);
                            if (geom instanceof CurvedGeometry) {
                                tolerance = Math.min(tolerance, ((CurvedGeometry)((Object)geom)).getTolerance());
                            }
                            components.add(geom);
                        }
                        GeometryFactory factory = ((Geometry)source).getFactory();
                        result = new MultiCurve(components, factory, tolerance);
                    } else if (source instanceof CircularRing && CircularString.class.isAssignableFrom(target)) {
                        CircularRing cr = (CircularRing)source;
                        result = new CircularString(cr.getControlPoints(), cr.getFactory(), cr.getTolerance());
                    } else if (source instanceof CompoundRing && CompoundCurve.class.isAssignableFrom(target)) {
                        CompoundRing cr = (CompoundRing)source;
                        result = new CompoundCurve(cr.getComponents(), cr.getFactory(), cr.getTolerance());
                    } else {
                        LineString converted = Converters.convert(source, LineString.class);
                        if (converted.isEmpty()) {
                            ArrayList<LineString> components = new ArrayList<LineString>();
                            result = new CompoundRing(components, converted.getFactory(), Double.MAX_VALUE);
                        } else {
                            result = converted instanceof LinearRing ? new CompoundRing(Arrays.asList(converted), ((LineString)source).getFactory(), Double.MAX_VALUE) : new CompoundCurve(Arrays.asList(converted), converted.getFactory(), Double.MAX_VALUE);
                        }
                    }
                    if (result != null) {
                        GeometryTypeConverterFactory.this.copyUserProperties(sourceGeometry, result);
                    }
                    return (T)result;
                }
            };
        }
        if (Geometry.class.isAssignableFrom(source) && Geometry.class.isAssignableFrom(target)) {
            return new Converter(){

                public <T> List<T> convertAll(GeometryCollection gc, Class<T> target) throws Exception {
                    ArrayList<Object> result = new ArrayList<Object>();
                    for (int count = 0; count < gc.getNumGeometries(); ++count) {
                        Object geo = this.convert((Object)gc.getGeometryN(count), (Class)target);
                        if (geo == null) continue;
                        result.add(geo);
                    }
                    return result;
                }

                public Object convert(Object source, Class target) throws Exception {
                    if (target.isAssignableFrom(source.getClass())) {
                        return source;
                    }
                    if (source instanceof Geometry) {
                        Geometry sourceGeometry = (Geometry)source;
                        Geometry destGeometry = null;
                        if (MultiPoint.class.isAssignableFrom(target)) {
                            Point[] points = sourceGeometry.isEmpty() ? new Point[]{} : (source instanceof Point ? new Point[]{(Point)source} : (source instanceof GeometryCollection ? this.convertAll((GeometryCollection)source, Point.class).toArray(new Point[0]) : new Point[]{(Point)this.convert(source, Point.class)}));
                            destGeometry = gFac.createMultiPoint(points);
                        } else if (MultiLineString.class.isAssignableFrom(target)) {
                            LineString[] lineStrings = sourceGeometry.isEmpty() ? new LineString[]{} : (source instanceof LineString ? new LineString[]{(LineString)source} : (source instanceof GeometryCollection ? this.convertAll((GeometryCollection)source, LineString.class).toArray(new LineString[0]) : new LineString[]{(LineString)this.convert(source, LineString.class)}));
                            destGeometry = gFac.createMultiLineString(lineStrings);
                        } else if (MultiPolygon.class.isAssignableFrom(target)) {
                            Polygon[] polygons = sourceGeometry.isEmpty() ? new Polygon[]{} : (source instanceof Polygon ? new Polygon[]{(Polygon)source} : (source instanceof GeometryCollection ? this.convertAll((GeometryCollection)source, Polygon.class).toArray(new Polygon[0]) : new Polygon[]{(Polygon)this.convert(source, Polygon.class)}));
                            destGeometry = gFac.createMultiPolygon(polygons);
                        } else if (GeometryCollection.class.isAssignableFrom(target)) {
                            destGeometry = sourceGeometry.isEmpty() ? gFac.createGeometryCollection(new Geometry[0]) : gFac.createGeometryCollection(new Geometry[]{(Geometry)source});
                        } else if (Point.class.isAssignableFrom(target)) {
                            if (sourceGeometry.isEmpty()) {
                                destGeometry = gFac.createPoint((Coordinate)null);
                            } else if (source instanceof MultiPoint && sourceGeometry.getNumGeometries() == 1) {
                                destGeometry = ((MultiPoint)source).getGeometryN(0).copy();
                            } else {
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    LOGGER.fine("Converting Geometry " + source.toString() + " to Point. This could be unsafe");
                                }
                                destGeometry = ((Geometry)source).getCentroid();
                            }
                        } else if (LineString.class.isAssignableFrom(target)) {
                            if (sourceGeometry.isEmpty()) {
                                destGeometry = gFac.createLineString(new Coordinate[0]);
                            } else if (source instanceof MultiLineString && sourceGeometry.getNumGeometries() == 1) {
                                destGeometry = ((MultiLineString)source).getGeometryN(0).copy();
                            } else {
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    LOGGER.fine("Converting Geometry " + source.toString() + " to LineString. This could be unsafe");
                                }
                                destGeometry = gFac.createLineString(this.getLineStringCoordinates(((Geometry)source).getCoordinates()));
                            }
                        } else if (Polygon.class.isAssignableFrom(target)) {
                            if (sourceGeometry.isEmpty()) {
                                destGeometry = gFac.createLineString(new Coordinate[0]);
                            } else if (source instanceof MultiPolygon && sourceGeometry.getNumGeometries() == 1) {
                                destGeometry = ((MultiPolygon)source).getGeometryN(0).copy();
                            } else {
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    LOGGER.fine("Converting Geometry " + source.toString() + " to Polygon. This could be unsafe");
                                }
                                Coordinate[] coords = this.getPolygonCoordinates(((Geometry)source).getCoordinates());
                                destGeometry = gFac.createPolygon(gFac.createLinearRing(coords), new LinearRing[0]);
                            }
                        }
                        GeometryTypeConverterFactory.this.copyUserProperties(sourceGeometry, destGeometry);
                        if (destGeometry != null) {
                            destGeometry.setSRID(sourceGeometry.getSRID());
                        }
                        return destGeometry;
                    }
                    return null;
                }

                private <T> T[] arrayCopy(T[] original, int length) {
                    Class<?> arrayType = original.getClass().getComponentType();
                    Object[] copy = (Object[])Array.newInstance(arrayType, length);
                    System.arraycopy(original, 0, copy, 0, original.length < length ? original.length : length);
                    return copy;
                }

                private Coordinate[] growCoordinatesNum(Coordinate[] input, int numpoints) {
                    if (input.length < numpoints) {
                        Object[] newCoordinates = this.arrayCopy(input, numpoints);
                        Arrays.fill(newCoordinates, input.length, numpoints, input[0]);
                        input = newCoordinates;
                    }
                    return input;
                }

                private Coordinate[] getLineStringCoordinates(Coordinate[] coordinates) {
                    coordinates = this.growCoordinatesNum(coordinates, 2);
                    return coordinates;
                }

                private Coordinate[] getPolygonCoordinates(Coordinate[] coordinates) {
                    if (!(coordinates = this.growCoordinatesNum(coordinates, 4))[coordinates.length - 1].equals(coordinates[0])) {
                        Coordinate[] newCoordinates = this.arrayCopy(coordinates, coordinates.length + 1);
                        newCoordinates[newCoordinates.length - 1] = newCoordinates[0];
                        coordinates = newCoordinates;
                    }
                    return coordinates;
                }
            };
        }
        return null;
    }

    protected void copyUserProperties(Geometry sourceGeometry, Geometry destGeometry) {
        if (destGeometry != null) {
            HashMap<Class<CoordinateReferenceSystem>, Object> newUserData = new HashMap<Class<CoordinateReferenceSystem>, Object>();
            if (destGeometry.getUserData() instanceof Map) {
                newUserData.putAll((Map)destGeometry.getUserData());
            } else if (destGeometry.getUserData() instanceof CoordinateReferenceSystem) {
                newUserData.put(CoordinateReferenceSystem.class, destGeometry.getUserData());
            }
            if (sourceGeometry.getUserData() instanceof Map) {
                newUserData.putAll((Map)sourceGeometry.getUserData());
            } else if (sourceGeometry.getUserData() instanceof CoordinateReferenceSystem) {
                newUserData.put(CoordinateReferenceSystem.class, sourceGeometry.getUserData());
            }
            destGeometry.setUserData(newUserData);
        }
    }
}

