/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;

public class CollectionConverterFactory
implements ConverterFactory {
    protected static final Converter CollectionToCollection = new Converter(){

        public Object convert(Object source, Class target) throws Exception {
            if (target.isInstance(source)) {
                return source;
            }
            Collection converted = CollectionConverterFactory.newCollection(target);
            if (converted != null) {
                converted.addAll((Collection)source);
            }
            return converted;
        }
    };
    protected static final Converter CollectionToArray = new Converter(){

        public Object convert(Object source, Class target) throws Exception {
            Collection s2 = (Collection)source;
            Object array = Array.newInstance(target.getComponentType(), s2.size());
            try {
                int x = 0;
                Iterator i = s2.iterator();
                while (i.hasNext()) {
                    Array.set(array, x, i.next());
                    ++x;
                }
                return array;
            }
            catch (Exception exception) {
                return null;
            }
        }
    };
    protected static final Converter ArrayToCollection = new Converter(){

        public Object convert(Object source, Class target) throws Exception {
            Collection collection = CollectionConverterFactory.newCollection(target);
            if (collection != null) {
                int length = Array.getLength(source);
                for (int i = 0; i < length; ++i) {
                    collection.add(Array.get(source, i));
                }
            }
            return collection;
        }
    };
    protected static final Converter ArrayToArray = new Converter(){

        public Object convert(Object source, Class target) throws Exception {
            Class<?> s2 = source.getClass().getComponentType();
            Class<?> t = target.getComponentType();
            if (t.isAssignableFrom(s2)) {
                int length = Array.getLength(source);
                Object converted = Array.newInstance(t, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(converted, i, Array.get(source, i));
                }
                return converted;
            }
            return null;
        }
    };

    protected static Collection newCollection(Class target) throws Exception {
        if (target.isInterface()) {
            if (List.class.isAssignableFrom(target)) {
                return new ArrayList();
            }
            if (SortedSet.class.isAssignableFrom(target)) {
                return new TreeSet();
            }
            if (Set.class.isAssignableFrom(target)) {
                return new HashSet();
            }
            return null;
        }
        return (Collection)target.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public Converter createConverter(Class source, Class target, Hints hints) {
        if ((Collection.class.isAssignableFrom(source) || source.isArray()) && (Collection.class.isAssignableFrom(target) || target.isArray())) {
            if (Collection.class.isAssignableFrom(source) && Collection.class.isAssignableFrom(target)) {
                return CollectionToCollection;
            }
            if (source.isArray() && target.isArray()) {
                return ArrayToArray;
            }
            if (Collection.class.isAssignableFrom(source) && target.isArray()) {
                return CollectionToArray;
            }
            if (source.isArray() && Collection.class.isAssignableFrom(target)) {
                return ArrayToCollection;
            }
        }
        return null;
    }
}

