/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.data.DataSourceException;
import org.geotools.data.Diff;
import org.geotools.data.FeatureReader;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Feature;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.Identifier;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class DiffFeatureReader<T extends FeatureType, F extends Feature>
implements FeatureReader<T, F> {
    FeatureReader<T, F> reader;
    Diff diff;
    F next = null;
    private Filter filter;
    private Set encounteredFids;
    private Iterator<F> addedIterator;
    private Iterator<F> modifiedIterator;
    private Iterator<Identifier> fids;
    private Iterator<F> spatialIndexIterator;
    private boolean indexedGeometryFilter = false;
    private boolean fidFilter = false;

    public DiffFeatureReader(FeatureReader<T, F> reader, Diff diff2) {
        this(reader, diff2, Filter.INCLUDE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiffFeatureReader(FeatureReader<T, F> reader, Diff diff2, Filter filter) {
        this.reader = reader;
        this.diff = diff2;
        this.filter = filter;
        this.encounteredFids = new HashSet();
        if (filter instanceof Id) {
            this.fidFilter = true;
        } else if (this.isSubsetOfBboxFilter(filter)) {
            this.indexedGeometryFilter = true;
        }
        Diff diff = this.diff;
        synchronized (diff) {
            if (this.indexedGeometryFilter) {
                this.spatialIndexIterator = this.getIndexedFeatures().iterator();
            }
            this.addedIterator = this.diff.getAdded().values().iterator();
            this.modifiedIterator = this.diff.getModified().values().iterator();
        }
    }

    @Override
    public T getFeatureType() {
        return this.reader.getFeatureType();
    }

    @Override
    public F next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.hasNext()) {
            F live = this.next;
            this.next = null;
            return live;
        }
        throw new NoSuchElementException("No more Feature exists");
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        if (this.filter == Filter.EXCLUDE) {
            return false;
        }
        while (this.reader != null && this.reader.hasNext()) {
            F peek;
            try {
                peek = this.reader.next();
            }
            catch (NoSuchElementException e2) {
                throw new DataSourceException("Could not aquire the next Feature", e2);
            }
            catch (IllegalAttributeException e3) {
                throw new DataSourceException("Could not aquire the next Feature", e3);
            }
            String fid = peek.getIdentifier().getID();
            this.encounteredFids.add(fid);
            Map<String, SimpleFeature> modified = this.diff.getModified();
            if (modified.containsKey(fid)) {
                Feature changed = modified.get(fid);
                if (changed == Diff.NULL || !this.filter.evaluate(changed)) continue;
                this.next = changed;
                return true;
            }
            this.next = peek;
            return true;
        }
        this.queryDiff();
        return this.next != null;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.diff != null) {
            this.diff = null;
            this.addedIterator = null;
        }
    }

    protected void queryDiff() {
        if (this.fidFilter) {
            this.queryFidFilter();
        } else if (this.indexedGeometryFilter) {
            this.querySpatialIndex();
        } else {
            this.queryAdded();
            this.queryModified();
        }
    }

    protected void querySpatialIndex() {
        while (this.spatialIndexIterator.hasNext() && this.next == null) {
            Feature f = (Feature)this.spatialIndexIterator.next();
            if (this.encounteredFids.contains(f.getIdentifier().getID()) || !this.filter.evaluate(f)) continue;
            this.next = f;
        }
    }

    protected void queryAdded() {
        while (this.addedIterator.hasNext() && this.next == null) {
            this.next = (Feature)this.addedIterator.next();
            if (!this.encounteredFids.contains(this.next.getIdentifier().getID()) && this.filter.evaluate(this.next)) continue;
            this.next = null;
        }
    }

    protected void queryModified() {
        while (this.modifiedIterator.hasNext() && this.next == null) {
            this.next = (Feature)this.modifiedIterator.next();
            if (this.next != Diff.NULL && !this.encounteredFids.contains(this.next.getIdentifier().getID()) && this.filter.evaluate(this.next)) continue;
            this.next = null;
        }
    }

    protected void queryFidFilter() {
        Id fidFilter = (Id)this.filter;
        if (this.fids == null) {
            this.fids = fidFilter.getIdentifiers().iterator();
        }
        while (this.fids.hasNext() && this.next == null) {
            String fid = this.fids.next().toString();
            if (this.encounteredFids.contains(fid)) continue;
            this.next = this.diff.getModified().get(fid);
            if (this.next != null) continue;
            this.next = this.diff.getAdded().get(fid);
        }
    }

    protected List getIndexedFeatures() {
        Envelope env = null;
        env = this.extractBboxForSpatialIndexQuery((BinarySpatialOperator)this.filter);
        return this.diff.queryIndex(env);
    }

    protected Envelope extractBboxForSpatialIndexQuery(BinarySpatialOperator filter) {
        Expression leftGeom = filter.getExpression1();
        Expression rightGeom = filter.getExpression2();
        Object g2 = leftGeom instanceof Literal ? ((Literal)leftGeom).getValue() : ((Literal)rightGeom).getValue();
        Envelope envelope = null;
        if (g2 instanceof Geometry) {
            envelope = ((Geometry)g2).getEnvelopeInternal();
        } else if (g2 instanceof Envelope) {
            envelope = (Envelope)g2;
        }
        return envelope;
    }

    protected boolean isDefaultGeometry(PropertyName ae) {
        return this.reader.getFeatureType().getGeometryDescriptor().getLocalName().equals(ae.getPropertyName());
    }

    protected boolean isSubsetOfBboxFilter(Filter f) {
        return this.filter instanceof Contains || this.filter instanceof Crosses || this.filter instanceof Overlaps || this.filter instanceof Touches || this.filter instanceof Within || this.filter instanceof BBOX;
    }
}

