/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.utils;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.chocosolver.util.graphOperations.connectivity.ConnectivityFinder;
import org.chocosolver.util.objects.graphs.GraphFactory;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.flsgen.grid.neighborhood.INeighborhood;
import org.flsgen.grid.regular.square.RegularSquareGrid;
import org.flsgen.solver.LandscapeGenerator;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.gce.geotiff.GeoTiffReader;

public class CheckLandscape {
    public static final int checkNP(LandscapeGenerator generator, int classId, INeighborhood neighborhood) {
        UndirectedGraph g2 = CheckLandscape.getClassGraph(generator, classId, neighborhood);
        ConnectivityFinder cf = new ConnectivityFinder(g2);
        cf.findAllCC();
        return cf.getNBCC();
    }

    public static final int[] checkAREA(LandscapeGenerator generator, int classId, INeighborhood neighborhood) {
        UndirectedGraph g2 = CheckLandscape.getClassGraph(generator, classId, neighborhood);
        ConnectivityFinder cf = new ConnectivityFinder(g2);
        cf.findAllCC();
        int[] area = new int[cf.getNBCC()];
        for (int i = 0; i < area.length; ++i) {
            area[i] = cf.getSizeCC()[i];
        }
        Arrays.sort(area);
        return area;
    }

    private static UndirectedGraph getClassGraph(LandscapeGenerator generator, int classId, INeighborhood neighborhood) {
        RegularSquareGrid grid = generator.getGrid();
        UndirectedGraph g2 = GraphFactory.makeUndirectedGraph(grid.getNbCells(), SetType.BIPARTITESET, SetType.BIPARTITESET);
        for (int i = 0; i < grid.getNbCells(); ++i) {
            if (generator.getRasterGrid()[i] != classId) continue;
            g2.addNode(i);
        }
        ISetIterator iSetIterator = g2.getNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            for (int j : neighborhood.getNeighbors(grid, i)) {
                if (generator.getRasterGrid()[j] != classId) continue;
                g2.addEdge(i, j);
            }
        }
        return g2;
    }

    public static double getNodataValue(String rasterPath) throws IOException {
        File file = new File(rasterPath);
        GeoTiffReader reader = new GeoTiffReader(file);
        GridCoverage2D gridCov = reader.read(null);
        double noData = CoverageUtilities.getNoDataProperty(gridCov).getAsSingleValue();
        gridCov.dispose(true);
        reader.dispose();
        return noData;
    }

    public static int[] getDimensions(String rasterPath) throws IOException {
        File file = new File(rasterPath);
        GeoTiffReader reader = new GeoTiffReader(file);
        GridCoverage2D gridCov = reader.read(null);
        int nbRows = gridCov.getRenderedImage().getHeight();
        int nbCols = gridCov.getRenderedImage().getWidth();
        return new int[]{nbRows, nbCols};
    }

    public static int[] getNodataCells(String rasterPath) throws IOException {
        int noData = (int)CheckLandscape.getNodataValue(rasterPath);
        File file = new File(rasterPath);
        GeoTiffReader reader = new GeoTiffReader(file);
        GridCoverage2D gridCov = reader.read(null);
        int nbRows = gridCov.getRenderedImage().getHeight();
        int nbCols = gridCov.getRenderedImage().getWidth();
        int[] values = new int[nbRows * nbCols];
        gridCov.getRenderedImage().getData().getSamples(0, 0, nbCols, nbRows, 0, values);
        gridCov.dispose(true);
        reader.dispose();
        return IntStream.range(0, values.length).filter(i -> values[i] == noData).toArray();
    }
}

