/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.ejml.data.FMatrix;
import org.ejml.data.FMatrix1Row;
import org.ejml.data.Matrix;
import org.ejml.data.MatrixType;
import org.ejml.ops.MatrixIO;

public class FMatrixRMaj
extends FMatrix1Row {
    public FMatrixRMaj(int numRows, int numCols, boolean rowMajor, float ... data) {
        int length = numRows * numCols;
        this.data = new float[length];
        this.numRows = numRows;
        this.numCols = numCols;
        this.set(numRows, numCols, rowMajor, data);
    }

    public FMatrixRMaj(float[][] data) {
        this.numRows = data.length;
        this.numCols = data[0].length;
        this.data = new float[this.numRows * this.numCols];
        int pos = 0;
        for (int i = 0; i < this.numRows; ++i) {
            float[] row = data[i];
            if (row.length != this.numCols) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            System.arraycopy(row, 0, this.data, pos, this.numCols);
            pos += this.numCols;
        }
    }

    public FMatrixRMaj(int numRows, int numCols) {
        this.data = new float[numRows * numCols];
        this.numRows = numRows;
        this.numCols = numCols;
    }

    public FMatrixRMaj(FMatrixRMaj orig) {
        this(orig.numRows, orig.numCols);
        System.arraycopy(orig.data, 0, this.data, 0, orig.getNumElements());
    }

    public FMatrixRMaj(int length) {
        this.data = new float[length];
    }

    public FMatrixRMaj() {
    }

    public FMatrixRMaj(FMatrix mat) {
        this(mat.getNumRows(), mat.getNumCols());
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.set(i, j, mat.get(i, j));
            }
        }
    }

    public static FMatrixRMaj wrap(int numRows, int numCols, float[] data) {
        FMatrixRMaj s2 = new FMatrixRMaj();
        s2.data = data;
        s2.numRows = numRows;
        s2.numCols = numCols;
        return s2;
    }

    @Override
    public void reshape(int numRows, int numCols, boolean saveValues) {
        if (this.data.length < numRows * numCols) {
            float[] d2 = new float[numRows * numCols];
            if (saveValues) {
                System.arraycopy(this.data, 0, d2, 0, this.getNumElements());
            }
            this.data = d2;
        }
        this.numRows = numRows;
        this.numCols = numCols;
    }

    @Override
    public void set(int row, int col, float value) {
        if (col < 0 || col >= this.numCols || row < 0 || row >= this.numRows) {
            throw new IllegalArgumentException("Specified element is out of bounds: (" + row + " , " + col + ")");
        }
        this.data[row * this.numCols + col] = value;
    }

    @Override
    public void unsafe_set(int row, int col, float value) {
        this.data[row * this.numCols + col] = value;
    }

    public void add(int row, int col, float value) {
        if (col < 0 || col >= this.numCols || row < 0 || row >= this.numRows) {
            throw new IllegalArgumentException("Specified element is out of bounds");
        }
        int n = row * this.numCols + col;
        this.data[n] = this.data[n] + value;
    }

    @Override
    public float get(int row, int col) {
        if (col < 0 || col >= this.numCols || row < 0 || row >= this.numRows) {
            throw new IllegalArgumentException("Specified element is out of bounds: " + row + " " + col);
        }
        return this.data[row * this.numCols + col];
    }

    @Override
    public float unsafe_get(int row, int col) {
        return this.data[row * this.numCols + col];
    }

    @Override
    public int getIndex(int row, int col) {
        return row * this.numCols + col;
    }

    public boolean isInBounds(int row, int col) {
        return col >= 0 && col < this.numCols && row >= 0 && row < this.numRows;
    }

    @Override
    public int getNumElements() {
        return this.numRows * this.numCols;
    }

    public void set(int numRows, int numCols, boolean rowMajor, float ... data) {
        this.reshape(numRows, numCols);
        int length = numRows * numCols;
        if (length > this.data.length) {
            throw new IllegalArgumentException("The length of this matrix's data array is too small.");
        }
        if (rowMajor) {
            System.arraycopy(data, 0, this.data, 0, length);
        } else {
            int index = 0;
            for (int i = 0; i < numRows; ++i) {
                for (int j = 0; j < numCols; ++j) {
                    this.data[index++] = data[j * numRows + i];
                }
            }
        }
    }

    public void zero() {
        Arrays.fill(this.data, 0, this.getNumElements(), 0.0f);
    }

    public FMatrixRMaj copy() {
        return new FMatrixRMaj(this);
    }

    @Override
    public void set(Matrix original) {
        FMatrix m3 = (FMatrix)original;
        this.reshape(original.getNumRows(), original.getNumCols());
        if (original instanceof FMatrixRMaj) {
            System.arraycopy(((FMatrixRMaj)m3).data, 0, this.data, 0, this.numRows * this.numCols);
        } else {
            int index = 0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    this.data[index++] = m3.get(i, j);
                }
            }
        }
    }

    @Override
    public void print() {
        MatrixIO.print(System.out, this);
    }

    public void printJava(String format) {
        MatrixIO.printJava(System.out, this, format);
    }

    public void print(String format) {
        MatrixIO.print(System.out, this, format);
    }

    public String toString() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        MatrixIO.print(new PrintStream(stream), this);
        return stream.toString();
    }

    @Override
    public <T extends Matrix> T createLike() {
        return (T)new FMatrixRMaj(this.numRows, this.numCols);
    }

    @Override
    public MatrixType getType() {
        return MatrixType.FDRM;
    }
}

