/*
 * Decompiled with CFR 0.152.
 */
package org.ejml;

import org.ejml.UtilEjml;
import org.ejml.data.CMatrix;
import org.ejml.data.Complex_F32;
import org.ejml.data.Complex_F64;
import org.ejml.data.DMatrix;
import org.ejml.data.FMatrix;
import org.ejml.data.Matrix;
import org.ejml.data.ZMatrix;

public class EjmlUnitTests {
    public static void assertCountable(DMatrix A2) {
        for (int i = 0; i < A2.getNumRows(); ++i) {
            for (int j = 0; j < A2.getNumCols(); ++j) {
                EjmlUnitTests.assertTrue(!Double.isNaN(A2.get(i, j)), "NaN found at " + i + " " + j);
                EjmlUnitTests.assertTrue(!Double.isInfinite(A2.get(i, j)), "Infinite found at " + i + " " + j);
            }
        }
    }

    public static void assertShape(Matrix A2, Matrix B) {
        EjmlUnitTests.assertTrue(A2.getNumRows() == B.getNumRows(), "Number of rows do not match");
        EjmlUnitTests.assertTrue(A2.getNumCols() == B.getNumCols(), "Number of columns do not match");
    }

    public static void assertShape(Matrix A2, int numRows, int numCols) {
        EjmlUnitTests.assertTrue(A2.getNumRows() == numRows, "Unexpected number of rows.");
        EjmlUnitTests.assertTrue(A2.getNumCols() == numCols, "Unexpected number of columns.");
    }

    public static void assertEqualsUncountable(DMatrix A2, DMatrix B, double tol) {
        EjmlUnitTests.assertShape(A2, B);
        for (int i = 0; i < A2.getNumRows(); ++i) {
            for (int j = 0; j < A2.getNumCols(); ++j) {
                double valA = A2.get(i, j);
                double valB = B.get(i, j);
                if (Double.isNaN(valA)) {
                    EjmlUnitTests.assertTrue(Double.isNaN(valB), "At (" + i + "," + j + ") A = " + valA + " B = " + valB);
                    continue;
                }
                if (Double.isInfinite(valA)) {
                    EjmlUnitTests.assertTrue(Double.isInfinite(valB), "At (" + i + "," + j + ") A = " + valA + " B = " + valB);
                    continue;
                }
                double diff = Math.abs(valA - valB);
                EjmlUnitTests.assertTrue(diff <= tol, "At (" + i + "," + j + ") A = " + valA + " B = " + valB);
            }
        }
    }

    public static void assertEquals(Matrix A2, Matrix B) {
        if (A2 instanceof DMatrix) {
            EjmlUnitTests.assertEquals((DMatrix)A2, (DMatrix)B, UtilEjml.TEST_F64);
        } else {
            EjmlUnitTests.assertEquals((FMatrix)A2, (FMatrix)B, UtilEjml.TEST_F32);
        }
    }

    public static void assertEquals(DMatrix A2, DMatrix B, double tol) {
        EjmlUnitTests.assertShape(A2, B);
        for (int i = 0; i < A2.getNumRows(); ++i) {
            for (int j = 0; j < A2.getNumCols(); ++j) {
                double valA = A2.get(i, j);
                double valB = B.get(i, j);
                EjmlUnitTests.assertTrue(!Double.isNaN(valA) && !Double.isNaN(valB), "At (" + i + "," + j + ") A = " + valA + " B = " + valB);
                EjmlUnitTests.assertTrue(!Double.isInfinite(valA) && !Double.isInfinite(valB), "At (" + i + "," + j + ") A = " + valA + " B = " + valB);
                EjmlUnitTests.assertTrue(Math.abs(valA - valB) <= tol, "At (" + i + "," + j + ") A = " + valA + " B = " + valB);
            }
        }
    }

    public static void assertRelativeEquals(DMatrix A2, DMatrix B, double tol) {
        EjmlUnitTests.assertShape(A2, B);
        for (int i = 0; i < A2.getNumRows(); ++i) {
            for (int j = 0; j < A2.getNumCols(); ++j) {
                double valA = A2.get(i, j);
                double valB = B.get(i, j);
                if (Double.isNaN(valA) != Double.isNaN(valB) || Double.isInfinite(valA) != Double.isInfinite(valB)) {
                    throw new AssertionError((Object)("At (" + i + "," + j + ") A = " + valA + " B = " + valB));
                }
                double max = Math.max(Math.abs(valA), Math.abs(valB));
                double error = Math.abs(valA - valB) / max;
                if (!(error > tol)) continue;
                System.out.println("------------  A  -----------");
                A2.print();
                System.out.println("\n------------  B  -----------");
                B.print();
                throw new AssertionError((Object)("At (" + i + "," + j + ") A = " + valA + " B = " + valB + "   error = " + error));
            }
        }
    }

    public static void assertEquals(FMatrix A2, FMatrix B, float tol) {
        EjmlUnitTests.assertShape(A2, B);
        for (int i = 0; i < A2.getNumRows(); ++i) {
            for (int j = 0; j < A2.getNumCols(); ++j) {
                float valA = A2.get(i, j);
                float valB = B.get(i, j);
                EjmlUnitTests.assertTrue(!Float.isNaN(valA) && !Float.isNaN(valB), "At (" + i + "," + j + ") A = " + valA + " B = " + valB);
                EjmlUnitTests.assertTrue(!Float.isInfinite(valA) && !Float.isInfinite(valB), "At (" + i + "," + j + ") A = " + valA + " B = " + valB);
                EjmlUnitTests.assertTrue(Math.abs(valA - valB) <= tol, "At (" + i + "," + j + ") A = " + valA + " B = " + valB);
            }
        }
    }

    public static void assertEquals(Complex_F64 a2, Complex_F64 b2, double tol) {
        EjmlUnitTests.assertTrue(!Double.isNaN(a2.real) && !Double.isNaN(b2.real), "real a = " + a2.real + " b = " + b2.real);
        EjmlUnitTests.assertTrue(!Double.isInfinite(a2.real) && !Double.isInfinite(b2.real), "real a = " + a2.real + " b = " + b2.real);
        EjmlUnitTests.assertTrue(Math.abs(a2.real - b2.real) <= tol, "real a = " + a2.real + " b = " + b2.real);
        EjmlUnitTests.assertTrue(!Double.isNaN(a2.imaginary) && !Double.isNaN(b2.imaginary), "imaginary a = " + a2.imaginary + " b = " + b2.imaginary);
        EjmlUnitTests.assertTrue(!Double.isInfinite(a2.imaginary) && !Double.isInfinite(b2.imaginary), "imaginary a = " + a2.imaginary + " b = " + b2.imaginary);
        EjmlUnitTests.assertTrue(Math.abs(a2.imaginary - b2.imaginary) <= tol, "imaginary a = " + a2.imaginary + " b = " + b2.imaginary);
    }

    public static void assertEquals(Complex_F32 a2, Complex_F32 b2, float tol) {
        EjmlUnitTests.assertTrue(!Float.isNaN(a2.real) && !Float.isNaN(b2.real), "real a = " + a2.real + " b = " + b2.real);
        EjmlUnitTests.assertTrue(!Float.isInfinite(a2.real) && !Float.isInfinite(b2.real), "real a = " + a2.real + " b = " + b2.real);
        EjmlUnitTests.assertTrue(Math.abs(a2.real - b2.real) <= tol, "real a = " + a2.real + " b = " + b2.real);
        EjmlUnitTests.assertTrue(!Float.isNaN(a2.imaginary) && !Float.isNaN(b2.imaginary), "imaginary a = " + a2.imaginary + " b = " + b2.imaginary);
        EjmlUnitTests.assertTrue(!Float.isInfinite(a2.imaginary) && !Float.isInfinite(b2.imaginary), "imaginary a = " + a2.imaginary + " b = " + b2.imaginary);
        EjmlUnitTests.assertTrue(Math.abs(a2.imaginary - b2.imaginary) <= tol, "imaginary a = " + a2.imaginary + " b = " + b2.imaginary);
    }

    public static void assertEquals(ZMatrix A2, ZMatrix B, double tol) {
        EjmlUnitTests.assertShape(A2, B);
        Complex_F64 a2 = new Complex_F64();
        Complex_F64 b2 = new Complex_F64();
        for (int i = 0; i < A2.getNumRows(); ++i) {
            for (int j = 0; j < A2.getNumCols(); ++j) {
                A2.get(i, j, a2);
                B.get(i, j, b2);
                EjmlUnitTests.assertTrue(!Double.isNaN(a2.real) && !Double.isNaN(b2.real), "Real At (" + i + "," + j + ") A = " + a2.real + " B = " + b2.real);
                EjmlUnitTests.assertTrue(!Double.isInfinite(a2.real) && !Double.isInfinite(b2.real), "Real At (" + i + "," + j + ") A = " + a2.real + " B = " + b2.real);
                EjmlUnitTests.assertTrue(Math.abs(a2.real - b2.real) <= tol, "Real At (" + i + "," + j + ") A = " + a2.real + " B = " + b2.real);
                EjmlUnitTests.assertTrue(!Double.isNaN(a2.imaginary) && !Double.isNaN(b2.imaginary), "Img At (" + i + "," + j + ") A = " + a2.imaginary + " B = " + b2.imaginary);
                EjmlUnitTests.assertTrue(!Double.isInfinite(a2.imaginary) && !Double.isInfinite(b2.imaginary), "Img At (" + i + "," + j + ") A = " + a2.imaginary + " B = " + b2.imaginary);
                EjmlUnitTests.assertTrue(Math.abs(a2.imaginary - b2.imaginary) <= tol, "Img At (" + i + "," + j + ") A = " + a2.imaginary + " B = " + b2.imaginary);
            }
        }
    }

    public static void assertEquals(CMatrix A2, CMatrix B, float tol) {
        EjmlUnitTests.assertShape(A2, B);
        Complex_F32 a2 = new Complex_F32();
        Complex_F32 b2 = new Complex_F32();
        for (int i = 0; i < A2.getNumRows(); ++i) {
            for (int j = 0; j < A2.getNumCols(); ++j) {
                A2.get(i, j, a2);
                B.get(i, j, b2);
                EjmlUnitTests.assertTrue(!Float.isNaN(a2.real) && !Float.isNaN(b2.real), "Real At (" + i + "," + j + ") A = " + a2.real + " B = " + b2.real);
                EjmlUnitTests.assertTrue(!Float.isInfinite(a2.real) && !Float.isInfinite(b2.real), "Real At (" + i + "," + j + ") A = " + a2.real + " B = " + b2.real);
                EjmlUnitTests.assertTrue(Math.abs(a2.real - b2.real) <= tol, "Real At (" + i + "," + j + ") A = " + a2.real + " B = " + b2.real);
                EjmlUnitTests.assertTrue(!Float.isNaN(a2.imaginary) && !Float.isNaN(b2.imaginary), "Img At (" + i + "," + j + ") A = " + a2.imaginary + " B = " + b2.imaginary);
                EjmlUnitTests.assertTrue(!Float.isInfinite(a2.imaginary) && !Float.isInfinite(b2.imaginary), "Img At (" + i + "," + j + ") A = " + a2.imaginary + " B = " + b2.imaginary);
                EjmlUnitTests.assertTrue(Math.abs(a2.imaginary - b2.imaginary) <= tol, "Img At (" + i + "," + j + ") A = " + a2.imaginary + " B = " + b2.imaginary);
            }
        }
    }

    public static void assertEqualsTrans(DMatrix A2, DMatrix B, double tol) {
        EjmlUnitTests.assertShape(A2, B.getNumCols(), B.getNumRows());
        for (int i = 0; i < A2.getNumRows(); ++i) {
            for (int j = 0; j < A2.getNumCols(); ++j) {
                double valA = A2.get(i, j);
                double valB = B.get(j, i);
                EjmlUnitTests.assertTrue(!Double.isNaN(valA) && !Double.isNaN(valB), "A(" + i + "," + j + ") = " + valA + ") B(" + j + "," + i + ") = " + valB);
                EjmlUnitTests.assertTrue(!Double.isInfinite(valA) && !Double.isInfinite(valB), "A(" + i + "," + j + ") = " + valA + ") B(" + j + "," + i + ") = " + valB);
                EjmlUnitTests.assertTrue(Math.abs(valA - valB) <= tol, "A(" + i + "," + j + ") = " + valA + ") B(" + j + "," + i + ") = " + valB);
            }
        }
    }

    public static void assertEqualsTrans(FMatrix A2, FMatrix B, double tol) {
        EjmlUnitTests.assertShape(A2, B.getNumCols(), B.getNumRows());
        for (int i = 0; i < A2.getNumRows(); ++i) {
            for (int j = 0; j < A2.getNumCols(); ++j) {
                Float valA = Float.valueOf(A2.get(i, j));
                Float valB = Float.valueOf(B.get(j, i));
                EjmlUnitTests.assertTrue(!Float.isNaN(valA.floatValue()) && !Float.isNaN(valB.floatValue()), "A(" + i + "," + j + ") = " + valA + ") B(" + j + "," + i + ") = " + valB);
                EjmlUnitTests.assertTrue(!Float.isInfinite(valA.floatValue()) && !Float.isInfinite(valB.floatValue()), "A(" + i + "," + j + ") = " + valA + ") B(" + j + "," + i + ") = " + valB);
                EjmlUnitTests.assertTrue((double)Math.abs(valA.floatValue() - valB.floatValue()) <= tol, "A(" + i + "," + j + ") = " + valA + ") B(" + j + "," + i + ") = " + valB);
            }
        }
    }

    private static void assertTrue(boolean result, String message) {
        assert (result) : message;
        if (!result) {
            throw new AssertionError((Object)message);
        }
    }
}

