/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.delta.monitor;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.search.loop.TimeStampedObject;
import org.chocosolver.solver.variables.delta.IGraphDelta;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.PairProcedure;

public class GraphDeltaMonitor
extends TimeStampedObject
implements IGraphDeltaMonitor {
    private final IGraphDelta delta;
    private final int[] first;
    private final int[] last;
    private final ICause propagator;

    public GraphDeltaMonitor(IGraphDelta delta, ICause propagator) {
        super(delta.getEnvironment());
        this.delta = delta;
        this.first = new int[4];
        this.last = new int[4];
        this.propagator = propagator;
    }

    @Override
    public void startMonitoring() {
        this.delta.lazyClear();
        this.resetStamp();
        for (int i = 0; i < 3; ++i) {
            this.first[i] = this.last[i] = this.delta.getSize(i);
        }
        this.first[3] = this.last[3] = this.delta.getSize(4);
    }

    private void freeze() {
        int i;
        if (this.getTimeStamp() == -1) {
            throw new SolverException("Delta Monitor created in this is not activated. This should be the last instruction of p.propagate(int) by calling `monitor.startMonitoring()`");
        }
        if (this.needReset()) {
            this.delta.lazyClear();
            for (i = 0; i < 4; ++i) {
                this.first[i] = 0;
            }
            this.resetStamp();
        }
        if (this.getTimeStamp() != ((TimeStampedObject)((Object)this.delta)).getTimeStamp()) {
            throw new SolverException("Delta and monitor are not synchronized. \ndeltamonitor.freeze() is called but no value has been removed since the last call.");
        }
        for (i = 0; i < 3; ++i) {
            this.last[i] = this.delta.getSize(i);
        }
        this.last[3] = this.delta.getSize(4);
    }

    @Override
    public void forEachNode(IntProcedure proc, GraphEventType evt) throws ContradictionException {
        int type;
        this.freeze();
        if (evt == GraphEventType.REMOVE_NODE) {
            type = 0;
        } else if (evt == GraphEventType.ADD_NODE) {
            type = 1;
        } else {
            throw new UnsupportedOperationException("The event in parameter should be ADD_NODE or REMOVE_NODE");
        }
        while (this.first[type] < this.last[type]) {
            if (this.delta.getCause(this.first[type], type) != this.propagator) {
                proc.execute(this.delta.get(this.first[type], type));
            }
            int n = type;
            this.first[n] = this.first[n] + 1;
        }
    }

    @Override
    public void forEachEdge(PairProcedure proc, GraphEventType evt) throws ContradictionException {
        int headType;
        int tailType;
        int idx;
        this.freeze();
        if (evt == GraphEventType.REMOVE_EDGE) {
            idx = 2;
            tailType = 2;
            headType = 3;
        } else if (evt == GraphEventType.ADD_EDGE) {
            idx = 3;
            tailType = 4;
            headType = 5;
        } else {
            throw new UnsupportedOperationException("The event in parameter should be ADD_EDGE or REMOVE_EDGE");
        }
        while (this.first[idx] < this.last[idx]) {
            if (this.delta.getCause(this.first[idx], tailType) != this.propagator) {
                proc.execute(this.delta.get(this.first[idx], tailType), this.delta.get(this.first[idx], headType));
            }
            int n = idx;
            this.first[n] = this.first[n] + 1;
        }
    }
}

