/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropMinElement
extends Propagator<Variable> {
    private final IntVar min;
    private final SetVar set;
    private final int offSet;
    private final int[] weights;
    private final boolean notEmpty;

    public PropMinElement(SetVar setVar, IntVar min2, boolean notEmpty) {
        this(setVar, (int[])null, 0, min2, notEmpty);
    }

    public PropMinElement(SetVar setVar, int[] weights, int offSet, IntVar min2, boolean notEmpty) {
        super(new Variable[]{setVar, min2}, (Priority)PropagatorPriority.BINARY, false);
        this.min = (IntVar)this.vars[1];
        this.set = (SetVar)this.vars[0];
        this.weights = weights;
        this.offSet = offSet;
        this.notEmpty = notEmpty;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return SetEventType.all();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ISetIterator iter = this.set.getLB().iterator();
        while (iter.hasNext()) {
            this.min.updateUpperBound(this.get(iter.nextInt()), this);
        }
        int minVal = Integer.MAX_VALUE;
        int lb = this.min.getLB();
        iter = this.set.getUB().iterator();
        while (iter.hasNext()) {
            int j = iter.nextInt();
            int k = this.get(j);
            if (k < lb) {
                this.set.remove(j, this);
                continue;
            }
            if (minVal <= k) continue;
            minVal = k;
        }
        if (this.notEmpty || this.set.getLB().size() > 0) {
            this.min.updateLowerBound(minVal, this);
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.set.getUB().size() == 0) {
            if (this.notEmpty) {
                return ESat.FALSE;
            }
            return ESat.TRUE;
        }
        int lb = this.min.getLB();
        int ub = this.min.getUB();
        ISetIterator iter = this.set.getLB().iterator();
        while (iter.hasNext()) {
            if (this.get(iter.nextInt()) >= lb) continue;
            return ESat.FALSE;
        }
        int minVal = Integer.MAX_VALUE;
        iter = this.set.getUB().iterator();
        while (iter.hasNext()) {
            int j = iter.nextInt();
            if (minVal <= this.get(j)) continue;
            minVal = this.get(j);
        }
        if (minVal > ub && (this.notEmpty || this.set.getLB().size() > 0)) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private int get(int j) {
        return this.weights == null ? j : this.weights[j - this.offSet];
    }
}

