/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferentprec;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Arrays;
import java.util.BitSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.alldifferentprec.FilterAllDiffPrec;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.bitset.Set_BitSet;

public class AllDiffPrecMoreThanBc
extends FilterAllDiffPrec {
    private final boolean rcFiltering;
    private final int[] next;
    private final BitSet in;
    private final int[] fifo;
    private final int n;
    private final int m;
    private final DirectedGraph digraph;
    private final TIntArrayList removedArcs;
    private final int nbNodes;
    private final boolean[] matched;
    private final BitSet free;
    private final TIntIntHashMap mapValIdx;
    private final int[] mins;
    private final int[] maxs;

    public AllDiffPrecMoreThanBc(IntVar[] variables, boolean[][] precedence) {
        this(variables, precedence, false);
    }

    public AllDiffPrecMoreThanBc(IntVar[] variables, boolean[][] precedence, boolean rcFiltering) {
        super(variables, precedence);
        this.rcFiltering = rcFiltering;
        this.n = variables.length;
        TIntArrayList list = new TIntArrayList();
        for (int i = 0; i < this.n; ++i) {
            int v = variables[i].getLB();
            while (v <= variables[i].getUB()) {
                if (!list.contains(v)) {
                    list.add(v);
                }
                v = variables[i].nextValue(v);
            }
        }
        list.sort();
        int[] values = list.toArray();
        this.m = values.length;
        this.mapValIdx = new TIntIntHashMap();
        for (int j = 0; j < this.m; ++j) {
            this.mapValIdx.put(values[j], j);
        }
        this.matched = new boolean[this.n + this.m];
        this.fifo = new int[this.n + this.m];
        this.free = new BitSet(this.n + this.m);
        this.next = new int[this.n + this.m];
        this.in = new BitSet(this.n + this.m);
        this.digraph = new DirectedGraph(this.n + this.m, SetType.BITSET, SetType.BITSET, true);
        this.mins = new int[this.n];
        this.maxs = new int[this.n];
        this.removedArcs = new TIntArrayList();
        this.nbNodes = this.n + this.m;
    }

    @Override
    public PropagatorPriority getPriority() {
        return PropagatorPriority.CUBIC;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.all();
    }

    private int augmentPath_BFS(int root) {
        this.in.clear();
        int indexFirst = 0;
        int indexLast = 0;
        this.fifo[indexLast++] = root;
        while (indexFirst != indexLast) {
            int x = this.fifo[indexFirst++];
            ISetIterator succs = this.digraph.getPredecessorsOf(x).iterator();
            while (succs.hasNext()) {
                int y = succs.nextInt();
                if (this.in.get(y)) continue;
                this.next[y] = x;
                this.fifo[indexLast++] = y;
                this.in.set(y);
                if (!this.free.get(y)) continue;
                return y;
            }
        }
        return -1;
    }

    private boolean tryToMatch(int i) {
        int mate = this.augmentPath_BFS(i);
        if (mate != -1) {
            this.free.clear(mate);
            this.free.clear(i);
            int tmp = mate;
            while (tmp != i) {
                this.digraph.removeEdge(tmp, this.next[tmp]);
                this.digraph.addEdge(this.next[tmp], tmp);
                tmp = this.next[tmp];
            }
            return true;
        }
        return false;
    }

    private boolean buildDigraph(int var, int val) {
        ISetIterator iterator = this.digraph.getPredecessorsOf(var).iterator();
        int idxVal = this.mapValIdx.get(val) + this.n;
        while (iterator.hasNext()) {
            int idxVal2 = iterator.nextInt();
            if (idxVal2 == idxVal) continue;
            this.digraph.removeEdge(idxVal2, var);
            this.removedArcs.add(var + this.nbNodes * idxVal2);
        }
        this.mins[var] = idxVal;
        this.maxs[var] = idxVal;
        for (int i = 0; i < this.n; ++i) {
            int d2;
            Set_BitSet set;
            if (i == var) continue;
            if (this.precedence[i][var]) {
                if (this.variables[i].getUB() >= val) {
                    set = (Set_BitSet)this.digraph.getPredecessorsOf(i);
                    int max = set.max();
                    d2 = set.nextValue(idxVal);
                    while (d2 <= max && d2 >= 0) {
                        this.digraph.removeEdge(d2, i);
                        this.removedArcs.add(i + this.nbNodes * d2);
                        d2 = set.nextValue(d2 + 1);
                    }
                }
                this.mins[i] = this.mapValIdx.get(this.variables[i].getLB()) + this.n;
                this.maxs[i] = this.mapValIdx.get(this.variables[i].previousValue(val)) + this.n;
            } else if (this.precedence[var][i]) {
                if (this.variables[i].getLB() <= val) {
                    int min2;
                    set = (Set_BitSet)this.digraph.getPredecessorsOf(i);
                    d2 = min2 = set.min();
                    while (d2 <= idxVal && d2 >= 0) {
                        this.digraph.removeEdge(d2, i);
                        this.removedArcs.add(i + this.nbNodes * d2);
                        d2 = set.nextValue(d2 + 1);
                    }
                }
                this.mins[i] = this.mapValIdx.get(this.variables[i].nextValue(val)) + this.n;
                this.maxs[i] = this.mapValIdx.get(this.variables[i].getUB()) + this.n;
            } else {
                if (this.digraph.getPredecessorsOf(i).contains(idxVal)) {
                    this.digraph.removeEdge(idxVal, i);
                    this.removedArcs.add(i + this.nbNodes * idxVal);
                }
                this.mins[i] = this.mapValIdx.get(this.variables[i].getLB()) + this.n;
                this.maxs[i] = this.mapValIdx.get(this.variables[i].getUB()) + this.n;
                if (this.variables[i].getLB() == val) {
                    this.mins[i] = this.mapValIdx.get(this.variables[i].nextValue(val)) + this.n;
                }
                if (this.variables[i].getUB() == val) {
                    this.maxs[i] = this.mapValIdx.get(this.variables[i].previousValue(val)) + this.n;
                }
            }
            if (!this.digraph.getPredecessorsOf(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean updateBoundWithinDigraph(DirectedGraph precedenceGraph, int[] topologicalTraversal, boolean lb) {
        for (int i = 0; i < topologicalTraversal.length; ++i) {
            ISetIterator it;
            int var;
            int n = var = lb ? topologicalTraversal[i] : topologicalTraversal[topologicalTraversal.length - 1 - i];
            if (this.digraph.getPredecessorsOf(var).isEmpty()) {
                return false;
            }
            ISetIterator iSetIterator = it = lb ? precedenceGraph.getSuccessorsOf(var).iterator() : precedenceGraph.getPredecessorsOf(var).iterator();
            while (it.hasNext()) {
                int v = it.nextInt();
                if (this.digraph.getPredecessorsOf(v).isEmpty()) {
                    return false;
                }
                if ((!lb || this.mins[v] > this.mins[var]) && (lb || this.maxs[v] < this.maxs[var])) continue;
                int from = lb ? this.mins[v] : this.maxs[var];
                int to = lb ? this.mins[var] : this.maxs[v];
                for (int k = from; k <= to; ++k) {
                    if (!this.digraph.removeEdge(k, v)) continue;
                    this.removedArcs.add(v + this.nbNodes * k);
                }
                if (this.digraph.getPredecessorsOf(v).isEmpty()) {
                    return false;
                }
                if (lb) {
                    this.mins[v] = this.digraph.getPredecessorsOf(v).min();
                    continue;
                }
                this.maxs[v] = this.digraph.getPredecessorsOf(v).max();
            }
        }
        return true;
    }

    private void greedyMatch() {
        Arrays.fill(this.matched, false);
        for (int varIdx = 0; varIdx < this.n; ++varIdx) {
            ISetIterator iterator = this.digraph.getPredecessorsOf(varIdx).iterator();
            while (!this.matched[varIdx] && iterator.hasNext()) {
                int tmp = iterator.nextInt();
                if (this.matched[tmp]) continue;
                this.digraph.removeEdge(tmp, varIdx);
                this.digraph.addEdge(varIdx, tmp);
                this.matched[varIdx] = true;
                this.matched[tmp] = true;
            }
        }
    }

    private void restoreDigraph() {
        for (int varIdx = 0; varIdx < this.n; ++varIdx) {
            if (this.digraph.getSuccessorsOf(varIdx).isEmpty()) continue;
            int idxVal = this.digraph.getSuccessorsOf(varIdx).min();
            this.digraph.removeEdge(varIdx, idxVal);
            this.digraph.addEdge(idxVal, varIdx);
        }
        for (int k = 0; k < this.removedArcs.size(); ++k) {
            int tmp = this.removedArcs.getQuick(k);
            int varIdx = tmp % this.nbNodes;
            int idxVal = tmp / this.nbNodes;
            this.digraph.addEdge(idxVal, varIdx);
        }
        this.removedArcs.clear();
    }

    private boolean findMaximumMatching(int var, int value, DirectedGraph precedenceGraph, int[] topologicalTraversal) {
        boolean update;
        if (!this.buildDigraph(var, value)) {
            this.restoreDigraph();
            return false;
        }
        boolean bl = update = this.updateBoundWithinDigraph(precedenceGraph, topologicalTraversal, true) && this.updateBoundWithinDigraph(precedenceGraph, topologicalTraversal, false);
        if (!update) {
            this.restoreDigraph();
            return false;
        }
        this.greedyMatch();
        this.free.clear();
        this.free.set(0, this.n + this.m);
        int nbMatched = 0;
        for (int k = 0; k < this.n; ++k) {
            if (this.digraph.getSuccessorsOf(k).isEmpty()) continue;
            ++nbMatched;
            this.free.clear(k);
            this.free.clear(this.digraph.getSuccessorsOf(k).min());
        }
        if (nbMatched < this.n) {
            boolean augmentedPathFound;
            do {
                augmentedPathFound = false;
                int node = this.free.nextSetBit(0);
                while (node >= 0 && node < this.n) {
                    augmentedPathFound |= this.tryToMatch(node);
                    node = this.free.nextSetBit(node + 1);
                }
            } while (augmentedPathFound);
            nbMatched = 0;
            for (int varIdx = 0; varIdx < this.n; ++varIdx) {
                if (this.digraph.getSuccessorsOf(varIdx).isEmpty()) continue;
                ++nbMatched;
            }
        }
        this.restoreDigraph();
        return nbMatched == this.n;
    }

    @Override
    public boolean propagate(DirectedGraph precedenceGraph, int[] topologicalTraversal, ICause aCause) throws ContradictionException {
        for (int k = 0; k < this.n + this.m; ++k) {
            this.digraph.getPredecessorsOf(k).clear();
            this.digraph.getSuccessorsOf(k).clear();
        }
        for (int i = 0; i < this.n; ++i) {
            int d2 = this.variables[i].getLB();
            while (d2 <= this.variables[i].getUB()) {
                this.digraph.addEdge(this.mapValIdx.get(d2) + this.n, i);
                d2 = this.variables[i].nextValue(d2);
            }
        }
        boolean hasFiltered = false;
        for (int var = 0; var < this.n; ++var) {
            if (this.rcFiltering) {
                int val = this.variables[var].getLB();
                while (val <= this.variables[var].getUB()) {
                    if (!this.findMaximumMatching(var, val, precedenceGraph, topologicalTraversal)) {
                        hasFiltered |= this.variables[var].removeValue(val, aCause);
                        this.digraph.removeEdge(this.mapValIdx.get(val) + this.n, var);
                    }
                    val = this.variables[var].nextValue(val);
                }
                continue;
            }
            while (!this.findMaximumMatching(var, this.variables[var].getLB(), precedenceGraph, topologicalTraversal)) {
                this.digraph.removeEdge(this.mapValIdx.get(this.variables[var].getLB()) + this.n, var);
                hasFiltered |= this.variables[var].removeValue(this.variables[var].getLB(), aCause);
            }
            while (!this.findMaximumMatching(var, this.variables[var].getUB(), precedenceGraph, topologicalTraversal)) {
                this.digraph.removeEdge(this.mapValIdx.get(this.variables[var].getUB()) + this.n, var);
                hasFiltered |= this.variables[var].removeValue(this.variables[var].getUB(), aCause);
            }
        }
        return hasFiltered;
    }
}

